/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.IdeaSourceProvider;
import com.android.tools.idea.projectsystem.SourceProviders;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.jvm.checkers.DalvikIdentifierUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getHostTestsPaths", "", "Ljava/io/File;", "module", "Lcom/intellij/openapi/module/Module;", "getIoFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "JunitPaths", "intellij.android.kotlin.idea.common"})
@SourceDebugExtension(value={"SMAP\nIllegalIdentifierInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IllegalIdentifierInspection.kt\norg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1863#2,2:142\n1557#2:144\n1628#2,3:145\n1#3:148\n*S KotlinDebug\n*F\n+ 1 IllegalIdentifierInspection.kt\norg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection\n*L\n123#1:142,2\n127#1:144\n127#1:145,3\n*E\n"})
public final class IllegalIdentifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new KtVisitorVoid(holder, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ IllegalIdentifierInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ASTNode aSTNode = element.getNode();
                if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.IDENTIFIER)) {
                    return;
                }
                String text = element.getText();
                Intrinsics.checkNotNull((Object)text);
                if (!StringsKt.startsWith$default((CharSequence)text, (char)'`', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)text, (char)'`', (boolean)false, (int)2, null)) {
                    return;
                }
                String string = KtPsiUtil.unquoteIdentifier((String)text);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteIdentifier(...)");
                String unquotedName = string;
                if (((CharSequence)unquotedName).length() == 0) {
                    return;
                }
                if (!DalvikIdentifierUtils.isValidDalvikIdentifier((String)unquotedName) && this.checkAndroidFacet(element)) {
                    if (this.isInHostTests(element) || this.isInBuildKtsFile(element)) {
                        return;
                    }
                    AndroidFacet facet = AndroidFacet.getInstance((PsiElement)element);
                    if (facet != null && !facet.isDisposed() && StudioAndroidModuleInfo.getInstance((AndroidFacet)facet).getMinSdkVersion().getApiLevel() >= 30) {
                        return;
                    }
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new RenameIdentifierFix()};
                    this.$holder.registerProblem(element, "Identifier not allowed in Android projects", ProblemHighlightType.GENERIC_ERROR, localQuickFixArray);
                }
            }

            private final boolean isInBuildKtsFile(PsiElement $this$isInBuildKtsFile) {
                Object object;
                return Intrinsics.areEqual((Object)$this$isInBuildKtsFile.getLanguage(), (Object)KotlinLanguage.INSTANCE) && ((object = $this$isInBuildKtsFile.getContainingFile()) != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)"gradle.kts", (boolean)false, (int)2, null) : false);
            }

            /*
             * Unable to fully structure code
             */
            private final boolean isInHostTests(PsiElement $this$isInHostTests) {
                block9: {
                    block8: {
                        v0 = $this$isInHostTests.getContainingFile();
                        if (v0 != null && (v0 = v0.getVirtualFile()) != null) {
                            var5_2 = v0;
                            var6_3 = this.this$0;
                            it = var5_2;
                            $i$a$-let-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$containingFile$1 = false;
                            v1 = IllegalIdentifierInspection.access$getIoFile(var6_3, (VirtualFile)it);
                        } else {
                            v1 = null;
                        }
                        containingFile = v1;
                        module = AndroidPsiUtils.getModuleSafely((PsiElement)$this$isInHostTests);
                        if (module == null || containingFile == null) break block9;
                        currentGenerationId = ProjectRootModificationTracker.getInstance((Project)module.getProject()).getModificationCount();
                        it = (JunitPaths)module.getUserData((Key)JunitPaths.Companion);
                        if (it == null) ** GOTO lbl-1000
                        it = var9_11 = it;
                        $i$a$-takeIf-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$hostTestPaths$1 = false;
                        v2 = $i$a$-let-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$containingFile$1 = it.getGenerationId() == currentGenerationId != false ? var9_11 : null;
                        if ($i$a$-let-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$containingFile$1 != null) {
                            v3 = $i$a$-let-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$containingFile$1;
                        } else lbl-1000:
                        // 2 sources

                        {
                            it = var9_11 = new JunitPaths(IllegalIdentifierInspection.access$getHostTestsPaths(this.this$0, module), currentGenerationId);
                            $i$a$-also-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$hostTestPaths$2 = false;
                            module.putUserData((Key)JunitPaths.Companion, it);
                            v3 = var9_11;
                        }
                        hostTestPaths = v3;
                        $this$any$iv = hostTestPaths.getPaths();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v4 = false;
                        } else {
                            for (E element$iv : $this$any$iv) {
                                it = (File)element$iv;
                                $i$a$-any-IllegalIdentifierInspection$buildVisitor$1$isInHostTests$1 = false;
                                if (!FilesKt.startsWith((File)containingFile, (File)it)) continue;
                                v4 = true;
                                break block8;
                            }
                            v4 = false;
                        }
                    }
                    if (v4) {
                        return true;
                    }
                }
                return false;
            }

            private final boolean checkAndroidFacet(PsiElement element) {
                return ModuleExtensionsKt.getAndroidFacet((PsiElement)element) != null || ApplicationManager.getApplication().isUnitTestMode();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getHostTestsPaths(Module module) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IdeaSourceProvider it;
        Iterable iterable;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        AndroidFacet androidFacet2 = androidFacet;
        Collection hostTestSources = SourceProviders.Companion.getInstance(androidFacet2).getHostTestSources().values();
        List $this$getHostTestsPaths_u24lambda_u241 = iterable = (List)new ArrayList();
        boolean $i$a$-apply-IllegalIdentifierInspection$getHostTestsPaths$22 = false;
        Iterable $this$forEach$iv = hostTestSources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IdeaSourceProvider)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$getHostTestsPaths_u24lambda_u241, (Iterable)it.getJavaDirectories());
            CollectionsKt.addAll((Collection)$this$getHostTestsPaths_u24lambda_u241, (Iterable)it.getKotlinDirectories());
        }
        iterable = iterable;
        boolean $i$f$map = false;
        void $i$a$-apply-IllegalIdentifierInspection$getHostTestsPaths$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileExtensions.toIoFile((VirtualFile)it));
        }
        return (List)destination$iv$iv;
    }

    private final File getIoFile(VirtualFile virtualFile) {
        File file;
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Object path = string;
        if (((String)path).length() == 2 && SystemInfo.isWindows && OSAgnosticPathUtil.startsWithWindowsDrive((String)path)) {
            path = (String)path + "/";
        }
        File it = file = new File((String)path);
        boolean bl = false;
        return it.exists() ? file : null;
    }

    public static final /* synthetic */ List access$getHostTestsPaths(IllegalIdentifierInspection $this, Module module) {
        return $this.getHostTestsPaths(module);
    }

    public static final /* synthetic */ File access$getIoFile(IllegalIdentifierInspection $this, VirtualFile virtualFile) {
        return $this.getIoFile(virtualFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths;", "", "paths", "", "Ljava/io/File;", "generationId", "", "<init>", "(Ljava/util/List;J)V", "getPaths", "()Ljava/util/List;", "getGenerationId", "()J", "Companion", "intellij.android.kotlin.idea.common"})
    private static final class JunitPaths {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<File> paths;
        private final long generationId;

        public JunitPaths(@NotNull List<? extends File> paths, long generationId) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            this.paths = paths;
            this.generationId = generationId;
        }

        @NotNull
        public final List<File> getPaths() {
            return this.paths;
        }

        public final long getGenerationId() {
            return this.generationId;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths$Companion;", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths;", "<init>", "()V", "intellij.android.kotlin.idea.common"})
        public static final class Companion
        extends Key<JunitPaths> {
            private Companion() {
                super("AndroidModuleJunitPaths");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

