/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.components;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.CustomAutoFormatSyntaxErrorsVerifier;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class ClangFormatAutoFormatSyntaxErrorsVerifier
implements CustomAutoFormatSyntaxErrorsVerifier {
    public boolean isApplicable(@NotNull PsiElement context) {
        if (context == null) {
            ClangFormatAutoFormatSyntaxErrorsVerifier.$$$reportNull$$$0(0);
        }
        return ((ClangFormatSettings)CodeStyle.getSettings((Project)context.getProject()).getCustomSettings(ClangFormatSettings.class)).ENABLED;
    }

    public boolean checkValid(@NotNull PsiElement context) {
        if (context == null) {
            ClangFormatAutoFormatSyntaxErrorsVerifier.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"clang.format.on.save.check.errors")) {
            return true;
        }
        try {
            Project project = context.getProject();
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted((Project)project);
            if (service == null) {
                return false;
            }
            ClangParseResponse response = service.getParsed(context.getContainingFile().getVirtualFile());
            if (response == null) {
                return false;
            }
            Supplier diagnosticsSupplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAndWriteActionAware((Future)response.getDiagnostics(), (String)"clangd diagnostics for auto format");
            if (diagnosticsSupplier == null) {
                return false;
            }
            List diagnostics = (List)diagnosticsSupplier.get();
            return diagnostics == null || ContainerUtil.filter((Collection)diagnostics, d -> d.getSeverity() == HighlightSeverity.ERROR && !ClangUtils.isFromIncludedFile((ClangDiagnostic)d)).isEmpty();
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/jetbrains/clangFormat/components/ClangFormatAutoFormatSyntaxErrorsVerifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

