/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.statistics;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.statistics.BuildSession;
import org.jetbrains.kotlin.statistics.fileloggers.MetricsContainer;
import org.jetbrains.kotlin.statistics.metrics.BooleanMetrics;
import org.jetbrains.kotlin.statistics.metrics.NumericalMetrics;
import org.jetbrains.kotlin.statistics.metrics.StatisticsValuesConsumer;
import org.jetbrains.kotlin.statistics.metrics.StringMetrics;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u0015\u001a\u00020\tJ1\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001cJ1\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\u001eJ1\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u00142\b\u0010\u001b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010 J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0014J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0014H\u0002R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger;", "Lorg/jetbrains/kotlin/statistics/metrics/StatisticsValuesConsumer;", "rootPath", "Ljava/io/File;", "maxProfileFiles", "", "maxFileAge", "", "forceValuesValidation", "", "(Ljava/io/File;IJZ)V", "buildSession", "Lorg/jetbrains/kotlin/statistics/BuildSession;", "metricsContainer", "Lorg/jetbrains/kotlin/statistics/fileloggers/MetricsContainer;", "statisticsFolder", "clearOldFiles", "", "finishBuildSession", "getActiveBuildId", "", "isBuildSessionStarted", "report", "metric", "Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;", "value", "subprojectName", "weight", "(Lorg/jetbrains/kotlin/statistics/metrics/BooleanMetrics;ZLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;", "(Lorg/jetbrains/kotlin/statistics/metrics/NumericalMetrics;JLjava/lang/String;Ljava/lang/Long;)Z", "Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;", "(Lorg/jetbrains/kotlin/statistics/metrics/StringMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Z", "startBuildSession", "buildUid", "storeMetricsIntoFile", "buildId", "Companion", "kotlin-gradle-statistics"})
@SourceDebugExtension(value={"SMAP\nBuildSessionLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class BuildSessionLogger
implements StatisticsValuesConsumer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxProfileFiles;
    private final long maxFileAge;
    @NotNull
    private final File statisticsFolder;
    @Nullable
    private BuildSession buildSession;
    @NotNull
    private final MetricsContainer metricsContainer;
    @NotNull
    public static final String PROFILE_FILE_NAME_SUFFIX = ".profile";
    @NotNull
    public static final String STATISTICS_FOLDER_NAME = "kotlin-profile";
    @NotNull
    private static final Regex STATISTICS_FILE_NAME_PATTERN = new Regex("[\\w-]*.profile");
    private static final int DEFAULT_MAX_PROFILE_FILES = 1000;
    private static final long DEFAULT_MAX_FILE_AGE = 2592000000L;

    /*
     * WARNING - void declaration
     */
    public BuildSessionLogger(@NotNull File rootPath, int maxProfileFiles, long maxFileAge, boolean forceValuesValidation) {
        void it;
        File file;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        this.maxProfileFiles = maxProfileFiles;
        this.maxFileAge = maxFileAge;
        File file2 = file = new File(rootPath, STATISTICS_FOLDER_NAME);
        BuildSessionLogger buildSessionLogger = this;
        boolean bl = false;
        it.mkdirs();
        buildSessionLogger.statisticsFolder = file;
        this.metricsContainer = new MetricsContainer(forceValuesValidation);
    }

    public /* synthetic */ BuildSessionLogger(File file, int n, long l, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        if ((n2 & 4) != 0) {
            l = 2592000000L;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(file, n, l, bl);
    }

    public final synchronized void startBuildSession(@NotNull String buildUid) {
        Intrinsics.checkNotNullParameter((Object)buildUid, (String)"buildUid");
        this.buildSession = new BuildSession(buildUid);
    }

    public final synchronized boolean isBuildSessionStarted() {
        return this.buildSession != null;
    }

    @Nullable
    public final synchronized String getActiveBuildId() {
        BuildSession buildSession = this.buildSession;
        return buildSession != null ? buildSession.getBuildUid() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void storeMetricsIntoFile(String buildId) {
        try {
            this.statisticsFolder.mkdirs();
            File file = new File(this.statisticsFolder, UUID.randomUUID().toString() + PROFILE_FILE_NAME_SUFFIX);
            Closeable closeable = new FileOutputStream(file);
            Object object = Charsets.UTF_8;
            Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
            int n = 8192;
            closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
            object = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)closeable;
                boolean bl = false;
                writer2.write("Build: " + buildId);
                this.metricsContainer.flush(writer2);
                writer = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void clearOldFiles() {
        List<File> fileCandidates = Companion.listProfileFiles(this.statisticsFolder);
        Iterator iterator = ((Iterable)fileCandidates).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            long lastModified;
            int index2 = n++;
            File file = (File)iterator.next();
            boolean toDelete = index2 < fileCandidates.size() - this.maxProfileFiles ? true : (lastModified = file.lastModified()) > 0L && System.currentTimeMillis() - this.maxFileAge > lastModified;
            if (!toDelete) continue;
            file.delete();
        }
    }

    public final synchronized void finishBuildSession() {
        BuildSession buildSession = this.buildSession;
        if (buildSession != null) {
            BuildSession buildSession2;
            BuildSession it = buildSession2 = buildSession;
            boolean bl = false;
            this.storeMetricsIntoFile(it.getBuildUid());
        }
        this.buildSession = null;
        this.clearOldFiles();
    }

    @Override
    public boolean report(@NotNull BooleanMetrics metric, boolean value, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.metricsContainer.report(metric, value, subprojectName, weight);
    }

    @Override
    public boolean report(@NotNull NumericalMetrics metric, long value, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        return this.metricsContainer.report(metric, value, subprojectName, weight);
    }

    @Override
    public boolean report(@NotNull StringMetrics metric, @NotNull String value, @Nullable String subprojectName, @Nullable Long weight) {
        Intrinsics.checkNotNullParameter((Object)((Object)metric), (String)"metric");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.metricsContainer.report(metric, value, subprojectName, weight);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion;", "", "()V", "DEFAULT_MAX_FILE_AGE", "", "DEFAULT_MAX_PROFILE_FILES", "", "PROFILE_FILE_NAME_SUFFIX", "", "STATISTICS_FILE_NAME_PATTERN", "Lkotlin/text/Regex;", "getSTATISTICS_FILE_NAME_PATTERN", "()Lkotlin/text/Regex;", "STATISTICS_FOLDER_NAME", "listProfileFiles", "", "Ljava/io/File;", "statisticsFolder", "kotlin-gradle-statistics"})
    @SourceDebugExtension(value={"SMAP\nBuildSessionLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1563#2:117\n1634#2,3:118\n774#2:121\n865#2,2:122\n1056#2:124\n*S KotlinDebug\n*F\n+ 1 BuildSessionLogger.kt\norg/jetbrains/kotlin/statistics/BuildSessionLogger$Companion\n*L\n32#1:117\n32#1:118,3\n33#1:121\n33#1:122,2\n34#1:124\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getSTATISTICS_FILE_NAME_PATTERN() {
            return STATISTICS_FILE_NAME_PATTERN;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<File> listProfileFiles(@NotNull File statisticsFolder) {
            List list2;
            Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
            Closeable closeable = Files.newDirectoryStream(statisticsFolder.toPath());
            Throwable throwable = null;
            try {
                void $this$sortedBy$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                File it;
                void $this$mapTo$iv$iv;
                DirectoryStream dirStream = (DirectoryStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)dirStream, (String)"dirStream");
                Iterable $this$map$iv = dirStream;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path path2 = (Path)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toFile());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (File)element$iv$iv;
                    boolean bl3 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    CharSequence charSequence = string;
                    if (!Companion.getSTATISTICS_FILE_NAME_PATTERN().matches(charSequence)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$sortedBy = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        File it = (File)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.lastModified());
                        it = (File)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

