/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.printing;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.nj2k.JKImportStorage;
import org.jetbrains.kotlin.nj2k.UtilsKt;
import org.jetbrains.kotlin.nj2k.printing.CanBeShortenedCache;
import org.jetbrains.kotlin.nj2k.printing.PrintingUtilsKt;
import org.jetbrains.kotlin.nj2k.symbols.JKClassSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKMultiverseFunctionSymbol;
import org.jetbrains.kotlin.nj2k.symbols.JKSymbol;
import org.jetbrains.kotlin.nj2k.tree.JKElement;
import org.jetbrains.kotlin.nj2k.tree.JKExpression;
import org.jetbrains.kotlin.nj2k.tree.JKQualifiedExpression;
import org.jetbrains.kotlin.nj2k.tree.JKTreeElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKSymbolRenderer;", "", "importStorage", "Lorg/jetbrains/kotlin/nj2k/JKImportStorage;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/kotlin/nj2k/JKImportStorage;Lcom/intellij/openapi/project/Project;)V", "canBeShortenedClassNameCache", "Lorg/jetbrains/kotlin/nj2k/printing/CanBeShortenedCache;", "isFqNameExpected", "", "Lorg/jetbrains/kotlin/nj2k/symbols/JKSymbol;", "owner", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "renderSymbol", "", "symbol", "Companion", "kotlin.j2k.shared"})
public final class JKSymbolRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JKImportStorage importStorage;
    @NotNull
    private final CanBeShortenedCache canBeShortenedClassNameCache;
    @NotNull
    private static final String JAVA_LANG_FQ_PREFIX = "java.lang";

    public JKSymbolRenderer(@NotNull JKImportStorage importStorage, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)importStorage, (String)"importStorage");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.importStorage = importStorage;
        this.canBeShortenedClassNameCache = new CanBeShortenedCache(project);
    }

    private final boolean isFqNameExpected(JKSymbol $this$isFqNameExpected, JKTreeElement owner) {
        JKTreeElement jKTreeElement = owner;
        boolean bl = jKTreeElement != null ? JKSymbolRenderer.Companion.isSelectorOfQualifiedExpression(jKTreeElement) : false;
        if (bl) {
            return false;
        }
        if (Intrinsics.areEqual((Object)$this$isFqNameExpected.getFqName(), (Object)"kotlin.run")) {
            return false;
        }
        if (JKSymbolRenderer.Companion.isTopLevelBuiltInKotlinFunction($this$isFqNameExpected)) {
            return true;
        }
        return $this$isFqNameExpected instanceof JKClassSymbol || org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isStaticMember($this$isFqNameExpected) || org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isEnumConstant($this$isFqNameExpected);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String renderSymbol(@NotNull JKSymbol symbol, @Nullable JKTreeElement owner) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        String name2 = UtilsKt.escaped(symbol.getName());
        String fqName2 = PrintingUtilsKt.escapedAsQualifiedName(org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getDisplayFqName(symbol));
        if (!this.isFqNameExpected(symbol, owner)) {
            if (JKSymbolRenderer.Companion.isTopLevelBuiltInKotlinFunction(symbol) && JKImportStorage.isImportNeeded$default(this.importStorage, fqName2, false, 2, null)) {
                this.importStorage.addImport(fqName2);
            }
            object = name2;
            return object;
        }
        if (JKSymbolRenderer.Companion.isFromJavaLangPackage(symbol)) {
            object = fqName2;
            return object;
        }
        if (symbol instanceof JKClassSymbol && this.canBeShortenedClassNameCache.canBeShortened((JKClassSymbol)symbol)) {
            this.importStorage.addImport(fqName2);
            object = name2;
            return object;
        }
        if (org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isStaticMember(symbol)) {
            JKClassSymbol jKClassSymbol = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(symbol);
            boolean bl = jKClassSymbol != null ? org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isUnnamedCompanion(jKClassSymbol) : false;
            if (bl) {
                JKClassSymbol jKClassSymbol2 = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(symbol);
                if (jKClassSymbol2 == null) {
                    return fqName2;
                }
                JKClassSymbol containingClass = jKClassSymbol2;
                JKClassSymbol jKClassSymbol3 = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(containingClass);
                if (jKClassSymbol3 == null) {
                    return fqName2;
                }
                JKClassSymbol classContainingCompanion = jKClassSymbol3;
                if (!this.canBeShortenedClassNameCache.canBeShortened(classContainingCompanion)) {
                    return fqName2;
                }
                this.importStorage.addImport(org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getDisplayFqName(classContainingCompanion));
                object = UtilsKt.escaped(classContainingCompanion.getName()) + "." + SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT + "." + name2;
                return object;
            }
        }
        if (!org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isEnumConstant(symbol) && !org.jetbrains.kotlin.nj2k.symbols.UtilsKt.isStaticMember(symbol)) {
            object = fqName2;
            return object;
        }
        JKClassSymbol jKClassSymbol = org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getContainingClass(symbol);
        if (jKClassSymbol == null) {
            return fqName2;
        }
        JKClassSymbol containingClass = jKClassSymbol;
        if (!this.canBeShortenedClassNameCache.canBeShortened(containingClass)) {
            return fqName2;
        }
        this.importStorage.addImport(org.jetbrains.kotlin.nj2k.symbols.UtilsKt.getDisplayFqName(containingClass));
        object = UtilsKt.escaped(containingClass.getName()) + "." + name2;
        return object;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\f\u001a\u00020\u0007*\u00020\bH\u0002J\f\u0010\r\u001a\u00020\u0007*\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\tR\u0018\u0010\n\u001a\u00020\u0007*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/nj2k/printing/JKSymbolRenderer$Companion;", "", "<init>", "()V", "JAVA_LANG_FQ_PREFIX", "", "isTopLevelBuiltInKotlinFunction", "", "Lorg/jetbrains/kotlin/nj2k/symbols/JKSymbol;", "(Lorg/jetbrains/kotlin/nj2k/symbols/JKSymbol;)Z", "isKotlinPackagePrefix", "(Ljava/lang/String;)Z", "isFromJavaLangPackage", "isSelectorOfQualifiedExpression", "Lorg/jetbrains/kotlin/nj2k/tree/JKTreeElement;", "kotlin.j2k.shared"})
    @SourceDebugExtension(value={"SMAP\nJKSymbolRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JKSymbolRenderer.kt\norg/jetbrains/kotlin/nj2k/printing/JKSymbolRenderer$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,118:1\n123#2:119\n*S KotlinDebug\n*F\n+ 1 JKSymbolRenderer.kt\norg/jetbrains/kotlin/nj2k/printing/JKSymbolRenderer$Companion\n*L\n88#1:119\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTopLevelBuiltInKotlinFunction(JKSymbol $this$isTopLevelBuiltInKotlinFunction) {
            return $this$isTopLevelBuiltInKotlinFunction instanceof JKMultiverseFunctionSymbol && this.isKotlinPackagePrefix(((JKMultiverseFunctionSymbol)$this$isTopLevelBuiltInKotlinFunction).getFqName()) && ((JKMultiverseFunctionSymbol)$this$isTopLevelBuiltInKotlinFunction).getTarget().getParent() instanceof KtFile;
        }

        private final boolean isKotlinPackagePrefix(String $this$isKotlinPackagePrefix) {
            return Intrinsics.areEqual((Object)$this$isKotlinPackagePrefix, (Object)"kotlin") || StringsKt.startsWith$default((String)$this$isKotlinPackagePrefix, (String)"kotlin.", (boolean)false, (int)2, null);
        }

        private final boolean isFromJavaLangPackage(JKSymbol $this$isFromJavaLangPackage) {
            return StringsKt.startsWith$default((String)$this$isFromJavaLangPackage.getFqName(), (String)JKSymbolRenderer.JAVA_LANG_FQ_PREFIX, (boolean)false, (int)2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private final boolean isSelectorOfQualifiedExpression(JKTreeElement $this$isSelectorOfQualifiedExpression) {
            JKExpression jKExpression;
            JKElement jKElement = $this$isSelectorOfQualifiedExpression.getParent();
            if (jKElement != null) {
                JKElement $this$safeAs$iv = jKElement;
                boolean $i$f$safeAs = false;
                JKElement jKElement2 = $this$safeAs$iv;
                if (!(jKElement2 instanceof JKQualifiedExpression)) {
                    jKElement2 = null;
                }
                if ((jKElement = (JKQualifiedExpression)jKElement2) != null) {
                    jKExpression = ((JKQualifiedExpression)jKElement).getSelector();
                    return Intrinsics.areEqual(jKExpression, (Object)$this$isSelectorOfQualifiedExpression);
                }
            }
            jKExpression = null;
            return Intrinsics.areEqual(jKExpression, (Object)$this$isSelectorOfQualifiedExpression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

