/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiJavaFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.WithProgressProcessor;
import org.jetbrains.kotlin.nj2k.KotlinNJ2KBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J7\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014JD\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0005\"\u0004\b\u0000\u0010\u0017\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00170\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u0017\u0012\u0004\u0012\u0002H\u00160\u001dH\u0016J!\u0010\u001e\u001a\u0002H\u001f\"\u0004\b\u0000\u0010\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001f0!H\u0016\u00a2\u0006\u0002\u0010\"R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/nj2k/NewJ2kWithProgressProcessor;", "Lorg/jetbrains/kotlin/j2k/WithProgressProcessor;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "files", "", "Lcom/intellij/psi/PsiJavaFile;", "phasesCount", "", "<init>", "(Lcom/intellij/openapi/progress/ProgressIndicator;Ljava/util/List;I)V", "updateState", "", "fileIndex", "phase", "description", "", "(Ljava/lang/Integer;ILjava/lang/String;)V", "subPhase", "subPhaseCount", "(IIILjava/lang/Integer;Ljava/lang/String;)V", "processItems", "TOutputItem", "TInputItem", "fractionPortion", "", "inputItems", "", "processItem", "Lkotlin/Function1;", "process", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "kotlin.j2k.shared"})
public final class NewJ2kWithProgressProcessor
implements WithProgressProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ProgressIndicator progressIndicator;
    @Nullable
    private final List<PsiJavaFile> files;
    private final int phasesCount;
    @NotNull
    private static final NewJ2kWithProgressProcessor DEFAULT = new NewJ2kWithProgressProcessor(null, null, 0);

    public NewJ2kWithProgressProcessor(@Nullable ProgressIndicator progressIndicator, @Nullable List<? extends PsiJavaFile> files, int phasesCount) {
        block0: {
            this.progressIndicator = progressIndicator;
            this.files = files;
            this.phasesCount = phasesCount;
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 == null) break block0;
            progressIndicator2.setIndeterminate(false);
        }
    }

    @Override
    public void updateState(@Nullable Integer fileIndex, int phase, @NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        if (fileIndex == null) {
            this.updateState(phase, 1, 1, null, description);
        } else {
            this.updateState(phase, 0, 1, fileIndex, description);
        }
    }

    @Override
    public void updateState(int phase, int subPhase, int subPhaseCount, @Nullable Integer fileIndex, @NotNull String description) {
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            ProgressManager.checkCanceled();
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator != null) {
                progressIndicator.checkCanceled();
            }
            double singlePhaseFraction = 1.0 / (double)this.phasesCount;
            double singleSubPhaseFraction = singlePhaseFraction / (double)subPhaseCount;
            double resultFraction = (double)phase * singlePhaseFraction + (double)subPhase * singleSubPhaseFraction;
            if (this.files != null && fileIndex != null && !((Collection)this.files).isEmpty()) {
                double fileFraction = singleSubPhaseFraction / (double)this.files.size();
                resultFraction += fileFraction * (double)fileIndex.intValue();
            }
            ProgressIndicator progressIndicator2 = this.progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setFraction(resultFraction);
            }
            if (subPhaseCount > 1) {
                ProgressIndicator progressIndicator3 = this.progressIndicator;
                if (progressIndicator3 != null) {
                    object = new Object[]{description, subPhase, subPhaseCount, phase + 1, this.phasesCount};
                    progressIndicator3.setText(KotlinNJ2KBundle.message("subphase.progress.text", (Object[])object));
                }
            } else {
                ProgressIndicator progressIndicator4 = this.progressIndicator;
                if (progressIndicator4 != null) {
                    object = new Object[]{description, phase + 1, this.phasesCount};
                    progressIndicator4.setText(KotlinNJ2KBundle.message("progress.text", (Object[])object));
                }
            }
            ProgressIndicator progressIndicator5 = this.progressIndicator;
            if (progressIndicator5 == null) break block7;
            object = this.files;
            progressIndicator5.setText2((String)(!(object == null || object.isEmpty()) && fileIndex != null ? this.files.get(fileIndex).getVirtualFile().getPresentableUrl() + (String)(this.files.size() > 1 ? " (" + fileIndex + "/" + this.files.size() + ")" : "") : ""));
        }
    }

    @Override
    @NotNull
    public <TInputItem, TOutputItem> List<TOutputItem> processItems(double fractionPortion, @NotNull Iterable<? extends TInputItem> inputItems, @NotNull Function1<? super TInputItem, ? extends TOutputItem> processItem) {
        Intrinsics.checkNotNullParameter(inputItems, (String)"inputItems");
        Intrinsics.checkNotNullParameter(processItem, (String)"processItem");
        throw new AbstractMethodError("Should not be called for new J2K");
    }

    @Override
    public <T> T process(@NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (T)action.invoke();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/nj2k/NewJ2kWithProgressProcessor$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/nj2k/NewJ2kWithProgressProcessor;", "getDEFAULT", "()Lorg/jetbrains/kotlin/nj2k/NewJ2kWithProgressProcessor;", "kotlin.j2k.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NewJ2kWithProgressProcessor getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

