/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Operator;
import org.jetbrains.kotlin.j2k.ast.UtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/BinaryExpression;", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "left", "right", "op", "Lorg/jetbrains/kotlin/j2k/ast/Operator;", "<init>", "(Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Operator;)V", "getLeft", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "getRight", "getOp", "()Lorg/jetbrains/kotlin/j2k/ast/Operator;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "kotlin.j2k.k1.old"})
public final class BinaryExpression
extends Expression {
    @NotNull
    private final Expression left;
    @NotNull
    private final Expression right;
    @NotNull
    private final Operator op;

    public BinaryExpression(@NotNull Expression left, @NotNull Expression right, @NotNull Operator op) {
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        this.left = left;
        this.right = right;
        this.op = op;
    }

    @NotNull
    public final Expression getLeft() {
        return this.left;
    }

    @NotNull
    public final Expression getRight() {
        return this.right;
    }

    @NotNull
    public final Operator getOp() {
        return this.op;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        UtilKt.appendOperand(UtilKt.appendOperand(builder2, this, this.left, false).append(" ").append(this.op).append(" "), this, this.right, true);
    }
}

