/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.statistics.KotlinModuleSizeCollectorState;

@Service(value={Service.Level.PROJECT})
@State(name="Project", storages={@Storage(value="$CACHE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\r\u0010\u000e\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u001a\u0010\u0005\u001a\u00020\u0002X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorTracker;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorState;", "<init>", "()V", "currentState", "getCurrentState$kotlin_base_statistics", "()Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorState;", "setCurrentState$kotlin_base_statistics", "(Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorState;)V", "getState", "loadState", "", "state", "onCollectionFinished", "onCollectionFinished$kotlin_base_statistics", "shouldCollectData", "", "shouldCollectData$kotlin_base_statistics", "Companion", "kotlin.base.statistics"})
public final class KotlinModuleSizeCollectorTracker
implements PersistentStateComponent<KotlinModuleSizeCollectorState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private KotlinModuleSizeCollectorState currentState = new KotlinModuleSizeCollectorState();
    private static final Duration DURATION_BETWEEN_COLLECTION = Duration.ofDays(14L);

    @NotNull
    public final KotlinModuleSizeCollectorState getCurrentState$kotlin_base_statistics() {
        return this.currentState;
    }

    public final void setCurrentState$kotlin_base_statistics(@NotNull KotlinModuleSizeCollectorState kotlinModuleSizeCollectorState) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinModuleSizeCollectorState), (String)"<set-?>");
        this.currentState = kotlinModuleSizeCollectorState;
    }

    @NotNull
    public KotlinModuleSizeCollectorState getState() {
        return this.currentState;
    }

    public void loadState(@NotNull KotlinModuleSizeCollectorState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.currentState = state;
    }

    public final void onCollectionFinished$kotlin_base_statistics() {
        this.currentState.setLastProjectScan(Instant.now().getEpochSecond());
    }

    public final boolean shouldCollectData$kotlin_base_statistics() {
        long lastProjectScan = this.getState().getLastProjectScan();
        if (lastProjectScan == 0L) {
            return true;
        }
        Instant lastCollection = Instant.ofEpochSecond(lastProjectScan);
        return Duration.between(lastCollection, Instant.now()).compareTo(DURATION_BETWEEN_COLLECTION) > 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorTracker$Companion;", "", "<init>", "()V", "DURATION_BETWEEN_COLLECTION", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "Ljava/time/Duration;", "getInstance", "Lorg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorTracker;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.statistics"})
    @SourceDebugExtension(value={"SMAP\nKotlinModuleSizeCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinModuleSizeCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorTracker$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,231:1\n31#2,2:232\n*S KotlinDebug\n*F\n+ 1 KotlinModuleSizeCollector.kt\norg/jetbrains/kotlin/idea/statistics/KotlinModuleSizeCollectorTracker$Companion\n*L\n209#1:232,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinModuleSizeCollectorTracker getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinModuleSizeCollectorTracker> serviceClass$iv = KotlinModuleSizeCollectorTracker.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinModuleSizeCollectorTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

