/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.slicer.AbstractKotlinSliceUsage;
import org.jetbrains.kotlin.idea.codeInsight.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsage;
import org.jetbrains.kotlin.idea.slicer.OutflowSlicer;
import org.jetbrains.kotlin.idea.slicer.SliceProducer;
import org.jetbrains.kotlin.idea.slicer.SliceProducerKt;
import org.jetbrains.kotlin.idea.slicer.SlicerKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0010H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/LambdaCallsBehaviour;", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/KotlinSliceAnalysisMode$Behaviour;", "sliceProducer", "Lorg/jetbrains/kotlin/idea/slicer/SliceProducer;", "<init>", "(Lorg/jetbrains/kotlin/idea/slicer/SliceProducer;)V", "processUsages", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "parent", "Lorg/jetbrains/kotlin/idea/codeInsight/slicer/AbstractKotlinSliceUsage;", "uniqueProcessor", "Lcom/intellij/util/Processor;", "Lcom/intellij/slicer/SliceUsage;", "slicePresentationPrefix", "", "getSlicePresentationPrefix", "()Ljava/lang/String;", "testPresentationPrefix", "getTestPresentationPrefix", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "kotlin.idea"})
public final class LambdaCallsBehaviour
implements KotlinSliceAnalysisMode.Behaviour {
    @NotNull
    private final SliceProducer sliceProducer;

    public LambdaCallsBehaviour(@NotNull SliceProducer sliceProducer) {
        Intrinsics.checkNotNullParameter((Object)sliceProducer, (String)"sliceProducer");
        this.sliceProducer = sliceProducer;
    }

    @Override
    public void processUsages(@NotNull KtElement element, @NotNull AbstractKotlinSliceUsage parent2, @NotNull Processor<? super SliceUsage> uniqueProcessor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)((Object)parent2), (String)"parent");
        Intrinsics.checkNotNullParameter(uniqueProcessor, (String)"uniqueProcessor");
        Processor<SliceUsage> processor2 = new Processor<SliceUsage>(this, parent2, uniqueProcessor){
            final /* synthetic */ LambdaCallsBehaviour this$0;
            final /* synthetic */ AbstractKotlinSliceUsage $parent;
            final /* synthetic */ Processor<? super SliceUsage> $uniqueProcessor;
            {
                this.this$0 = $receiver;
                this.$parent = $parent;
                this.$uniqueProcessor = $uniqueProcessor;
            }

            public boolean process(SliceUsage sliceUsage) {
                Intrinsics.checkNotNullParameter((Object)sliceUsage, (String)"sliceUsage");
                if (sliceUsage instanceof KotlinSliceUsage && ((KotlinSliceUsage)sliceUsage).getMode().getCurrentBehaviour() == this.this$0) {
                    ResolvedCall resolvedCall;
                    PsiElement psiElement = ((KotlinSliceUsage)sliceUsage).getElement();
                    if (psiElement == null) {
                        return true;
                    }
                    PsiElement sliceElement = psiElement;
                    KtElement ktElement = sliceElement instanceof KtElement ? (KtElement)sliceElement : null;
                    ResolvedCall resolvedCall2 = resolvedCall = ktElement != null ? ResolutionUtils.resolveToCall$default(ktElement, null, 1, null) : null;
                    if (resolvedCall != null) {
                        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
                        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
                        if (SlicerKt.isImplicitInvokeFunction(callableDescriptor)) {
                            KotlinSliceAnalysisMode originalMode = ((KotlinSliceUsage)sliceUsage).getMode().dropBehaviour();
                            KtElement ktElement2 = resolvedCall.getCall().getCallElement();
                            Intrinsics.checkNotNullExpressionValue((Object)ktElement2, (String)"getCallElement(...)");
                            KotlinSliceUsage newSliceUsage = new KotlinSliceUsage((PsiElement)ktElement2, this.$parent, originalMode, true);
                            return SliceProducerKt.produceAndProcess(LambdaCallsBehaviour.access$getSliceProducer$p(this.this$0), newSliceUsage, originalMode, this.$parent, this.$uniqueProcessor);
                        }
                    }
                }
                return this.$uniqueProcessor.process((Object)sliceUsage);
            }
        };
        new OutflowSlicer(element, (Processor<? super SliceUsage>)((Processor)processor2), parent2).processChildren(parent2.getForcedExpressionMode());
    }

    @Override
    @NotNull
    public String getSlicePresentationPrefix() {
        return KotlinBundle.message((String)"slicer.text.tracking.lambda.calls", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getTestPresentationPrefix() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_testPresentationPrefix__u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_testPresentationPrefix__u24lambda_u241.append("[LAMBDA CALLS");
        String string = this.sliceProducer.getTestPresentation();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$_get_testPresentationPrefix__u24lambda_u241.append(" ");
            $this$_get_testPresentationPrefix__u24lambda_u241.append(it);
        }
        $this$_get_testPresentationPrefix__u24lambda_u241.append("] ");
        return stringBuilder.toString();
    }

    private final SliceProducer component1() {
        return this.sliceProducer;
    }

    @NotNull
    public final LambdaCallsBehaviour copy(@NotNull SliceProducer sliceProducer) {
        Intrinsics.checkNotNullParameter((Object)sliceProducer, (String)"sliceProducer");
        return new LambdaCallsBehaviour(sliceProducer);
    }

    public static /* synthetic */ LambdaCallsBehaviour copy$default(LambdaCallsBehaviour lambdaCallsBehaviour, SliceProducer sliceProducer, int n, Object object) {
        if ((n & 1) != 0) {
            sliceProducer = lambdaCallsBehaviour.sliceProducer;
        }
        return lambdaCallsBehaviour.copy(sliceProducer);
    }

    @NotNull
    public String toString() {
        return "LambdaCallsBehaviour(sliceProducer=" + this.sliceProducer + ")";
    }

    @Override
    public int hashCode() {
        return this.sliceProducer.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LambdaCallsBehaviour)) {
            return false;
        }
        LambdaCallsBehaviour lambdaCallsBehaviour = (LambdaCallsBehaviour)other;
        return Intrinsics.areEqual((Object)this.sliceProducer, (Object)lambdaCallsBehaviour.sliceProducer);
    }

    public static final /* synthetic */ SliceProducer access$getSliceProducer$p(LambdaCallsBehaviour $this) {
        return $this.sliceProducer;
    }
}

