/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.ideaExtensions;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaPartiallyAppliedSymbolKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightField;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.asJava.elements.KtLightParameter;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.projectStructure.scope.KotlinSourceFilterScope;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.search.ExpectActualSupport;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.SearchUtilKt;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinAwareReferencesSearchParameters;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearchOptions;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinReferencesSearcher$QueryProcessor$process$lambda$29$lambda$28$lambda$27$;
import org.jetbrains.kotlin.idea.search.ideaExtensions.KotlinRequestResultProcessor;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.DestructuringDeclarationReferenceSearcher;
import org.jetbrains.kotlin.idea.search.usagesSearch.operators.OperatorReferenceSearcher;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtEnumEntrySuperclassReferenceExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "QueryProcessor", "kotlin.base.analysis"})
public final class KotlinReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        QueryProcessor processor2 = new QueryProcessor(queryParameters, consumer);
        processor2.process();
        processor2.executeLongRunningTasks();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0012J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0019H\u0003J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020 H\u0003J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001b\u001a\u00020#H\u0003J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020%H\u0003J\u0016\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001c0(H\u0002J \u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\r\u001a\u00020\u000eH\u0003J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020#H\u0003J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u00020#H\u0002J6\u00103\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010 2\n\b\u0002\u00104\u001a\u0004\u0018\u00010-2\u0016\b\u0002\u00105\u001a\u0010\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u000207\u0018\u000106H\u0003J\f\u00108\u001a\u000209*\u00020\u0006H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u000f\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0012 \u0013*\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher$QueryProcessor;", "", "queryParameters", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "<init>", "(Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;Lcom/intellij/util/Processor;)V", "getQueryParameters", "()Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "getConsumer", "()Lcom/intellij/util/Processor;", "kotlinOptions", "Lorg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearchOptions;", "longTasks", "Lcom/intellij/util/containers/ConcurrentList;", "Lkotlin/Function0;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "executeLongRunningTasks", "process", "searchNamedArguments", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "searchLightElements", "element", "Lcom/intellij/psi/PsiElement;", "searchPropertyAccessorMethods", "origin", "searchMethodAware", "Lcom/intellij/psi/PsiNamedElement;", "findAllRelatedActualsOrSelf", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "processKtClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "searchForComponentConventions", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "searchDataClassComponentUsages", "containingClass", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "componentMethodName", "", "processStaticsFromCompanionObject", "findStaticMethodsFromCompanionObject", "", "Lcom/intellij/psi/PsiMethod;", "declaration", "searchNamedElement", "name", "modifyScope", "Lkotlin/Function1;", "Lcom/intellij/psi/search/SearchScope;", "isNamedArgumentReference", "", "kotlin.base.analysis"})
    @SourceDebugExtension(value={"SMAP\nKotlinReferencesSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReferencesSearcher.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher$QueryProcessor\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 8 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 9 analyze.kt\norg/jetbrains/kotlin/analysis/api/AnalyzeKt\n+ 10 KaSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/session/KaSessionProvider\n*L\n1#1,570:1\n123#2:571\n123#2:664\n1#3:572\n1#3:644\n808#4,11:573\n1368#4:584\n1454#4,5:585\n1863#4,2:590\n1863#4,2:592\n808#4,11:594\n1557#4:605\n1628#4,3:606\n1863#4:609\n1863#4,2:610\n1864#4:612\n1863#4,2:614\n808#4,11:617\n1368#4:628\n1454#4,5:629\n1611#4,9:634\n1863#4:643\n1864#4:645\n1620#4:646\n1863#4,2:647\n295#4,2:654\n1863#4,2:658\n808#4,11:665\n1863#4:676\n1864#4:697\n213#5:613\n213#5:616\n213#5:649\n213#5:660\n11158#6:650\n11493#6,3:651\n1310#6,2:656\n3829#6:661\n4344#6,2:662\n223#7,2:677\n477#8:679\n1317#8:680\n1318#8:696\n30#9,2:681\n35#10,13:683\n*S KotlinDebug\n*F\n+ 1 KotlinReferencesSearcher.kt\norg/jetbrains/kotlin/idea/search/ideaExtensions/KotlinReferencesSearcher$QueryProcessor\n*L\n166#1:571\n236#1:664\n445#1:644\n329#1:573,11\n330#1:584\n330#1:585,5\n332#1:590,2\n349#1:592,2\n356#1:594,11\n357#1:605\n357#1:606,3\n358#1:609\n359#1:610,2\n358#1:612\n369#1:614,2\n399#1:617,11\n400#1:628\n400#1:629,5\n445#1:634,9\n445#1:643\n445#1:645\n445#1:646\n447#1:647,2\n460#1:654,2\n525#1:658,2\n263#1:665,11\n263#1:676\n263#1:697\n366#1:613\n379#1:616\n453#1:649\n533#1:660\n456#1:650\n456#1:651,3\n512#1:656,2\n536#1:661\n536#1:662,2\n264#1:677,2\n264#1:679\n264#1:680\n264#1:696\n265#1:681,2\n265#1:683,13\n*E\n"})
    private static final class QueryProcessor {
        @NotNull
        private final ReferencesSearch.SearchParameters queryParameters;
        @NotNull
        private final Processor<? super PsiReference> consumer;
        @NotNull
        private final KotlinReferencesSearchOptions kotlinOptions;
        @NotNull
        private final ConcurrentList<Function0<Unit>> longTasks;

        public QueryProcessor(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            this.queryParameters = queryParameters;
            this.consumer = consumer;
            ReferencesSearch.SearchParameters $this$safeAs$iv = this.queryParameters;
            boolean $i$f$safeAs = false;
            ReferencesSearch.SearchParameters searchParameters2 = $this$safeAs$iv;
            if (!(searchParameters2 instanceof KotlinAwareReferencesSearchParameters)) {
                searchParameters2 = null;
            }
            if ((object = (KotlinAwareReferencesSearchParameters)searchParameters2) == null || (object = object.getKotlinOptions()) == null) {
                object = KotlinReferencesSearchOptions.Companion.getEmpty();
            }
            this.kotlinOptions = object;
            ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
            this.longTasks = concurrentList;
        }

        @NotNull
        public final ReferencesSearch.SearchParameters getQueryParameters() {
            return this.queryParameters;
        }

        @NotNull
        public final Processor<? super PsiReference> getConsumer() {
            return this.consumer;
        }

        public final void executeLongRunningTasks() {
            while (!((Collection)this.longTasks).isEmpty()) {
                ((Function0)AddToStdlibKt.popLast((List)((List)this.longTasks))).invoke();
            }
        }

        public final void process() {
            block3: {
                Ref.ObjectRef element = new Ref.ObjectRef();
                Ref.ObjectRef classNameForCompanionObject = new Ref.ObjectRef();
                Project project = this.queryParameters.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Pair pair = (Pair)DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> QueryProcessor.process$lambda$0(this, element, classNameForCompanionObject));
                if (pair == null) {
                    return;
                }
                Pair pair2 = pair;
                Object object = pair2.component1();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component1(...)");
                SmartPsiElementPointer elementToSearchPointer = (SmartPsiElementPointer)object;
                SearchScope effectiveSearchScope = (SearchScope)pair2.component2();
                if ((PsiElement)ActionsKt.runReadAction(() -> QueryProcessor.process$lambda$1(element)) == null) {
                    return;
                }
                ActionsKt.runReadAction(() -> QueryProcessor.process$lambda$29(elementToSearchPointer, this, element, classNameForCompanionObject, effectiveSearchScope));
                if (!this.kotlinOptions.getSearchForComponentConventions()) break block3;
                SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)element.element;
                if (smartPsiElementPointer != null) {
                    SmartPsiElementPointer p0 = smartPsiElementPointer;
                    boolean bl = false;
                    this.searchForComponentConventions((SmartPsiElementPointer<PsiElement>)p0);
                }
            }
        }

        private final void searchNamedArguments(KtParameter parameter) {
            String string = parameter.getName();
            if (string == null) {
                return;
            }
            String parameterName2 = string;
            KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
            KtFunction ktFunction = ktDeclarationWithBody instanceof KtFunction ? (KtFunction)ktDeclarationWithBody : null;
            if (ktFunction == null) {
                return;
            }
            KtFunction function = ktFunction;
            Name name2 = function.getNameAsName();
            if (!(name2 != null ? !name2.isSpecial() : false)) {
                return;
            }
            Project project = function.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            SearchScope searchScope = function.getUseScope().intersectWith(this.queryParameters.getScopeDeterminedByUser());
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"intersectWith(...)");
            SearchScope namedArgsScope = searchScope;
            if (namedArgsScope instanceof GlobalSearchScope) {
                namedArgsScope = (SearchScope)KotlinSourceFilterScope.Companion.everything((GlobalSearchScope)namedArgsScope, project2);
                CacheManager cacheManager = CacheManager.getInstance((Project)project2);
                String string2 = function.getName();
                Intrinsics.checkNotNull((Object)string2);
                Object[] objectArray = cacheManager.getVirtualFilesWithWord(string2, (short)1, (GlobalSearchScope)namedArgsScope, true);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getVirtualFilesWithWord(...)");
                Object[] filesWithFunctionName = objectArray;
                namedArgsScope = (SearchScope)GlobalSearchScope.filesScope((Project)project2, (Collection)ArraysKt.asList((Object[])filesWithFunctionName));
            }
            KotlinRequestResultProcessor processor2 = new KotlinRequestResultProcessor((PsiElement)parameter, null, arg_0 -> QueryProcessor.searchNamedArguments$lambda$31(this, arg_0), null, 10, null);
            this.queryParameters.getOptimizer().searchWord(parameterName2, namedArgsScope, (short)32, true, (PsiElement)parameter, (RequestResultProcessor)processor2);
        }

        /*
         * WARNING - void declaration
         */
        @RequiresReadLock
        private final void searchLightElements(PsiElement element) {
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            PsiElement psiElement = element;
            if (psiElement instanceof KtClassOrObject) {
                this.processKtClassOrObject((KtClassOrObject)element);
            } else if (psiElement instanceof KtConstructor) {
                Iterator $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Iterable iterable = this.findAllRelatedActualsOrSelf((KtDeclaration)element);
                boolean $i$f$filterIsInstance = false;
                void var7_14 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtConstructor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator = $this$flatMapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv$iv;
                    element$iv$iv = iterator.next();
                    KtConstructor it = (KtConstructor)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = LightClassUtil.INSTANCE.getLightClassMethods((KtFunction)it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List psiMethods = (List)destination$iv$iv;
                Iterable $this$forEach$iv = psiMethods;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiMethod psiMethod = (PsiMethod)element$iv;
                    boolean bl3 = false;
                    SmartPsiElementPointer pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)psiMethod));
                    this.longTasks.add(() -> QueryProcessor.searchLightElements$lambda$36$lambda$35(pointer, this, project2));
                }
            } else if (psiElement instanceof KtNamedFunction) {
                String string = ((KtNamedFunction)element).getName();
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    Iterable $this$forEach$iv = LightClassUtil.INSTANCE.getLightClassMethods((KtFunction)element);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiNamedElement p0 = (PsiNamedElement)element$iv;
                        boolean bl2 = false;
                        QueryProcessor.searchNamedElement$default(this, p0, null, null, 6, null);
                    }
                }
                this.processStaticsFromCompanionObject((KtDeclaration)element);
            } else if (psiElement instanceof KtProperty) {
                Iterator $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Iterable $this$forEach$iv = this.findAllRelatedActualsOrSelf((KtDeclaration)element);
                boolean $i$f$filterIsInstance = false;
                void bl = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtProperty)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl3 = $this$mapTo$iv$iv.iterator();
                while (bl3.hasNext()) {
                    void it;
                    Object item$iv$iv = bl3.next();
                    KtProperty p0 = (KtProperty)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtProperty)it));
                }
                List propertyAccessors = (List)destination$iv$iv;
                $this$forEach$iv = propertyAccessors;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LightClassUtil.PropertyAccessorsPsiMethods propertyAccessor = (LightClassUtil.PropertyAccessorsPsiMethods)element$iv;
                    boolean bl5 = false;
                    Iterable $this$forEach$iv2 = propertyAccessor.getAllDeclarations();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        PsiNamedElement p0 = (PsiNamedElement)element$iv2;
                        boolean bl6 = false;
                        QueryProcessor.searchNamedElement$default(this, p0, null, null, 6, null);
                    }
                }
                this.processStaticsFromCompanionObject((KtDeclaration)element);
            } else if (psiElement instanceof KtParameter) {
                this.searchPropertyAccessorMethods((KtParameter)element);
                PsiElement $this$getStrictParentOfType$iv = element;
                boolean $i$f$getStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtPrimaryConstructor.class, (boolean)true) != null) {
                    List parameterDeclarations = LightClassUtil.INSTANCE.getLightClassPropertyMethods((KtParameter)element).getAllDeclarations();
                    Iterable $this$forEach$iv = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.filterDataClassComponentsIfDisabled(parameterDeclarations, this.kotlinOptions);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiNamedElement p0 = (PsiNamedElement)element$iv;
                        boolean bl = false;
                        QueryProcessor.searchNamedElement$default(this, p0, null, null, 6, null);
                    }
                }
            } else if (psiElement instanceof KtLightMethod) {
                KtDeclaration declaration = (KtDeclaration)((KtLightMethod)element).getKotlinOrigin();
                if (declaration instanceof KtProperty || declaration instanceof KtParameter && ((KtParameter)declaration).hasValOrVar()) {
                    QueryProcessor.searchNamedElement$default(this, (PsiNamedElement)declaration, null, null, 6, null);
                    this.processStaticsFromCompanionObject(declaration);
                } else if (declaration instanceof KtPropertyAccessor) {
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)declaration;
                    boolean $i$f$getStrictParentOfType = false;
                    KtProperty property = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtProperty.class, (boolean)true);
                    QueryProcessor.searchNamedElement$default(this, (PsiNamedElement)property, null, null, 6, null);
                } else if (declaration instanceof KtFunction) {
                    this.processStaticsFromCompanionObject(declaration);
                    if (((KtLightMethod)element).isMangled()) {
                        QueryProcessor.searchNamedElement$default(this, (PsiNamedElement)declaration, null, QueryProcessor::searchLightElements$lambda$42, 2, null);
                    }
                }
            } else if (psiElement instanceof KtLightParameter) {
                KtParameter ktParameter = (KtParameter)((KtLightParameter)element).getKotlinOrigin();
                if (ktParameter == null) {
                    return;
                }
                KtParameter origin = ktParameter;
                this.searchPropertyAccessorMethods(origin);
            }
        }

        /*
         * WARNING - void declaration
         */
        @RequiresReadLock
        private final void searchPropertyAccessorMethods(KtParameter origin) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.findAllRelatedActualsOrSelf((KtDeclaration)origin);
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtParameter)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = LightClassUtilsKt.toLightElements((KtElement)((KtElement)it));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List lightMethods = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            List namedElements = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.filterDataClassComponentsIfDisabled(lightMethods, this.kotlinOptions);
            for (PsiNamedElement element : namedElements) {
                this.searchMethodAware(element);
            }
        }

        @RequiresReadLock
        private final void searchMethodAware(PsiNamedElement element) {
            if (element instanceof PsiMethod) {
                SmartPsiElementPointer pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element));
                this.longTasks.add(() -> QueryProcessor.searchMethodAware$lambda$46(pointer, this));
            } else {
                QueryProcessor.searchNamedElement$default(this, element, null, null, 6, null);
            }
        }

        @RequiresReadLock
        private final Set<KtDeclaration> findAllRelatedActualsOrSelf(KtDeclaration element) {
            KtDeclaration expectDeclaration;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ExpectActualSupport expectActualSupport = ExpectActualSupport.Companion.getInstance(project);
            return KtPsiUtilKt.isExpectDeclaration((KtDeclaration)element) ? ExpectActualSupport.actualsForExpect$default(expectActualSupport, element, null, 2, null) : (!this.kotlinOptions.getSearchForExpectedUsages() ? SetsKt.setOf((Object)element) : ((expectDeclaration = expectActualSupport.expectDeclarationIfAny(element)) == null ? SetsKt.setOf((Object)element) : ExpectActualSupport.actualsForExpect$default(expectActualSupport, expectDeclaration, null, 2, null)));
        }

        /*
         * WARNING - void declaration
         */
        @RequiresReadLock
        private final void processKtClassOrObject(KtClassOrObject element) {
            Iterator $this$mapNotNullTo$iv$iv;
            if (element.getName() == null) {
                return;
            }
            Iterable $this$mapNotNull$iv = this.findAllRelatedActualsOrSelf((KtDeclaration)element);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KtLightClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                KtDeclaration it = (KtDeclaration)element$iv$iv;
                boolean bl2 = false;
                KtClassOrObject ktClassOrObject = it instanceof KtClassOrObject ? (KtClassOrObject)it : null;
                if ((ktClassOrObject != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)ktClassOrObject) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List lightClasses = (List)destination$iv$iv;
            Iterable $this$forEach$iv = lightClasses;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiNamedElement p0 = (PsiNamedElement)element$iv;
                boolean bl = false;
                QueryProcessor.searchNamedElement$default(this, p0, null, null, 6, null);
            }
            if (element instanceof KtObjectDeclaration && ((KtObjectDeclaration)element).isCompanion()) {
                PsiField psiField2 = LightClassUtil.INSTANCE.getLightFieldForCompanionObject(element);
                if (psiField2 != null) {
                    PsiNamedElement p0 = (PsiNamedElement)psiField2;
                    boolean bl = false;
                    QueryProcessor.searchNamedElement$default(this, p0, null, null, 6, null);
                }
                if (this.kotlinOptions.getAcceptCompanionObjectMembers()) {
                    KtLightClass originLightClass;
                    PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
                    boolean $i$f$getStrictParentOfType = false;
                    KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
                    Object object = originLightClass = ktClass != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass)) : null;
                    if (originLightClass != null) {
                        Collection collection;
                        Object[] $this$mapTo$iv$iv;
                        PsiMethod[] psiMethodArray = originLightClass.getMethods();
                        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
                        Object[] $this$map$iv = psiMethodArray;
                        boolean $i$f$map = false;
                        Object[] p0 = $this$map$iv;
                        Iterable destination$iv$iv2 = new ArrayList($this$map$iv.length);
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PsiMethod bl = (PsiMethod)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl4 = false;
                            collection.add(it instanceof KtLightMethod ? (KtLightMethod)it : null);
                        }
                        Collection collection2 = (List)destination$iv$iv2;
                        PsiField[] psiFieldArray = originLightClass.getFields();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                        $this$map$iv = psiFieldArray;
                        collection = collection2;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv2 = new ArrayList($this$map$iv.length);
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            PsiField it = (PsiField)item$iv$iv;
                            Collection collection3 = destination$iv$iv2;
                            boolean bl = false;
                            collection3.add(it instanceof KtLightField ? (KtLightField)it : null);
                        }
                        List lightDeclarations = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
                        for (KtDeclaration declaration : ((KtObjectDeclaration)element).getDeclarations()) {
                            KtLightMember ktLightMember;
                            Object v8;
                            block11: {
                                void $this$firstOrNull$iv;
                                destination$iv$iv2 = lightDeclarations;
                                boolean $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv) {
                                    KtLightMember it = (KtLightMember)element$iv;
                                    boolean bl = false;
                                    KtLightMember ktLightMember2 = it;
                                    if (!Intrinsics.areEqual((Object)(ktLightMember2 != null ? (KtDeclaration)ktLightMember2.getKotlinOrigin() : null), (Object)declaration)) continue;
                                    v8 = element$iv;
                                    break block11;
                                }
                                v8 = null;
                            }
                            if ((ktLightMember = (KtLightMember)v8) == null) continue;
                            PsiNamedElement p02 = (PsiNamedElement)ktLightMember;
                            boolean bl = false;
                            QueryProcessor.searchNamedElement$default(this, p02, null, null, 6, null);
                        }
                    }
                }
            }
        }

        private final void searchForComponentConventions(SmartPsiElementPointer<PsiElement> elementPointer) {
            Project project = this.queryParameters.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> QueryProcessor.searchForComponentConventions$lambda$55(elementPointer, this));
        }

        @RequiresReadLock
        private final void searchDataClassComponentUsages(KtLightClass containingClass, String componentMethodName, KotlinReferencesSearchOptions kotlinOptions) {
            block3: {
                Object object;
                block2: {
                    ApplicationManager.getApplication().assertReadAccessAllowed();
                    PsiMethod[] psiMethodArray = containingClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
                    Object[] $this$firstOrNull$iv = psiMethodArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiMethod it = (PsiMethod)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)componentMethodName) && it.getParameterList().getParametersCount() == 0)) continue;
                        object = element$iv;
                        break block2;
                    }
                    object = null;
                }
                PsiMethod psiMethod = (PsiMethod)object;
                if (psiMethod == null) break block3;
                PsiMethod it = psiMethod;
                boolean bl = false;
                QueryProcessor.searchNamedElement$default(this, (PsiNamedElement)it, null, null, 6, null);
                PsiElement psiElement = (PsiElement)it;
                SearchScope searchScope = this.queryParameters.getEffectiveSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
                SearchRequestCollector searchRequestCollector = this.queryParameters.getOptimizer();
                Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"getOptimizer(...)");
                OperatorReferenceSearcher<?> operatorReferenceSearcher = OperatorReferenceSearcher.Companion.create(psiElement, searchScope, this.consumer, searchRequestCollector, kotlinOptions);
                if (operatorReferenceSearcher != null) {
                    OperatorReferenceSearcher<?> searcher2 = operatorReferenceSearcher;
                    boolean bl2 = false;
                    this.longTasks.add(() -> QueryProcessor.searchDataClassComponentUsages$lambda$59$lambda$58$lambda$57(searcher2));
                }
            }
        }

        @RequiresReadLock
        private final void processStaticsFromCompanionObject(KtDeclaration element) {
            Iterable $this$forEach$iv = this.findStaticMethodsFromCompanionObject(element);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiNamedElement p0 = (PsiNamedElement)element$iv;
                boolean bl = false;
                QueryProcessor.searchNamedElement$default(this, p0, null, null, 6, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<PsiMethod> findStaticMethodsFromCompanionObject(KtDeclaration declaration) {
            void $this$filterTo$iv$iv;
            PsiMethod[] allMethods;
            Object object = SequencesKt.firstOrNull((Sequence)SequencesKt.dropWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)declaration)), QueryProcessor::findStaticMethodsFromCompanionObject$lambda$61));
            KtObjectDeclaration ktObjectDeclaration = object instanceof KtObjectDeclaration ? (KtObjectDeclaration)object : null;
            if (ktObjectDeclaration == null) {
                return CollectionsKt.emptyList();
            }
            KtObjectDeclaration originObject = ktObjectDeclaration;
            if (!originObject.isCompanion()) {
                return CollectionsKt.emptyList();
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)originObject;
            boolean $i$f$getStrictParentOfType = false;
            KtClass originClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
            KtClass ktClass = originClass;
            if (ktClass == null || (ktClass = LightClassUtilsKt.toLightClass((KtClassOrObject)((KtClassOrObject)ktClass))) == null) {
                return CollectionsKt.emptyList();
            }
            KtClass originLightClass = ktClass;
            PsiMethod[] psiMethodArray = originLightClass.getAllMethods();
            Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getAllMethods(...)");
            PsiMethod[] $this$filter$iv = allMethods = psiMethodArray;
            boolean $i$f$filter = false;
            PsiMethod[] psiMethodArray2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[j];
                boolean bl = false;
                if (!(it instanceof KtLightMethod && Intrinsics.areEqual((Object)((KtLightMethod)it).getKotlinOrigin(), (Object)declaration))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @RequiresReadLock
        private final void searchNamedElement(PsiNamedElement element, String name2, Function1<? super SearchScope, ? extends SearchScope> modifyScope) {
            SearchScope searchScope;
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (element == null) {
                return;
            }
            String string = name2;
            if (string == null && (string = element.getName()) == null) {
                return;
            }
            String nameToUse = string;
            SearchScope baseScope = SearchUtilKt.effectiveSearchScope(this.queryParameters, (PsiElement)element);
            Function1<? super SearchScope, ? extends SearchScope> function1 = modifyScope;
            SearchScope scope = function1 != null ? (SearchScope)function1.invoke((Object)baseScope) : baseScope;
            int context = 11;
            PsiElement psiElement = (PsiElement)element;
            PsiElement psiElement2 = this.queryParameters.getElementToSearch();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElementToSearch(...)");
            PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiElement2);
            if (psiNamedElement == null) {
                psiNamedElement = element;
            }
            KotlinRequestResultProcessor resultProcessor = new KotlinRequestResultProcessor(psiElement, (PsiElement)psiNamedElement, null, this.kotlinOptions, 4, null);
            SearchRequestCollector searchRequestCollector = this.queryParameters.getOptimizer();
            if (!(element instanceof KtElement)) {
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                FileType[] fileTypeArray = new FileType[]{KotlinFileType.INSTANCE};
                searchScope = KotlinScopeUtils.excludeFileTypes(scope, project, fileTypeArray);
            } else {
                searchScope = scope;
            }
            searchRequestCollector.searchWord(nameToUse, searchScope, (short)context, true, (PsiElement)element, (RequestResultProcessor)resultProcessor);
        }

        static /* synthetic */ void searchNamedElement$default(QueryProcessor queryProcessor, PsiNamedElement psiNamedElement, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                function1 = null;
            }
            queryProcessor.searchNamedElement(psiNamedElement, string, (Function1<? super SearchScope, ? extends SearchScope>)function1);
        }

        private final boolean isNamedArgumentReference(PsiReference $this$isNamedArgumentReference) {
            return $this$isNamedArgumentReference instanceof KtSimpleNameReference && ((KtSimpleNameExpression)((KtSimpleNameReference)$this$isNamedArgumentReference).getExpression()).getParent() instanceof KtValueArgumentName;
        }

        private static final Pair process$lambda$0(QueryProcessor this$0, Ref.ObjectRef $element, Ref.ObjectRef $classNameForCompanionObject) {
            PsiElement psiElement = this$0.queryParameters.getElementToSearch();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
            PsiElement psiElement2 = psiElement;
            if (!psiElement2.isValid()) {
                return null;
            }
            PsiNamedElement psiNamedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiElement2);
            if (psiNamedElement == null) {
                return null;
            }
            PsiNamedElement unwrappedElement = psiNamedElement;
            PsiNamedElement elementToSearch = ExpectActualUtils.INSTANCE.getElementToSearch(this$0.kotlinOptions, unwrappedElement);
            SearchScope effectiveSearchScope = SearchUtilKt.effectiveSearchScope(this$0.queryParameters, (PsiElement)elementToSearch);
            $element.element = SmartPointerManager.createPointer((PsiElement)psiElement2);
            $classNameForCompanionObject.element = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.getClassNameForCompanionObject(elementToSearch);
            return TuplesKt.to((Object)SmartPointerManager.createPointer((PsiElement)((PsiElement)elementToSearch)), (Object)effectiveSearchScope);
        }

        private static final PsiElement process$lambda$1(Ref.ObjectRef $element) {
            SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)$element.element;
            return smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
        }

        private static final boolean process$lambda$29$lambda$12$lambda$2(QueryProcessor this$0, PsiReference ref) {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            return !this$0.isNamedArgumentReference(ref);
        }

        private static final boolean process$lambda$29$lambda$12$lambda$3(PsiReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final PsiNamedElement process$lambda$29$lambda$12$lambda$7$lambda$6$lambda$4(SmartPsiElementPointer $elementToSearchPointer) {
            return (PsiNamedElement)$elementToSearchPointer.getElement();
        }

        private static final Unit process$lambda$29$lambda$12$lambda$7$lambda$6(SmartPsiElementPointer $elementToSearchPointer, QueryProcessor this$0, String $name, SearchScope $effectiveSearchScope, KotlinRequestResultProcessor $resultProcessor) {
            block0: {
                PsiNamedElement psiNamedElement = (PsiNamedElement)ActionsKt.runReadAction(() -> QueryProcessor.process$lambda$29$lambda$12$lambda$7$lambda$6$lambda$4($elementToSearchPointer));
                if (psiNamedElement == null) break block0;
                PsiNamedElement elementToSearch = psiNamedElement;
                boolean bl = false;
                this$0.queryParameters.getOptimizer().searchWord($name, $effectiveSearchScope, (short)1, true, (PsiElement)elementToSearch, (RequestResultProcessor)$resultProcessor);
            }
            return Unit.INSTANCE;
        }

        private static final PsiNamedElement process$lambda$29$lambda$12$lambda$11$lambda$10$lambda$8(SmartPsiElementPointer $elementToSearchPointer) {
            return (PsiNamedElement)$elementToSearchPointer.getElement();
        }

        private static final Unit process$lambda$29$lambda$12$lambda$11$lambda$10(SmartPsiElementPointer $elementToSearchPointer, QueryProcessor this$0, String $name, SearchScope $effectiveSearchScope, KotlinRequestResultProcessor $resultProcessor) {
            block0: {
                PsiNamedElement psiNamedElement = (PsiNamedElement)ActionsKt.runReadAction(() -> QueryProcessor.process$lambda$29$lambda$12$lambda$11$lambda$10$lambda$8($elementToSearchPointer));
                if (psiNamedElement == null) break block0;
                PsiNamedElement elementToSearch = psiNamedElement;
                boolean bl = false;
                this$0.queryParameters.getOptimizer().searchWord($name, $effectiveSearchScope, (short)255, true, (PsiElement)elementToSearch, (RequestResultProcessor)$resultProcessor);
            }
            return Unit.INSTANCE;
        }

        private static final void process$lambda$29$lambda$14$lambda$13(SmartPsiElementPointer $elementToSearchPointer, QueryProcessor this$0) {
            block1: {
                PsiElement $this$safeAs$iv = $elementToSearchPointer.getElement();
                boolean $i$f$safeAs = false;
                PsiElement psiElement = $this$safeAs$iv;
                if (!(psiElement instanceof KtParameter)) {
                    psiElement = null;
                }
                KtParameter ktParameter = (KtParameter)psiElement;
                if (ktParameter == null) break block1;
                KtParameter p0 = ktParameter;
                boolean bl = false;
                this$0.searchNamedArguments(p0);
            }
        }

        private static final Unit process$lambda$29$lambda$14(QueryProcessor this$0, SmartPsiElementPointer $elementToSearchPointer) {
            Project project = this$0.queryParameters.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> QueryProcessor.process$lambda$29$lambda$14$lambda$13($elementToSearchPointer, this$0));
            return Unit.INSTANCE;
        }

        private static final boolean process$lambda$29$lambda$15(SearchScope $effectiveSearchScope) {
            return SearchUtilKt.isOnlyKotlinSearch($effectiveSearchScope);
        }

        private static final void process$lambda$29$lambda$18$lambda$17(Ref.ObjectRef $element, QueryProcessor this$0) {
            block0: {
                SmartPsiElementPointer smartPsiElementPointer = (SmartPsiElementPointer)$element.element;
                if (smartPsiElementPointer == null || (smartPsiElementPointer = smartPsiElementPointer.getElement()) == null) break block0;
                SmartPsiElementPointer p0 = smartPsiElementPointer;
                boolean bl = false;
                this$0.searchLightElements((PsiElement)p0);
            }
        }

        private static final Unit process$lambda$29$lambda$18(QueryProcessor this$0, Ref.ObjectRef $element) {
            Project project = this$0.queryParameters.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DumbService.Companion.getInstance(project).runReadActionInSmartMode(() -> QueryProcessor.process$lambda$29$lambda$18$lambda$17($element, this$0));
            return Unit.INSTANCE;
        }

        private static final Unit process$lambda$29$lambda$23$lambda$22$lambda$21(OperatorReferenceSearcher $searcher) {
            $searcher.run();
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final Unit process$lambda$29(SmartPsiElementPointer $elementToSearchPointer, QueryProcessor this$0, Ref.ObjectRef $element, Ref.ObjectRef $classNameForCompanionObject, SearchScope $effectiveSearchScope) {
            SmartPsiElementPointer smartPsiElementPointer;
            SmartPsiElementPointer it;
            Object object;
            String name2;
            PsiNamedElement psiNamedElement = (PsiNamedElement)$elementToSearchPointer.getElement();
            if (psiNamedElement != null) {
                PsiNamedElement elementToSearch = psiNamedElement;
                boolean bl = false;
                Function1 refFilter = elementToSearch instanceof KtParameter ? arg_0 -> QueryProcessor.process$lambda$29$lambda$12$lambda$2(this$0, arg_0) : QueryProcessor::process$lambda$29$lambda$12$lambda$3;
                KotlinRequestResultProcessor resultProcessor = new KotlinRequestResultProcessor((PsiElement)elementToSearch, null, refFilter, this$0.kotlinOptions, 2, null);
                if (this$0.kotlinOptions.anyEnabled() || elementToSearch instanceof KtNamedDeclaration && KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)elementToSearch))) {
                    String string = elementToSearch.getName();
                    if (string != null) {
                        name2 = string;
                        boolean bl2 = false;
                        this$0.longTasks.add(() -> QueryProcessor.process$lambda$29$lambda$12$lambda$7$lambda$6($elementToSearchPointer, this$0, name2, $effectiveSearchScope, resultProcessor));
                    }
                }
                String string = (String)$classNameForCompanionObject.element;
                if (string != null) {
                    name2 = string;
                    boolean bl3 = false;
                    this$0.longTasks.add(() -> QueryProcessor.process$lambda$29$lambda$12$lambda$11$lambda$10($elementToSearchPointer, this$0, name2, $effectiveSearchScope, resultProcessor));
                }
            }
            if ($elementToSearchPointer.getElement() instanceof KtParameter && this$0.kotlinOptions.getSearchNamedArguments()) {
                this$0.longTasks.add(() -> QueryProcessor.process$lambda$29$lambda$14(this$0, $elementToSearchPointer));
            }
            if (!($elementToSearchPointer.getElement() instanceof KtElement) || !((Boolean)ActionsKt.runReadAction(() -> QueryProcessor.process$lambda$29$lambda$15($effectiveSearchScope))).booleanValue()) {
                this$0.longTasks.add(() -> QueryProcessor.process$lambda$29$lambda$18(this$0, $element));
            }
            if ((object = (SmartPsiElementPointer)$element.element) != null && (object = object.getElement()) != null) {
                SmartPsiElementPointer smartPsiElementPointer2;
                it = smartPsiElementPointer2 = object;
                boolean bl = false;
                object = it instanceof KtFunction || it instanceof PsiMethod ? smartPsiElementPointer2 : null;
                if (object != null) {
                    PsiElement bl3;
                    boolean bl4 = false;
                    name2 = (SmartPsiElementPointer)$element.element;
                    if (name2 != null && (bl3 = name2.getElement()) != null) {
                        PsiElement it2 = bl3;
                        boolean bl5 = false;
                        Processor<? super PsiReference> processor2 = this$0.consumer;
                        SearchRequestCollector searchRequestCollector = this$0.queryParameters.getOptimizer();
                        Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"getOptimizer(...)");
                        OperatorReferenceSearcher<?> operatorReferenceSearcher = OperatorReferenceSearcher.Companion.create(it2, $effectiveSearchScope, processor2, searchRequestCollector, this$0.kotlinOptions);
                        if (operatorReferenceSearcher != null) {
                            OperatorReferenceSearcher<?> searcher2 = operatorReferenceSearcher;
                            boolean bl6 = false;
                            this$0.longTasks.add(() -> QueryProcessor.process$lambda$29$lambda$23$lambda$22$lambda$21(searcher2));
                        }
                    }
                }
            }
            SmartPsiElementPointer smartPsiElementPointer4 = (SmartPsiElementPointer)$element.element;
            smartPsiElementPointer4 = smartPsiElementPointer4;
            if (smartPsiElementPointer3 == null) return null;
            PsiElement psiElement = smartPsiElementPointer4.getElement();
            smartPsiElementPointer4 = psiElement;
            if (psiElement == null) return null;
            it = smartPsiElementPointer = smartPsiElementPointer4;
            boolean bl = false;
            if (!(it instanceof KtConstructor)) return null;
            KtConstructor ktConstructor2 = (KtConstructor)it;
            ktConstructor2 = ktConstructor2;
            if (ktConstructor == null) return null;
            KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)ktConstructor2));
            ktConstructor2 = ktClass;
            if (ktClass == null) return null;
            if (!ktConstructor2.isEnum()) return null;
            boolean bl7 = true;
            if (!bl7) return null;
            SmartPsiElementPointer smartPsiElementPointer4 = smartPsiElementPointer;
            smartPsiElementPointer4 = smartPsiElementPointer4;
            if (smartPsiElementPointer5 == null) return null;
            SmartPsiElementPointer el = smartPsiElementPointer4;
            boolean bl8 = false;
            KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)((KtConstructor)el)));
            Intrinsics.checkNotNull((Object)ktClass2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClass");
            KtClass klass = ktClass2;
            if ($effectiveSearchScope.contains(klass.getContainingFile().getVirtualFile())) {
                void $this$forEach$iv;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = klass.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable bl6 = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof KtEnumEntry)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    void $this$forEach$iv2;
                    KtEnumEntry enumEntry = (KtEnumEntry)element$iv;
                    boolean bl9 = false;
                    PsiElement $this$descendantsOfType_u24default$iv = (PsiElement)enumEntry;
                    boolean childrenFirst$iv = false;
                    boolean $i$f$descendantsOfType = false;
                    Sequence $this$filterIsInstance$iv$iv = PsiTreeUtilKt.descendants$default((PsiElement)$this$descendantsOfType_u24default$iv, (boolean)childrenFirst$iv, null, (int)2, null);
                    boolean $i$f$filterIsInstance2 = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv$iv, (Function1)QueryProcessor$process$lambda$29$lambda$28$lambda$27$$inlined$descendantsOfType$default$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    $this$descendantsOfType_u24default$iv = sequence;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        PsiElement psiElement2;
                        void this_$iv$iv;
                        KtEnumEntrySuperclassReferenceExpression superEntry = (KtEnumEntrySuperclassReferenceExpression)element$iv2;
                        boolean bl10 = false;
                        boolean $i$f$analyze = false;
                        Project project = ((KtElement)superEntry).getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(project);
                        boolean $i$f$analyze2 = false;
                        KaSession analysisSession$iv$iv = this_$iv$iv.getAnalysisSession((KtElement)superEntry);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, (KtElement)superEntry);
                        try {
                            PsiElement psiElement3;
                            Object lock$iv$iv;
                            Object object2 = lock$iv$iv = new Object();
                            synchronized (object2) {
                                boolean bl11 = false;
                                KaSession $this$process_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425 = analysisSession$iv$iv;
                                boolean bl12 = false;
                                KaLifetimeOwner kaLifetimeOwner = $this$process_u24lambda_u2429_u24lambda_u2428_u24lambda_u2427_u24lambda_u2426_u24lambda_u2425.resolveToCall((KtElement)superEntry);
                                psiElement3 = kaLifetimeOwner != null && (kaLifetimeOwner = KaCallInfoKt.singleFunctionCallOrNull((KaCallInfo)kaLifetimeOwner)) != null && (kaLifetimeOwner = kaLifetimeOwner.getPartiallyAppliedSymbol()) != null && (kaLifetimeOwner = (KaFunctionSymbol)KaPartiallyAppliedSymbolKt.getSymbol(kaLifetimeOwner)) != null ? kaLifetimeOwner.getPsi() : null;
                            }
                            psiElement2 = psiElement3;
                        }
                        finally {
                            this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, (KtElement)superEntry);
                        }
                        PsiElement target = psiElement2;
                        if (!Intrinsics.areEqual((Object)target, (Object)el) && (!this$0.kotlinOptions.getAcceptOverloads() || !(target instanceof KtConstructor) || !Intrinsics.areEqual((Object)KtPsiUtilKt.containingClass((KtElement)((KtElement)target)), (Object)klass))) continue;
                        this$0.consumer.process((Object)new PsiReferenceBase<KtEnumEntrySuperclassReferenceExpression>(superEntry, (PsiElement)el){
                            final /* synthetic */ KtEnumEntrySuperclassReferenceExpression $superEntry;
                            final /* synthetic */ PsiElement $el;
                            {
                                this.$superEntry = $superEntry;
                                this.$el = $el;
                                super((PsiElement)$superEntry);
                            }

                            public PsiElement resolve() {
                                return this.$el;
                            }

                            public TextRange getRangeInElement() {
                                return new TextRange(0, this.$superEntry.getTextLength());
                            }

                            public PsiElement handleElementRename(String newElementName) {
                                Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
                                return (PsiElement)this.$superEntry;
                            }
                        });
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
            return unit;
        }

        private static final boolean searchNamedArguments$lambda$31(QueryProcessor this$0, PsiReference it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return this$0.isNamedArgumentReference(it);
        }

        private static final PsiMethod searchLightElements$lambda$36$lambda$35$lambda$33(SmartPsiElementPointer $pointer) {
            return (PsiMethod)$pointer.getElement();
        }

        private static final Unit searchLightElements$lambda$36$lambda$35(SmartPsiElementPointer $pointer, QueryProcessor this$0, Project $project) {
            block0: {
                PsiMethod psiMethod = (PsiMethod)ActionsKt.runReadAction(() -> QueryProcessor.searchLightElements$lambda$36$lambda$35$lambda$33($pointer));
                if (psiMethod == null) break block0;
                PsiMethod it = psiMethod;
                boolean bl = false;
                SearchScope searchScope = this$0.queryParameters.getEffectiveSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
                FileType[] fileTypeArray = new FileType[]{KotlinFileType.INSTANCE};
                MethodReferencesSearch.search((PsiMethod)it, (SearchScope)KotlinScopeUtils.excludeFileTypes(searchScope, $project, fileTypeArray), (boolean)true).forEach(this$0.consumer);
            }
            return Unit.INSTANCE;
        }

        private static final SearchScope searchLightElements$lambda$42(SearchScope it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return KotlinScopeUtils.restrictToKotlinSources(it);
        }

        private static final PsiMethod searchMethodAware$lambda$46$lambda$44(SmartPsiElementPointer $pointer) {
            return (PsiMethod)$pointer.getElement();
        }

        private static final Unit searchMethodAware$lambda$46(SmartPsiElementPointer $pointer, QueryProcessor this$0) {
            block0: {
                PsiMethod psiMethod = (PsiMethod)ActionsKt.runReadAction(() -> QueryProcessor.searchMethodAware$lambda$46$lambda$44($pointer));
                if (psiMethod == null) break block0;
                PsiMethod it = psiMethod;
                boolean bl = false;
                MethodReferencesSearch.search((PsiMethod)it, (SearchScope)this$0.queryParameters.getEffectiveSearchScope(), (boolean)true).forEach(this$0.consumer);
            }
            return Unit.INSTANCE;
        }

        private static final Unit searchForComponentConventions$lambda$55$lambda$54(DestructuringDeclarationReferenceSearcher $searcher) {
            $searcher.run();
            return Unit.INSTANCE;
        }

        private static final void searchForComponentConventions$lambda$55(SmartPsiElementPointer $elementPointer, QueryProcessor this$0) {
            PsiElement element = $elementPointer.getElement();
            if (element instanceof KtParameter) {
                String string = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.getDataClassComponentMethodName((KtParameter)element);
                if (string == null) {
                    return;
                }
                String componentMethodName = string;
                QueryProcessor.searchNamedElement$default(this$0, (PsiNamedElement)element, componentMethodName, null, 4, null);
                if (this$0.kotlinOptions.getSearchForComponentConventions()) {
                    int componentIndex = KtPsiUtilKt.parameterIndex((PsiElement)element);
                    SearchScope searchScope = this$0.queryParameters.getEffectiveSearchScope();
                    Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
                    Processor<? super PsiReference> processor2 = this$0.consumer;
                    SearchRequestCollector searchRequestCollector = this$0.queryParameters.getOptimizer();
                    Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"getOptimizer(...)");
                    DestructuringDeclarationReferenceSearcher searcher2 = new DestructuringDeclarationReferenceSearcher(element, componentIndex + 1, searchScope, processor2, searchRequestCollector, this$0.kotlinOptions);
                    this$0.longTasks.add(() -> QueryProcessor.searchForComponentConventions$lambda$55$lambda$54(searcher2));
                }
            } else if (element instanceof KtLightParameter) {
                Object object = (KtParameter)((KtLightParameter)element).getKotlinOrigin();
                if (object == null || (object = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.getDataClassComponentMethodName((KtParameter)object)) == null) {
                    return;
                }
                Object componentMethodName = object;
                KtLightClass ktLightClass = (KtLightClass)((KtLightParameter)element).getMethod().getContainingClass();
                if (ktLightClass == null) {
                    return;
                }
                KtLightClass containingClass = ktLightClass;
                this$0.searchDataClassComponentUsages(containingClass, (String)componentMethodName, this$0.kotlinOptions);
            } else {
                return;
            }
        }

        private static final Unit searchDataClassComponentUsages$lambda$59$lambda$58$lambda$57(OperatorReferenceSearcher $searcher) {
            $searcher.run();
            return Unit.INSTANCE;
        }

        private static final boolean findStaticMethodsFromCompanionObject$lambda$61(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof KtClassBody;
        }
    }
}

