/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameJavaMethodProcessor;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringSettings;
import org.jetbrains.kotlin.idea.refactoring.conflicts.KotlinMembersNameConflictsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.CommonRenameUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.ForeignUsagesRenameProcessor;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.idea.refactoring.rename.KtResolvableCollisionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.LostDefaultValuesInOverridingFunctionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.search.ExpectActualUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\b\u001a\u00020\tH\u0002J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J<\u0010\u0017\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0014\u0010\u0019\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001c\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J(\u0010 \u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010!\u001a\u00020\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020\t0$H\u0016J,\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\t2\b\u0010)\u001a\u0004\u0018\u00010\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J4\u0010*\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120+2\u0006\u0010,\u001a\u00020-H\u0016J5\u0010.\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00122\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d002\b\u00101\u001a\u0004\u0018\u000102H\u0016\u00a2\u0006\u0002\u00103J&\u00104\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u00105\u001a\u00020-2\u0006\u00106\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor;", "Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinPsiProcessor;", "<init>", "()V", "javaMethodProcessorInstance", "Lcom/intellij/refactoring/rename/RenameJavaMethodProcessor;", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "isToSearchInComments", "psiElement", "setToSearchInComments", "", "enabled", "isToSearchForTextOccurrences", "setToSearchForTextOccurrences", "getJvmName", "", "processFoundReferences", "", "Lcom/intellij/psi/PsiReference;", "allReferences", "findCollisions", "newName", "allRenames", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "substituteForExpectOrActual", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "substituteElementToRename", "editor", "Lcom/intellij/openapi/editor/Editor;", "renameCallback", "Lcom/intellij/openapi/util/Pass;", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "prepareRenaming", "", "scope", "Lcom/intellij/psi/search/SearchScope;", "renameElement", "usages", "", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "findReferences", "searchScope", "searchInCommentsAndStrings", "FunctionWithSupersWrapper", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nRenameKotlinFunctionProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenameKotlinFunctionProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,254:1\n808#2,11:255\n827#2:266\n855#2,2:267\n1863#2,2:288\n1#3:269\n56#4,6:270\n56#4,6:276\n37#5:282\n36#5,3:283\n13402#6,2:286\n*S KotlinDebug\n*F\n+ 1 RenameKotlinFunctionProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor\n*L\n60#1:255,11\n61#1:266\n61#1:267,2\n138#1:288,2\n96#1:270,6\n147#1:276,6\n234#1:282\n234#1:283,3\n236#1:286,2\n*E\n"})
public final class RenameKotlinFunctionProcessor
extends RenameKotlinPsiProcessor {
    @NotNull
    private final RenameJavaMethodProcessor javaMethodProcessorInstance = new RenameJavaMethodProcessor();

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtNamedFunction || element instanceof KtLightMethod && ((KtLightMethod)element).getKotlinOrigin() instanceof KtNamedFunction || element instanceof FunctionWithSupersWrapper;
    }

    public boolean isToSearchInComments(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION();
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_IN_COMMENTS_FOR_FUNCTION(enabled);
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KotlinCommonRefactoringSettings.Companion.getInstance().getRENAME_SEARCH_FOR_TEXT_FOR_FUNCTION();
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KotlinCommonRefactoringSettings.Companion.getInstance().setRENAME_SEARCH_FOR_TEXT_FOR_FUNCTION(enabled);
    }

    private final String getJvmName(PsiElement element) {
        return this.getRenameRefactoringSupport().getJvmName(element);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiReference> processFoundReferences(PsiElement element, Collection<? extends PsiReference> allReferences) {
        Collection collection;
        if (this.getJvmName(element) == null) {
            collection = allReferences;
        } else if (element instanceof KtElement) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = allReferences;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else if (element instanceof KtLightElement) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = allReferences;
            boolean $i$f$filterNot = false;
            Iterable $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                boolean bl = false;
                if (it instanceof KtReference) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Object object = LightClassUtilsKt.getUnwrapped((PsiElement)element);
        KtNamedFunction ktNamedFunction = object instanceof KtNamedFunction ? (KtNamedFunction)object : null;
        if (ktNamedFunction == null) {
            return;
        }
        KtNamedFunction declaration = ktNamedFunction;
        CommonRenameUtilsKt.checkConflictsAndReplaceUsageInfos(element, allRenames, result2);
        Collection collection = result2;
        PsiElement collisions = object = new SmartList();
        boolean bl = false;
        KotlinMembersNameConflictsKt.checkRedeclarationConflicts((KtNamedDeclaration)declaration, newName, (List)collisions);
        this.getRenameRefactoringSupport().checkUsagesRetargeting((KtNamedDeclaration)declaration, newName, result2, (List)collisions);
        object = (Iterable)object;
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
    }

    private final KtDeclaration substituteForExpectOrActual(PsiElement element) {
        KtDeclaration ktDeclaration;
        PsiElement psiElement = element;
        PsiNamedElement psiNamedElement = psiElement != null ? LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)psiElement) : null;
        KtNamedDeclaration ktNamedDeclaration = psiNamedElement instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiNamedElement : null;
        if (ktNamedDeclaration != null) {
            KtNamedDeclaration el = ktNamedDeclaration;
            boolean bl = false;
            Project project = el.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ktDeclaration = (KtDeclaration)ActionUtil.underModalProgress((Project)project, (String)KotlinBundle.message((String)"progress.title.searching.for.expected.actual", (Object[])new Object[0]), () -> RenameKotlinFunctionProcessor.substituteForExpectOrActual$lambda$3$lambda$2(el));
        } else {
            ktDeclaration = null;
        }
        return ktDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        boolean bl;
        PsiElement substitutedJavaElement;
        void project$iv;
        void canBeCancelled$iv;
        void progressTitle$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtDeclaration ktDeclaration = this.substituteForExpectOrActual(element);
        if (ktDeclaration != null) {
            KtDeclaration it = ktDeclaration;
            boolean bl2 = false;
            return (PsiElement)it;
        }
        String string = KotlinBundle.message((String)"rename.searching.for.super.declaration", (Object[])new Object[0]);
        boolean it = true;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project bl2 = project;
        boolean $i$f$runProcessWithProgressSynchronously2 = false;
        List deepestSuperMethods2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(element){
            final /* synthetic */ PsiElement $element$inlined;
            {
                this.$element$inlined = psiElement;
            }

            public final T compute() {
                boolean bl = false;
                return (T)((List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PsiElement>>(this.$element$inlined){
                    final /* synthetic */ PsiElement $element;
                    {
                        this.$element = $element;
                    }

                    public final List<PsiElement> invoke() {
                        return KotlinSearchUsagesSupport.SearchUtils.INSTANCE.findDeepestSuperMethodsNoWrapping(this.$element);
                    }
                })));
            }
        }, (String)progressTitle$iv, (boolean)canBeCancelled$iv, (Project)project$iv);
        if (deepestSuperMethods2.isEmpty()) {
            return element;
        }
        if (element instanceof PsiMethod) {
            v1 = this.javaMethodProcessorInstance.substituteElementToRename(element, editor);
        } else {
            PsiElement $i$f$runProcessWithProgressSynchronously2 = LightClassUtilsKt.getUnwrapped((PsiElement)element);
            KtNamedFunction ktNamedFunction = $i$f$runProcessWithProgressSynchronously2 instanceof KtNamedFunction ? (KtNamedFunction)$i$f$runProcessWithProgressSynchronously2 : null;
            if (ktNamedFunction == null) {
                return element;
            }
            KtNamedFunction declaration = ktNamedFunction;
            List<PsiElement> chosenElements = CommonRenameUtilsKt.checkSuperMethods((KtNamedDeclaration)declaration, deepestSuperMethods2);
            if (chosenElements.size() > 1) {
                v1 = (PsiElement)new FunctionWithSupersWrapper(declaration, chosenElements);
            } else {
                v1 = (PsiElement)CollectionsKt.firstOrNull(chosenElements);
                if (v1 == null) {
                    v1 = substitutedJavaElement = element;
                }
            }
        }
        if (substitutedJavaElement instanceof KtLightMethod && element instanceof KtDeclaration) {
            KtElement declaration = ((KtLightMethod)substitutedJavaElement).getKotlinOrigin();
            return (PsiElement)(declaration instanceof KtNamedFunction ? (KtNamedFunction)declaration : null);
        }
        try {
            bl = PsiElementRenameHandler.canRename((Project)element.getProject(), (Editor)editor, (PsiElement)substitutedJavaElement);
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException refactoringErrorHintException) {
            bl = false;
        }
        boolean canRename = bl;
        return canRename ? substitutedJavaElement : element;
    }

    /*
     * WARNING - void declaration
     */
    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        void project$iv;
        void canBeCancelled$iv;
        void progressTitle$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(renameCallback, (String)"renameCallback");
        KtDeclaration ktDeclaration = this.substituteForExpectOrActual(element);
        if (ktDeclaration != null) {
            KtDeclaration it = ktDeclaration;
            boolean bl = false;
            RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass(element, editor, renameCallback, (PsiElement)it);
            return;
        }
        String string = KotlinBundle.message((String)"rename.searching.for.super.declaration", (Object[])new Object[0]);
        boolean it = true;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project bl = project;
        boolean $i$f$runProcessWithProgressSynchronously = false;
        List deepestSuperMethods2 = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(element){
            final /* synthetic */ PsiElement $element$inlined;
            {
                this.$element$inlined = psiElement;
            }

            public final T compute() {
                boolean bl = false;
                return (T)((List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends PsiElement>>(this.$element$inlined){
                    final /* synthetic */ PsiElement $element;
                    {
                        this.$element = $element;
                    }

                    public final List<PsiElement> invoke() {
                        return KotlinSearchUsagesSupport.SearchUtils.INSTANCE.findDeepestSuperMethodsNoWrapping(this.$element);
                    }
                })));
            }
        }, (String)progressTitle$iv, (boolean)canBeCancelled$iv, (Project)project$iv);
        if (deepestSuperMethods2.isEmpty()) {
            RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass(element, editor, renameCallback, element);
        } else if (element instanceof PsiMethod) {
            this.javaMethodProcessorInstance.substituteElementToRename(element, editor, Pass.create(arg_0 -> RenameKotlinFunctionProcessor.substituteElementToRename$lambda$9((Function1)new Function1<PsiElement, Unit>(element, editor, renameCallback){
                final /* synthetic */ PsiElement $element;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ Pass<? super PsiElement> $renameCallback;
                {
                    this.$element = $element;
                    this.$editor = $editor;
                    this.$renameCallback = $renameCallback;
                    super(1, Intrinsics.Kotlin.class, "preprocessAndPass", "substituteElementToRename$preprocessAndPass(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/util/Pass;Lcom/intellij/psi/PsiElement;)V", 0);
                }

                public final void invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    RenameKotlinFunctionProcessor.access$substituteElementToRename$preprocessAndPass(this.$element, this.$editor, this.$renameCallback, p0);
                }
            }, arg_0)));
        } else {
            KtNamedFunction ktNamedFunction = element instanceof KtNamedFunction ? (KtNamedFunction)element : null;
            if (ktNamedFunction == null) {
                return;
            }
            KtNamedFunction declaration = ktNamedFunction;
            CommonRenameUtilsKt.checkSuperMethodsWithPopup((KtNamedDeclaration)declaration, CollectionsKt.toList((Iterable)deepestSuperMethods2), editor, (Function1<? super List<? extends PsiElement>, Unit>)((Function1)arg_0 -> RenameKotlinFunctionProcessor.substituteElementToRename$lambda$10(declaration, element, editor, renameCallback, arg_0)));
        }
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FunctionWithSupersWrapper functionWithSupersWrapper = element instanceof FunctionWithSupersWrapper ? (FunctionWithSupersWrapper)element : null;
        PsiElement elementForDialog = functionWithSupersWrapper != null && (functionWithSupersWrapper = functionWithSupersWrapper.getOriginalDeclaration()) != null ? (PsiElement)functionWithSupersWrapper : element;
        return new RenameDialog(project, elementForDialog, nameSuggestionContext, editor, element){
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super($project, $elementForDialog, $nameSuggestionContext, $editor);
            }

            protected RenameProcessor createRenameProcessor(String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                return new RenameProcessor(this.getProject(), this.$element, newName, this.isSearchInComments(), this.isSearchInNonJavaFiles());
            }
        };
    }

    @Override
    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        KtNamedFunction namedFunction;
        Object object;
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        if (element instanceof KtLightMethod && this.getJvmName(element) == null) {
            psiElement = ((KtLightMethod)element).getKotlinOrigin();
            KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            if (ktNamedFunction != null) {
                KtNamedFunction it = ktNamedFunction;
                boolean bl = false;
                allRenames.put((PsiElement)it, newName);
            }
        }
        if (element instanceof FunctionWithSupersWrapper) {
            allRenames.remove(element);
        }
        if ((object = (namedFunction = (psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)element)) instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null)) == null || (object = object.getName()) == null) {
            return;
        }
        Object originalName = object;
        String safeNewName = KtPsiUtilKt.quoteIfNeeded((String)newName);
        Object object2 = element instanceof FunctionWithSupersWrapper ? (FunctionWithSupersWrapper)element : null;
        if (object2 == null || (object2 = ((FunctionWithSupersWrapper)object2).getSupers()) == null) {
            object2 = CollectionsKt.listOf((Object)element);
        }
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string;
            Object baseName;
            PsiElement declaration = (PsiElement)iterator.next();
            Object object3 = declaration instanceof PsiNamedElement ? (PsiNamedElement)declaration : null;
            if (object3 == null || (object3 = object3.getName()) == null) {
                object3 = baseName = originalName;
            }
            if (Intrinsics.areEqual((Object)this.getRenameRefactoringSupport().demangleInternalName((String)baseName), (Object)originalName)) {
                KotlinRenameRefactoringSupport kotlinRenameRefactoringSupport = this.getRenameRefactoringSupport();
                String string2 = this.getRenameRefactoringSupport().getModuleNameSuffixForMangledName((String)baseName);
                Intrinsics.checkNotNull((Object)string2);
                string = kotlinRenameRefactoringSupport.mangleInternalName(newName, string2);
            } else {
                string = newName;
            }
            String newBaseName = string;
            this.prepareOverrideRenaming(declaration, (String)baseName, KtPsiUtilKt.quoteIfNeeded((String)newBaseName), safeNewName, allRenames);
        }
        ForeignUsagesRenameProcessor.Companion.prepareRenaming(element, newName, allRenames, scope);
    }

    @Override
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) {
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
            PsiElement psiElement = LightClassUtilsKt.getUnwrapped((PsiElement)element);
            KtNamedFunction ktNamedFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
            if (ktNamedFunction != null) {
                KtNamedFunction it = ktNamedFunction;
                boolean bl2 = false;
                bl = this.getRenameRefactoringSupport().overridesNothing((KtCallableDeclaration)it);
            } else {
                bl = false;
            }
            boolean wasRequiredOverride = !bl;
            ArrayList simpleUsages = new ArrayList(usages2.length);
            SmartList ambiguousImportUsages = new SmartList();
            SmartList simpleImportUsages = new SmartList();
            ForeignUsagesRenameProcessor.Companion.processAll(element, newName, usages2, (Function1<? super UsageInfo, Unit>)((Function1)arg_0 -> RenameKotlinFunctionProcessor.renameElement$lambda$13(this, ambiguousImportUsages, simpleImportUsages, element, newName, simpleUsages, arg_0)));
            this.setAmbiguousImportUsages(element, (List)ambiguousImportUsages);
            List usagesToRename = simpleImportUsages.isEmpty() ? (List)simpleUsages : CollectionsKt.plus((Collection)((Collection)simpleImportUsages), (Iterable)simpleUsages);
            Collection $this$toTypedArray$iv = usagesToRename;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv;
            this.renamePossiblyLightElement(element, newName, thisCollection$iv2.toArray(new UsageInfo[0]), listener2);
            UsageInfo[] $this$forEach$iv = usages2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int thisCollection$iv2 = 0; thisCollection$iv2 < n; ++thisCollection$iv2) {
                UsageInfo element$iv;
                UsageInfo it = element$iv = $this$forEach$iv[thisCollection$iv2];
                boolean bl3 = false;
                KtResolvableCollisionUsageInfo ktResolvableCollisionUsageInfo = it instanceof KtResolvableCollisionUsageInfo ? (KtResolvableCollisionUsageInfo)it : null;
                if (ktResolvableCollisionUsageInfo == null) continue;
                ktResolvableCollisionUsageInfo.apply();
            }
            if (!wasRequiredOverride) break block4;
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)element);
            KtNamedDeclaration ktNamedDeclaration = psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null;
            if (ktNamedDeclaration != null) {
                KtNamedDeclaration it = ktNamedDeclaration;
                boolean bl4 = false;
                this.getRenameRefactoringSupport().dropOverrideKeywordIfNecessary(it);
            }
        }
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Collection<PsiReference> references = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        return this.processFoundReferences(element, references);
    }

    private static final KtDeclaration substituteForExpectOrActual$lambda$3$lambda$2(KtNamedDeclaration $el) {
        return ExpectActualUtils.INSTANCE.liftToExpect((KtDeclaration)$el);
    }

    private static final void substituteElementToRename$preprocessAndPass(PsiElement $element, Editor $editor, Pass<? super PsiElement> $renameCallback, PsiElement substitutedJavaElement) {
        KtElement ktElement;
        PsiElement elementToProcess;
        PsiElement psiElement = elementToProcess = substitutedJavaElement instanceof KtLightMethod && $element instanceof KtDeclaration ? (PsiElement)((ktElement = ((KtLightMethod)substitutedJavaElement).getKotlinOrigin()) instanceof KtNamedFunction ? (KtNamedFunction)ktElement : null) : substitutedJavaElement;
        Object object = elementToProcess instanceof FunctionWithSupersWrapper ? (FunctionWithSupersWrapper)elementToProcess : null;
        if (object != null && (object = ((FunctionWithSupersWrapper)object).getSupers()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (PsiElementRenameHandler.canRename((Project)$element.getProject(), (Editor)$editor, (PsiElement)it)) continue;
                return;
            }
        }
        if (!PsiElementRenameHandler.canRename((Project)$element.getProject(), (Editor)$editor, (PsiElement)elementToProcess)) {
            return;
        }
        $renameCallback.accept((Object)elementToProcess);
    }

    private static final void substituteElementToRename$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit substituteElementToRename$lambda$10(KtNamedFunction $declaration, PsiElement $element, Editor $editor, Pass $renameCallback, List chosenElements) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)chosenElements, (String)"chosenElements");
        if (chosenElements.size() > 1) {
            psiElement = (PsiElement)new FunctionWithSupersWrapper($declaration, chosenElements);
        } else {
            psiElement = (PsiElement)CollectionsKt.firstOrNull((List)chosenElements);
            if (psiElement == null) {
                psiElement = $element;
            }
        }
        RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass($element, $editor, (Pass<? super PsiElement>)$renameCallback, psiElement);
        return Unit.INSTANCE;
    }

    private static final Unit renameElement$lambda$13(RenameKotlinFunctionProcessor this$0, SmartList $ambiguousImportUsages, SmartList $simpleImportUsages, PsiElement $element, String $newName, ArrayList $simpleUsages, UsageInfo usage) {
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        if (usage instanceof LostDefaultValuesInOverridingFunctionUsageInfo) {
            ((LostDefaultValuesInOverridingFunctionUsageInfo)usage).apply();
            return Unit.INSTANCE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.importState(usage).ordinal()]) {
            case 1: {
                ((Collection)$ambiguousImportUsages).add(usage);
                break;
            }
            case 2: {
                ((Collection)$simpleImportUsages).add(usage);
                break;
            }
            case 3: {
                if (this$0.renameMangledUsageIfPossible(usage, $element, $newName)) break;
                ((Collection)$simpleUsages).add(usage);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$substituteElementToRename$preprocessAndPass(PsiElement $element, Editor $editor, Pass $renameCallback, PsiElement substitutedJavaElement) {
        RenameKotlinFunctionProcessor.substituteElementToRename$preprocessAndPass($element, $editor, (Pass<? super PsiElement>)$renameCallback, substitutedJavaElement);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0000\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u0010\u001a\u00020\u00112\u0012\b\u0001\u0010\u0012\u001a\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0096\u0001J\u001d\u0010\u0016\u001a\u00020\u00112\u0012\b\u0001\u0010\u0012\u001a\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0096\u0001J*\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010\u0019J@\u0010\u001a\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0014\b\u0001\u0010\u001b\u001a\u000e\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ@\u0010\u001e\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0014\b\u0001\u0010\u001b\u001a\u000e\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ6\u0010\u001f\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0012\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u001b\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJF\u0010 \u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u0012\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u001b\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u000e\u0010!\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\"JN\u0010#\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0012\b\u0001\u0010\u001b\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u000e\u0010!\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010\"J\u001d\u0010$\u001a\u00020\u00112\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\t\u0010%\u001a\u00020\u0011H\u0097\u0001J\u0016\u0010&\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010'J\t\u0010(\u001a\u00020\u0011H\u0096\u0001J.\u0010)\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u000e\u0010\u001b\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0096\u0001\u00a2\u0006\u0002\u0010*J\u001d\u0010+\u001a\u000e\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0012\u001a\u00020,H\u0097\u0001J\u001d\u0010-\u001a\u000e\u0018\u00010.\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u00152\u0006\u0010\u0012\u001a\u00020,H\u0097\u0001JJ\u0010/\u001a>\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015 \u0018*\u001e\u0012\u0010\b\u0001\u0012\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u001500\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u001500\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001\u00a2\u0006\u0002\u00101J\u0016\u00102\u001a\n \u0018*\u0004\u0018\u00010303H\u0097\u0001\u00a2\u0006\u0002\u00104J\u0015\u00105\u001a\u000e\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015H\u0097\u0001JN\u00106\u001a\u000e\u0018\u0001H7\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015\"\u0010\b\u0000\u00107*\n \u0018*\u0004\u0018\u000108082 \b\u0001\u0010\u0012\u001a\u001a\u0012\f\u0012\n \u0018*\u0004\u0018\u0001H7H709\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001\u00a2\u0006\u0002\u0010:J\u0016\u0010;\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J \u0010<\u001a\n \u0018*\u0004\u0018\u00010=0=2\b\b\u0001\u0010\u0012\u001a\u00020,H\u0096\u0001\u00a2\u0006\u0002\u0010>J\u0013\u0010?\u001a\f0@\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\u0016\u0010A\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J\u0016\u0010B\u001a\n \u0018*\u0004\u0018\u00010C0CH\u0097\u0001\u00a2\u0006\u0002\u0010DJ\u001a\u0010E\u001a\u0013\u0018\u00010F\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\bG\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\u0016\u0010H\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J\u0016\u0010I\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J\u0016\u0010J\u001a\n \u0018*\u0004\u0018\u00010K0KH\u0097\u0001\u00a2\u0006\u0002\u0010LJ\u0016\u0010M\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J\u0016\u0010N\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J\u0016\u0010O\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010'J\u0013\u0010P\u001a\f0Q\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\u0015\u0010R\u001a\u000e\u0018\u00010.\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015H\u0097\u0001JF\u0010S\u001a:\u0012\f\u0012\n \u0018*\u0004\u0018\u00010.0. \u0018*\u001c\u0012\u000e\b\u0001\u0012\n \u0018*\u0004\u0018\u00010.0.00\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u001500\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001\u00a2\u0006\u0002\u0010TJ\u0013\u0010U\u001a\f0V\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\t\u0010W\u001a\u00020,H\u0097\u0001J \u0010X\u001a\u0014 \u0018*\t\u0018\u00010F\u00a2\u0006\u0002\bG0F\u00a2\u0006\u0002\bGH\u0097\u0001\u00a2\u0006\u0002\u0010YJ\t\u0010Z\u001a\u00020,H\u0097\u0001J\t\u0010[\u001a\u00020,H\u0097\u0001J\u0016\u0010\\\u001a\n \u0018*\u0004\u0018\u00010]0]H\u0097\u0001\u00a2\u0006\u0002\u0010^J\u0013\u0010_\u001a\f0`\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001JN\u0010a\u001a\u000e\u0018\u0001H7\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015\"\u0010\b\u0000\u00107*\n \u0018*\u0004\u0018\u000108082 \b\u0001\u0010\u0012\u001a\u001a\u0012\f\u0012\n \u0018*\u0004\u0018\u0001H7H709\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001\u00a2\u0006\u0002\u0010:J\u001e\u0010b\u001a\u00020c2\u000e\u0010\u0012\u001a\n \u0018*\u0004\u0018\u00010\u00070\u0007H\u0097\u0001\u00a2\u0006\u0002\u0010dJ\t\u0010e\u001a\u00020cH\u0097\u0001J\t\u0010f\u001a\u00020cH\u0097\u0001J\t\u0010g\u001a\u00020cH\u0097\u0001J[\u0010h\u001a\u00020c2\u0012\b\u0001\u0010\u0012\u001a\f0i\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0012\b\u0001\u0010\u001b\u001a\f0j\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0014\b\u0001\u0010!\u001a\u000e\u0018\u00010\u0007\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u00152\u0012\b\u0001\u0010k\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0096\u0001JX\u0010l\u001a\u00020\u0011\"\u0010\b\u0000\u00107*\n \u0018*\u0004\u0018\u000108082 \b\u0001\u0010\u0012\u001a\u001a\u0012\f\u0012\n \u0018*\u0004\u0018\u0001H7H709\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0014\b\u0001\u0010\u001b\u001a\u000e\u0018\u0001H7\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010mJX\u0010n\u001a\u00020\u0011\"\u0010\b\u0000\u00107*\n \u0018*\u0004\u0018\u000108082 \b\u0001\u0010\u0012\u001a\u001a\u0012\f\u0012\n \u0018*\u0004\u0018\u0001H7H709\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u00152\u0014\b\u0001\u0010\u001b\u001a\u000e\u0018\u0001H7\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010mJ*\u0010o\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010\u0019J/\u0010p\u001a\n \u0018*\u0004\u0018\u00010\u00070\u00072\u0017\b\u0001\u0010\u0012\u001a\u00110F\u00a2\u0006\u0002\bG\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0096\u0001\u00a2\u0006\u0002\u0010qJ\u0011\u0010r\u001a\u00020c2\u0006\u0010\u0012\u001a\u00020sH\u0097\u0001J\"\u0010t\u001a\u00020c2\u0017\b\u0001\u0010\u0012\u001a\u00110u\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\bv\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\u001d\u0010t\u001a\u00020c2\u0012\b\u0001\u0010\u0012\u001a\f0\u0007\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001J\u0013\u0010w\u001a\f0x\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0097\u0001R\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006y"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/RenameKotlinFunctionProcessor$FunctionWithSupersWrapper;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lcom/intellij/psi/PsiNamedElement;", "originalDeclaration", "supers", "", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Ljava/util/List;)V", "getOriginalDeclaration", "()Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "getSupers", "()Ljava/util/List;", "kotlinOrigin", "getKotlinOrigin", "accept", "", "p0", "Lcom/intellij/psi/PsiElementVisitor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "acceptChildren", "add", "kotlin.jvm.PlatformType", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "addAfter", "p1", "Lorg/jetbrains/annotations/Nullable;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "addBefore", "addRange", "addRangeAfter", "p2", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "addRangeBefore", "checkAdd", "checkDelete", "copy", "()Lcom/intellij/psi/PsiElement;", "delete", "deleteChildRange", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "findElementAt", "", "findReferenceAt", "Lcom/intellij/psi/PsiReference;", "getChildren", "", "()[Lcom/intellij/psi/PsiElement;", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "()Lcom/intellij/psi/PsiFile;", "getContext", "getCopyableUserData", "T", "", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "getFirstChild", "getIcon", "Ljavax/swing/Icon;", "(I)Ljavax/swing/Icon;", "getLanguage", "Lcom/intellij/lang/Language;", "getLastChild", "getManager", "Lcom/intellij/psi/PsiManager;", "()Lcom/intellij/psi/PsiManager;", "getName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getNavigationElement", "getNextSibling", "getNode", "Lcom/intellij/lang/ASTNode;", "()Lcom/intellij/lang/ASTNode;", "getOriginalElement", "getParent", "getPrevSibling", "getProject", "Lcom/intellij/openapi/project/Project;", "getReference", "getReferences", "()[Lcom/intellij/psi/PsiReference;", "getResolveScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "getStartOffsetInParent", "getText", "()Ljava/lang/String;", "getTextLength", "getTextOffset", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "()Lcom/intellij/openapi/util/TextRange;", "getUseScope", "Lcom/intellij/psi/search/SearchScope;", "getUserData", "isEquivalentTo", "", "(Lcom/intellij/psi/PsiElement;)Z", "isPhysical", "isValid", "isWritable", "processDeclarations", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "Lcom/intellij/psi/ResolveState;", "p3", "putCopyableUserData", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "putUserData", "replace", "setName", "(Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "textContains", "", "textMatches", "", "Lorg/jetbrains/annotations/NonNls;", "textToCharArray", "", "kotlin.refactorings.common"})
    private static final class FunctionWithSupersWrapper
    implements KtLightElement<KtNamedFunction, KtNamedFunction>,
    PsiNamedElement {
        @NotNull
        private final KtNamedFunction originalDeclaration;
        @NotNull
        private final List<PsiElement> supers;

        public FunctionWithSupersWrapper(@NotNull KtNamedFunction originalDeclaration, @NotNull List<? extends PsiElement> supers) {
            Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
            Intrinsics.checkNotNullParameter(supers, (String)"supers");
            this.originalDeclaration = originalDeclaration;
            this.supers = supers;
        }

        @NotNull
        public final KtNamedFunction getOriginalDeclaration() {
            return this.originalDeclaration;
        }

        @NotNull
        public final List<PsiElement> getSupers() {
            return this.supers;
        }

        @NotNull
        public KtNamedFunction getKotlinOrigin() {
            return this.originalDeclaration;
        }

        @NotNull
        @Contract(pure=true)
        public Project getProject() {
            Project project = this.originalDeclaration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return project;
        }

        @NotNull
        @Contract(pure=true)
        public Language getLanguage() {
            Language language = this.originalDeclaration.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            return language;
        }

        @Contract(pure=true)
        public PsiManager getManager() {
            return (PsiManager)this.originalDeclaration.getManager();
        }

        @Contract(pure=true)
        @NotNull
        public PsiElement[] getChildren() {
            PsiElement[] psiElementArray = this.originalDeclaration.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            return psiElementArray;
        }

        @Contract(pure=true)
        public PsiElement getParent() {
            return this.originalDeclaration.getParent();
        }

        @Contract(pure=true)
        public PsiElement getFirstChild() {
            return this.originalDeclaration.getFirstChild();
        }

        @Contract(pure=true)
        public PsiElement getLastChild() {
            return this.originalDeclaration.getLastChild();
        }

        @Contract(pure=true)
        public PsiElement getNextSibling() {
            return this.originalDeclaration.getNextSibling();
        }

        @Contract(pure=true)
        public PsiElement getPrevSibling() {
            return this.originalDeclaration.getPrevSibling();
        }

        @Contract(pure=true)
        public PsiFile getContainingFile() {
            return this.originalDeclaration.getContainingFile();
        }

        @Contract(pure=true)
        public TextRange getTextRange() {
            return this.originalDeclaration.getTextRange();
        }

        @Contract(pure=true)
        public int getStartOffsetInParent() {
            return this.originalDeclaration.getStartOffsetInParent();
        }

        @Contract(pure=true)
        public int getTextLength() {
            return this.originalDeclaration.getTextLength();
        }

        @Nullable
        @Contract(pure=true)
        public PsiElement findElementAt(int p0) {
            return this.originalDeclaration.findElementAt(p0);
        }

        @Nullable
        @Contract(pure=true)
        public PsiReference findReferenceAt(int p0) {
            return this.originalDeclaration.findReferenceAt(p0);
        }

        @Contract(pure=true)
        public int getTextOffset() {
            return this.originalDeclaration.getTextOffset();
        }

        @Contract(pure=true)
        @NlsSafe
        public String getText() {
            return this.originalDeclaration.getText();
        }

        @Contract(pure=true)
        @NotNull
        public char[] textToCharArray() {
            char[] cArray = this.originalDeclaration.textToCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"textToCharArray(...)");
            return cArray;
        }

        @Contract(pure=true)
        public PsiElement getNavigationElement() {
            return this.originalDeclaration.getNavigationElement();
        }

        @Contract(pure=true)
        public PsiElement getOriginalElement() {
            return this.originalDeclaration.getOriginalElement();
        }

        @Contract(pure=true)
        public boolean textMatches(@NotNull @NonNls CharSequence p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.textMatches(p0);
        }

        @Contract(pure=true)
        public boolean textMatches(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.textMatches(p0);
        }

        @Contract(pure=true)
        public boolean textContains(char p0) {
            return this.originalDeclaration.textContains(p0);
        }

        public void accept(@NotNull PsiElementVisitor p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.originalDeclaration.accept(p0);
        }

        public void acceptChildren(@NotNull PsiElementVisitor p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.originalDeclaration.acceptChildren(p0);
        }

        public PsiElement copy() {
            return this.originalDeclaration.copy();
        }

        public PsiElement add(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.add(p0);
        }

        public PsiElement addBefore(@NotNull PsiElement p0, @Nullable PsiElement p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.addBefore(p0, p1);
        }

        public PsiElement addAfter(@NotNull PsiElement p0, @Nullable PsiElement p1) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.addAfter(p0, p1);
        }

        @Deprecated(message="Deprecated in Java")
        public void checkAdd(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            this.originalDeclaration.checkAdd(p0);
        }

        public PsiElement addRange(PsiElement p0, PsiElement p1) {
            return this.originalDeclaration.addRange(p0, p1);
        }

        public PsiElement addRangeBefore(@NotNull PsiElement p0, @NotNull PsiElement p1, PsiElement p2) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            return this.originalDeclaration.addRangeBefore(p0, p1, p2);
        }

        public PsiElement addRangeAfter(PsiElement p0, PsiElement p1, PsiElement p2) {
            return this.originalDeclaration.addRangeAfter(p0, p1, p2);
        }

        public void delete() {
            this.originalDeclaration.delete();
        }

        @Deprecated(message="Deprecated in Java")
        public void checkDelete() {
            this.originalDeclaration.checkDelete();
        }

        public void deleteChildRange(PsiElement p0, PsiElement p1) {
            this.originalDeclaration.deleteChildRange(p0, p1);
        }

        public PsiElement replace(@NotNull PsiElement p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.replace(p0);
        }

        @Contract(pure=true)
        public boolean isValid() {
            return this.originalDeclaration.isValid();
        }

        @Contract(pure=true)
        public boolean isWritable() {
            return this.originalDeclaration.isWritable();
        }

        @Nullable
        @Contract(pure=true)
        public PsiReference getReference() {
            return this.originalDeclaration.getReference();
        }

        @Contract(pure=true)
        @NotNull
        public PsiReference[] getReferences() {
            PsiReference[] psiReferenceArray = this.originalDeclaration.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            return psiReferenceArray;
        }

        @Nullable
        @Contract(pure=true)
        public <T> T getCopyableUserData(@NotNull Key<T> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            return (T)this.originalDeclaration.getCopyableUserData(p0);
        }

        public <T> void putCopyableUserData(@NotNull Key<T> p0, @Nullable T p1) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            this.originalDeclaration.putCopyableUserData(p0, p1);
        }

        public boolean processDeclarations(@NotNull PsiScopeProcessor p0, @NotNull ResolveState p1, @Nullable PsiElement p2, @NotNull PsiElement p3) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
            Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
            return this.originalDeclaration.processDeclarations(p0, p1, p2, p3);
        }

        @Nullable
        @Contract(pure=true)
        public PsiElement getContext() {
            return this.originalDeclaration.getContext();
        }

        @Contract(pure=true)
        public boolean isPhysical() {
            return this.originalDeclaration.isPhysical();
        }

        @NotNull
        @Contract(pure=true)
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = this.originalDeclaration.getResolveScope();
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
            return globalSearchScope;
        }

        @NotNull
        @Contract(pure=true)
        public SearchScope getUseScope() {
            SearchScope searchScope = this.originalDeclaration.getUseScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
            return searchScope;
        }

        @Contract(pure=true)
        public ASTNode getNode() {
            return this.originalDeclaration.getNode();
        }

        @Contract(pure=true)
        public boolean isEquivalentTo(PsiElement p0) {
            return this.originalDeclaration.isEquivalentTo(p0);
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> p0) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            return (T)this.originalDeclaration.getUserData(p0);
        }

        public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
            Intrinsics.checkNotNullParameter(p0, (String)"p0");
            this.originalDeclaration.putUserData(p0, p1);
        }

        public Icon getIcon(@Iconable.IconFlags int p0) {
            return this.originalDeclaration.getIcon(p0);
        }

        @Nullable
        @NlsSafe
        public String getName() {
            return this.originalDeclaration.getName();
        }

        public PsiElement setName(@NlsSafe @NotNull String p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return this.originalDeclaration.setName(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RenameKotlinPsiProcessor.ImportState.values().length];
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.AMBIGUOUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.SIMPLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RenameKotlinPsiProcessor.ImportState.NOT_IMPORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

