/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.move.moveInner.MoveInnerClassUsagesHandler;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.MultiMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.move.ImplicitCompanionAsDispatchReceiverUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSource;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveContainerInfo;
import org.jetbrains.kotlin.idea.refactoring.move.MoveUtilKt;
import org.jetbrains.kotlin.idea.refactoring.move.OuterInstanceReferenceUsageInfo;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u001a\u001bJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J&\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u0082\u0001\u0002\u001c\u001d\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate;", "", "getContainerChangeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/move/MoveContainerChangeInfo;", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "moveTarget", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "findInternalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "moveSource", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveSource;", "collectConflicts", "", "internalUsages", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "preprocessDeclaration", "preprocessUsages", "project", "Lcom/intellij/openapi/project/Project;", "usages", "TopLevel", "NestedClass", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate$NestedClass;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate$TopLevel;", "kotlin.idea"})
public interface KotlinMoveDeclarationDelegate {
    @NotNull
    public MoveContainerChangeInfo getContainerChangeInfo(@NotNull KtNamedDeclaration var1, @NotNull KotlinMoveTarget var2);

    @NotNull
    default public List<UsageInfo> findInternalUsages(@NotNull KotlinMoveSource moveSource) {
        Intrinsics.checkNotNullParameter((Object)moveSource, (String)"moveSource");
        return CollectionsKt.emptyList();
    }

    default public void collectConflicts(@NotNull KotlinMoveTarget moveTarget, @NotNull Set<UsageInfo> internalUsages, @NotNull MultiMap<PsiElement, String> conflicts) {
        Intrinsics.checkNotNullParameter((Object)moveTarget, (String)"moveTarget");
        Intrinsics.checkNotNullParameter(internalUsages, (String)"internalUsages");
        Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
    }

    default public void preprocessDeclaration(@NotNull KotlinMoveTarget moveTarget, @NotNull KtNamedDeclaration originalDeclaration) {
        Intrinsics.checkNotNullParameter((Object)moveTarget, (String)"moveTarget");
        Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
    }

    default public void preprocessUsages(@NotNull Project project, @NotNull KotlinMoveSource moveSource, @NotNull List<? extends UsageInfo> usages2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)moveSource, (String)"moveSource");
        Intrinsics.checkNotNullParameter(usages2, (String)"usages");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate$NestedClass;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate;", "newClassName", "", "outerInstanceParameterName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getNewClassName", "()Ljava/lang/String;", "getContainerChangeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/move/MoveContainerChangeInfo;", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "moveTarget", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "findInternalUsages", "", "Lcom/intellij/usageView/UsageInfo;", "moveSource", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveSource;", "collectConflicts", "", "internalUsages", "", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "preprocessDeclaration", "preprocessUsages", "project", "Lcom/intellij/openapi/project/Project;", "usages", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinMoveDeclarationDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMoveDeclarationDelegate.kt\norg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate$NestedClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public static final class NestedClass
    implements KotlinMoveDeclarationDelegate {
        @Nullable
        private final String newClassName;
        @Nullable
        private final String outerInstanceParameterName;

        public NestedClass(@Nullable String newClassName, @Nullable String outerInstanceParameterName) {
            this.newClassName = newClassName;
            this.outerInstanceParameterName = outerInstanceParameterName;
        }

        public /* synthetic */ NestedClass(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Nullable
        public final String getNewClassName() {
            return this.newClassName;
        }

        @Override
        @NotNull
        public MoveContainerChangeInfo getContainerChangeInfo(@NotNull KtNamedDeclaration originalDeclaration, @NotNull KotlinMoveTarget moveTarget) {
            Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
            Intrinsics.checkNotNullParameter((Object)moveTarget, (String)"moveTarget");
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)originalDeclaration));
            Intrinsics.checkNotNull((Object)ktClassOrObject);
            FqName fqName2 = ktClassOrObject.getFqName();
            Intrinsics.checkNotNull((Object)fqName2);
            MoveContainerInfo.Class originalInfo = new MoveContainerInfo.Class(fqName2);
            KotlinMoveTarget.ExistingElement existingElement = moveTarget instanceof KotlinMoveTarget.ExistingElement ? (KotlinMoveTarget.ExistingElement)moveTarget : null;
            boolean movingToClass = (existingElement != null ? existingElement.getTargetElement() : null) instanceof KtClassOrObject;
            FqName targetContainerFqName = moveTarget.getTargetContainerFqName();
            MoveContainerInfo newInfo = targetContainerFqName == null ? (MoveContainerInfo)MoveContainerInfo.UnknownPackage.INSTANCE : (movingToClass ? (MoveContainerInfo)new MoveContainerInfo.Class(targetContainerFqName) : (MoveContainerInfo)new MoveContainerInfo.Package(targetContainerFqName));
            return new MoveContainerChangeInfo(originalInfo, newInfo);
        }

        @Override
        @NotNull
        public List<UsageInfo> findInternalUsages(@NotNull KotlinMoveSource moveSource) {
            Intrinsics.checkNotNullParameter((Object)moveSource, (String)"moveSource");
            Object object = CollectionsKt.singleOrNull((Iterable)moveSource.getElementsToMove());
            KtClass ktClass = object instanceof KtClass ? (KtClass)object : null;
            if (ktClass == null) {
                return CollectionsKt.emptyList();
            }
            KtClass classToMove = ktClass;
            return MoveUtilKt.collectOuterInstanceReferences((KtNamedDeclaration)classToMove);
        }

        @Override
        public void collectConflicts(@NotNull KotlinMoveTarget moveTarget, @NotNull Set<UsageInfo> internalUsages, @NotNull MultiMap<PsiElement, String> conflicts) {
            Intrinsics.checkNotNullParameter((Object)moveTarget, (String)"moveTarget");
            Intrinsics.checkNotNullParameter(internalUsages, (String)"internalUsages");
            Intrinsics.checkNotNullParameter(conflicts, (String)"conflicts");
            Iterator<UsageInfo> usageIterator = internalUsages.iterator();
            while (usageIterator.hasNext()) {
                boolean isConflict;
                boolean bl;
                UsageInfo usage = usageIterator.next();
                if (usage.getElement() == null) continue;
                UsageInfo usageInfo = usage;
                if (usageInfo instanceof ImplicitCompanionAsDispatchReceiverUsageInfo) {
                    boolean isValidTarget = MoveUtilKt.isValidTargetForImplicitCompanionAsDispatchReceiver(moveTarget, ((ImplicitCompanionAsDispatchReceiverUsageInfo)usage).getCompanionObject());
                    if (!isValidTarget) {
                        PsiElement element;
                        Object[] objectArray = new Object[]{element.getText()};
                        conflicts.putValue((Object)element, (Object)KotlinBundle.message((String)"text.implicit.companion.object.will.be.inaccessible.0", (Object[])objectArray));
                    }
                    bl = true;
                } else {
                    bl = usageInfo instanceof OuterInstanceReferenceUsageInfo ? ((OuterInstanceReferenceUsageInfo)usage).reportConflictIfAny(conflicts) : false;
                }
                if (!(isConflict = bl)) continue;
                usageIterator.remove();
            }
        }

        @Override
        public void preprocessDeclaration(@NotNull KotlinMoveTarget moveTarget, @NotNull KtNamedDeclaration originalDeclaration) {
            Intrinsics.checkNotNullParameter((Object)moveTarget, (String)"moveTarget");
            Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
            KtNamedDeclaration $this$preprocessDeclaration_u24lambda_u241 = originalDeclaration;
            boolean bl = false;
            String string = this.newClassName;
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                $this$preprocessDeclaration_u24lambda_u241.setName(it);
            }
            if ($this$preprocessDeclaration_u24lambda_u241 instanceof KtClass) {
                KotlinMoveTarget.ExistingElement existingElement = moveTarget instanceof KotlinMoveTarget.ExistingElement ? (KotlinMoveTarget.ExistingElement)moveTarget : null;
                if (!((existingElement != null ? existingElement.getTargetElement() : null) instanceof KtClassOrObject)) {
                    if (((KtClass)$this$preprocessDeclaration_u24lambda_u241).hasModifier(KtTokens.INNER_KEYWORD)) {
                        ((KtClass)$this$preprocessDeclaration_u24lambda_u241).removeModifier(KtTokens.INNER_KEYWORD);
                    }
                    if (((KtClass)$this$preprocessDeclaration_u24lambda_u241).hasModifier(KtTokens.PROTECTED_KEYWORD)) {
                        ((KtClass)$this$preprocessDeclaration_u24lambda_u241).removeModifier(KtTokens.PROTECTED_KEYWORD);
                    }
                }
                if (this.outerInstanceParameterName != null) {
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$preprocessDeclaration_u24lambda_u241));
                    if (ktClassOrObject == null) {
                        return;
                    }
                    KtClassOrObject containingClass = ktClassOrObject;
                    String type2 = MoveUtilKt.renderType(containingClass);
                    Project bl2 = ((KtClass)$this$preprocessDeclaration_u24lambda_u241).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"getProject(...)");
                    KtParameter parameter = new KtPsiFactory(bl2, false, 2, null).createParameter("private val " + this.outerInstanceParameterName + ": " + type2);
                    KtParameter ktParameter = KtClassKt.createPrimaryConstructorParameterListIfAbsent((KtClass)((KtClass)$this$preprocessDeclaration_u24lambda_u241)).addParameter(parameter);
                    Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"addParameter(...)");
                    KtParameter addedParameter = ktParameter;
                    MoveUtilKt.addDelayedShorteningRequest((KtElement)addedParameter);
                }
            }
        }

        @Override
        public void preprocessUsages(@NotNull Project project, @NotNull KotlinMoveSource moveSource, @NotNull List<? extends UsageInfo> usages2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)moveSource, (String)"moveSource");
            Intrinsics.checkNotNullParameter(usages2, (String)"usages");
            if (this.outerInstanceParameterName == null) {
                return;
            }
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            KtExpression newOuterInstanceRef = psiFactory.createExpression(this.outerInstanceParameterName);
            Iterator<? extends UsageInfo> iterator = CollectionsKt.singleOrNull((Iterable)moveSource.getElementsToMove());
            KtClass classToMove = iterator instanceof KtClass ? (KtClass)iterator : null;
            for (UsageInfo usageInfo : usages2) {
                UsageInfo usageInfo2;
                if (usageInfo instanceof MoveRenameUsageInfo) {
                    KtClassOrObject referencedNestedClass;
                    PsiElement psiElement = ((MoveRenameUsageInfo)usageInfo).getReferencedElement();
                    PsiElement psiElement2 = psiElement != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement) : null;
                    KtClassOrObject ktClassOrObject = referencedNestedClass = psiElement2 instanceof KtClassOrObject ? (KtClassOrObject)psiElement2 : null;
                    if (Intrinsics.areEqual((Object)referencedNestedClass, (Object)classToMove)) {
                        KtLightClass lightOuterClass;
                        KtClassOrObject outerClass;
                        KtClassOrObject ktClassOrObject2 = referencedNestedClass;
                        KtClassOrObject ktClassOrObject3 = outerClass = ktClassOrObject2 != null ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)ktClassOrObject2)) : null;
                        Object object = lightOuterClass = ktClassOrObject3 != null ? LightClassUtilsKt.toLightClass((KtClassOrObject)ktClassOrObject3) : null;
                        if (lightOuterClass != null) {
                            PsiElement psiElement3 = ((MoveRenameUsageInfo)usageInfo).getElement();
                            if (psiElement3 == null || (psiElement3 = psiElement3.getLanguage()) == null) {
                                return;
                            }
                            MoveInnerClassUsagesHandler moveInnerClassUsagesHandler = (MoveInnerClassUsagesHandler)MoveInnerClassUsagesHandler.EP_NAME.forLanguage((Language)psiElement3);
                            if (moveInnerClassUsagesHandler != null) {
                                moveInnerClassUsagesHandler.correctInnerClassUsage(usageInfo, (PsiClass)lightOuterClass, this.outerInstanceParameterName);
                            }
                        }
                    }
                }
                if ((usageInfo2 = usageInfo) instanceof OuterInstanceReferenceUsageInfo.ExplicitThis) {
                    ((OuterInstanceReferenceUsageInfo.ExplicitThis)usageInfo).getExpression().replace((PsiElement)newOuterInstanceRef);
                    continue;
                }
                if (!(usageInfo2 instanceof OuterInstanceReferenceUsageInfo.ImplicitReceiver)) continue;
                KtElement it = ((OuterInstanceReferenceUsageInfo.ImplicitReceiver)usageInfo).getCallElement();
                boolean bl = false;
                Object[] objectArray = new Object[]{this.outerInstanceParameterName, it};
                it.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.$1", (Object[])objectArray, (boolean)false, (int)4, null));
            }
        }

        public NestedClass() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate$TopLevel;", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate;", "<init>", "()V", "getContainerChangeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/move/MoveContainerChangeInfo;", "originalDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "moveTarget", "Lorg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveTarget;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinMoveDeclarationDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMoveDeclarationDelegate.kt\norg/jetbrains/kotlin/idea/refactoring/move/KotlinMoveDeclarationDelegate$TopLevel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
    public static final class TopLevel
    implements KotlinMoveDeclarationDelegate {
        @NotNull
        public static final TopLevel INSTANCE = new TopLevel();

        private TopLevel() {
        }

        @Override
        @NotNull
        public MoveContainerChangeInfo getContainerChangeInfo(@NotNull KtNamedDeclaration originalDeclaration, @NotNull KotlinMoveTarget moveTarget) {
            MoveContainerInfo moveContainerInfo;
            Intrinsics.checkNotNullParameter((Object)originalDeclaration, (String)"originalDeclaration");
            Intrinsics.checkNotNullParameter((Object)moveTarget, (String)"moveTarget");
            MoveContainerInfo.Package sourcePackage = new MoveContainerInfo.Package(originalDeclaration.getContainingKtFile().getPackageFqName());
            FqName fqName2 = moveTarget.getTargetContainerFqName();
            if (fqName2 != null) {
                FqName it = fqName2;
                boolean bl = false;
                moveContainerInfo = new MoveContainerInfo.Package(it);
            } else {
                moveContainerInfo = MoveContainerInfo.UnknownPackage.INSTANCE;
            }
            MoveContainerInfo targetPackage = moveContainerInfo;
            return new MoveContainerChangeInfo(sourcePackage, targetPackage);
        }
    }
}

