/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsEditorCookie;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsIntentionAction;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "<init>", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Registrar", "MoveDeclarationsPass", "kotlin.idea"})
public final class MoveDeclarationsPassFactory
implements TextEditorHighlightingPassFactory {
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new MoveDeclarationsPass(project, psiFile, editor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$MoveDeclarationsPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "buildHighlightingInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "kotlin.idea"})
    private static final class MoveDeclarationsPass
    extends TextEditorHighlightingPass {
        @NotNull
        private final Project project;
        @NotNull
        private final PsiFile file;
        @NotNull
        private final Editor editor;

        public MoveDeclarationsPass(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(project, editor.getDocument(), true);
            this.project = project;
            this.file = file;
            this.editor = editor;
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
            HighlightInfo info2 = this.buildHighlightingInfo();
            if (info2 != null) {
                BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.project, (PsiFile)this.file, (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)CollectionsKt.listOf((Object)info2), (int)this.getId());
            }
        }

        public void doApplyInformationToEditor() {
        }

        private final HighlightInfo buildHighlightingInfo() {
            MoveDeclarationsEditorCookie moveDeclarationsEditorCookie = (MoveDeclarationsEditorCookie)this.editor.getUserData(MoveDeclarationsEditorCookie.Companion.getKEY());
            if (moveDeclarationsEditorCookie == null) {
                return null;
            }
            MoveDeclarationsEditorCookie cookie = moveDeclarationsEditorCookie;
            if (cookie.getModificationCount() != PsiModificationTracker.getInstance((Project)this.project).getModificationCount()) {
                return null;
            }
            MoveDeclarationsProcessor processor2 = MoveDeclarationsProcessor.Companion.build(this.file, cookie);
            if (processor2 == null) {
                this.editor.putUserData(MoveDeclarationsEditorCookie.Companion.getKEY(), null);
                return null;
            }
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION);
            TextRange textRange = RangeMarkersKt.getAsTextRange((RangeMarker)cookie.getBounds());
            Intrinsics.checkNotNull((Object)textRange);
            return builder2.range(textRange).registerFix((IntentionAction)new MoveDeclarationsIntentionAction(processor2, cookie.getBounds(), cookie.getModificationCount()), null, null, null, null).createUnconditionally();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsPassFactory$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "<init>", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.idea"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new MoveDeclarationsPassFactory(), TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 3, true, true);
        }
    }
}

