/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.refactoring.CompositeRefactoringRunner;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringEventListener;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH$J\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\rH\u0014J\u0006\u0010\u0010\u001a\u00020\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/CompositeRefactoringRunner;", "", "project", "Lcom/intellij/openapi/project/Project;", "refactoringId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRefactoringId", "()Ljava/lang/String;", "runRefactoring", "", "onRefactoringDone", "onExit", "run", "kotlin.idea"})
public abstract class CompositeRefactoringRunner {
    @NotNull
    private final Project project;
    @NotNull
    private final String refactoringId;

    public CompositeRefactoringRunner(@NotNull Project project, @NotNull String refactoringId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
        this.project = project;
        this.refactoringId = refactoringId;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getRefactoringId() {
        return this.refactoringId;
    }

    protected abstract void runRefactoring();

    protected void onRefactoringDone() {
    }

    protected void onExit() {
    }

    public final void run() {
        MessageBusConnection connection = this.project.getMessageBus().connect();
        Topic topic = RefactoringEventListener.REFACTORING_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"REFACTORING_EVENT_TOPIC");
        connection.subscribe(topic, (Object)new RefactoringEventListener(this){
            final /* synthetic */ CompositeRefactoringRunner this$0;
            {
                this.this$0 = $receiver;
            }

            public void refactoringDone(String refactoringId, RefactoringEventData afterData) {
                Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
                if (Intrinsics.areEqual((Object)refactoringId, (Object)this.this$0.getRefactoringId())) {
                    WriteAction.run(() -> run.1.refactoringDone$lambda$0(this.this$0));
                }
            }

            private static final void refactoringDone$lambda$0(CompositeRefactoringRunner this$0) {
                this$0.onRefactoringDone();
            }
        });
        connection.subscribe(KotlinRefactoringEventListener.Companion.getEVENT_TOPIC(), (Object)new KotlinRefactoringEventListener(this, connection){
            final /* synthetic */ CompositeRefactoringRunner this$0;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.this$0 = $receiver;
                this.$connection = $connection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRefactoringExit(String refactoringId) {
                Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
                if (Intrinsics.areEqual((Object)refactoringId, (Object)this.this$0.getRefactoringId())) {
                    try {
                        this.this$0.onExit();
                    }
                    finally {
                        this.$connection.disconnect();
                    }
                }
            }
        });
        this.runRefactoring();
    }
}

