/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0094\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveSingleLambdaParameterFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "kotlin.idea"})
public final class RemoveSingleLambdaParameterFix
extends KotlinQuickFixAction<KtParameter> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RemoveSingleLambdaParameterFix(@NotNull KtParameter element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"remove.single.lambda.parameter.declaration", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtParameter ktParameter = (KtParameter)this.getElement();
        if (ktParameter == null) {
            return;
        }
        KtParameter element = ktParameter;
        PsiElement psiElement = element.getParent();
        KtParameterList ktParameterList = psiElement instanceof KtParameterList ? (KtParameterList)psiElement : null;
        if (ktParameterList == null) {
            return;
        }
        KtParameterList parameterList = ktParameterList;
        KtDeclarationWithBody ktDeclarationWithBody = parameterList.getOwnerFunction();
        if (ktDeclarationWithBody == null) {
            return;
        }
        KtDeclarationWithBody ownerFunction = ktDeclarationWithBody;
        ASTNode aSTNode = ownerFunction.getNode().findChildByType((IElementType)KtTokens.ARROW);
        if (aSTNode == null) {
            return;
        }
        ASTNode arrow = aSTNode;
        parameterList.delete();
        ownerFunction.getNode().removeChild(arrow);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/RemoveSingleLambdaParameterFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nRemoveSingleLambdaParameterFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveSingleLambdaParameterFix.kt\norg/jetbrains/kotlin/idea/quickfix/RemoveSingleLambdaParameterFix$Companion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,52:1\n213#2:53\n*S KotlinDebug\n*F\n+ 1 RemoveSingleLambdaParameterFix.kt\norg/jetbrains/kotlin/idea/quickfix/RemoveSingleLambdaParameterFix$Companion\n*L\n46#1:53\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement = diagnostic.getPsiElement();
            KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
            if (ktParameter == null) {
                return null;
            }
            KtParameter parameter = ktParameter;
            PsiElement psiElement2 = parameter.getParent();
            KtParameterList ktParameterList = psiElement2 instanceof KtParameterList ? (KtParameterList)psiElement2 : null;
            if (ktParameterList == null) {
                return null;
            }
            KtParameterList parameterList = ktParameterList;
            if (parameterList.getParameters().size() != 1) {
                return null;
            }
            KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(KtFunctionLiteral.class)};
            KtLambdaExpression ktLambdaExpression = (KtLambdaExpression)CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)((PsiElement)parameterList)), kClassArray, Reflection.getOrCreateKotlinClass(KtLambdaExpression.class));
            if (ktLambdaExpression == null) {
                return null;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression;
            PsiElement lambdaParent = lambda2.getParent();
            if (lambdaParent instanceof KtWhenEntry || lambdaParent instanceof KtContainerNodeForControlStructureBody) {
                return null;
            }
            if (KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)lambda2)) != null) {
                return null;
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)lambda2;
            boolean $i$f$getStrictParentOfType = false;
            KtProperty property = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtProperty.class, (boolean)true);
            if (property != null && property.getTypeReference() == null) {
                return null;
            }
            return new RemoveSingleLambdaParameterFix(parameter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

