/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.utils.fqname.FqNameUtilKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinPsiOnlyQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.PsiElementSuitabilityCheckers;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixesPsiBasedFactory;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0002J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0094\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OverloadResolutionChangeFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinPsiOnlyQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getTypeArgumentForCast", "", "expression", "invoke", "", "getText", "getFamilyName", "Companion", "kotlin.idea"})
public final class OverloadResolutionChangeFix
extends KotlinPsiOnlyQuickFixAction<KtExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public OverloadResolutionChangeFix(@NotNull KtExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
    }

    @Override
    protected boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getElement() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getTypeArgumentForCast(KtExpression expression) {
        Object fqName2;
        KotlinType kotlinType = KtDfaHelpersKt.getKotlinType(expression);
        if (kotlinType == null) {
            return null;
        }
        KotlinType exprType2 = kotlinType;
        FqName fqName3 = FqNameUtilKt.getFqName(exprType2);
        Object object = fqName3;
        if (fqName3 == null) return null;
        if ((object = object.asString()) == null) {
            return null;
        }
        Object object2 = fqName2 = object;
        switch (((String)object2).hashCode()) {
            case 1012823964: {
                if (((String)object2).equals("kotlin.ranges.CharRange")) return "Char";
                return null;
            }
            case 1121085879: {
                if (((String)object2).equals("kotlin.ranges.ULongRange")) return "ULong";
                return null;
            }
            case -421901258: {
                if (((String)object2).equals("kotlin.ranges.LongRange")) return "Long";
                return null;
            }
            case -939226568: {
                if (((String)object2).equals("kotlin.ranges.UIntRange")) return "UInt";
                return null;
            }
            case -1404642343: {
                if (!((String)object2).equals("kotlin.ranges.IntRange")) return null;
                return "Int";
            }
        }
        return null;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression = ktExpression;
        String string = this.getTypeArgumentForCast(expression);
        if (string == null) {
            return;
        }
        String typeArgument = string;
        Object[] objectArray = new Object[]{expression, typeArgument};
        KtExpression casted = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"($0) as Iterable<$1>", (Object[])objectArray, (boolean)false, (int)4, null);
        expression.replace((PsiElement)casted);
    }

    @NotNull
    public String getText() {
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return "";
        }
        KtExpression expression = ktExpression;
        String string = this.getTypeArgumentForCast(expression);
        if (string == null) {
            return "";
        }
        String typeArgument = string;
        Object[] objectArray = new Object[]{"Iterable<" + typeArgument + ">"};
        String string2 = QuickFixBundle.message((String)"add.typecast.text", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message((String)"add.typecast.family", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/OverloadResolutionChangeFix$Companion;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixesPsiBasedFactory;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "doCreateQuickFix", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "psiElement", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nOverloadResolutionChangeFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OverloadResolutionChangeFix.kt\norg/jetbrains/kotlin/idea/quickfix/OverloadResolutionChangeFix$Companion\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,60:1\n123#2:61\n*S KotlinDebug\n*F\n+ 1 OverloadResolutionChangeFix.kt\norg/jetbrains/kotlin/idea/quickfix/OverloadResolutionChangeFix$Companion\n*L\n25#1:61\n*E\n"})
    public static final class Companion
    extends QuickFixesPsiBasedFactory<PsiElement> {
        private Companion() {
            super(Reflection.getOrCreateKotlinClass(PsiElement.class), PsiElementSuitabilityCheckers.INSTANCE.getALWAYS_SUITABLE());
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateQuickFix(@NotNull PsiElement psiElement) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            PsiElement $this$safeAs$iv = psiElement;
            boolean $i$f$safeAs = false;
            PsiElement psiElement2 = $this$safeAs$iv;
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement2;
            if (ktExpression == null) {
                return CollectionsKt.emptyList();
            }
            KtExpression expression = ktExpression;
            return CollectionsKt.listOf((Object)new OverloadResolutionChangeFix(expression));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

