/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.ChangeVariableMutabilityFix;
import org.jetbrains.kotlin.idea.quickfix.AssignOperatorAmbiguityFactoryKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.ReplaceWithAssignFunctionCallFix;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AssignOperatorAmbiguityFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class AssignOperatorAmbiguityFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final AssignOperatorAmbiguityFactory INSTANCE = new AssignOperatorAmbiguityFactory();

    private AssignOperatorAmbiguityFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        List fixes = new ArrayList();
        PsiElement element = diagnostic.getPsiElement().getParent();
        if (element instanceof KtBinaryExpression) {
            BindingContext context;
            String operationText;
            KtExpression left = ((KtBinaryExpression)element).getLeft();
            KtExpression right = ((KtBinaryExpression)element).getRight();
            IElementType iElementType = ((KtBinaryExpression)element).getOperationToken();
            String string = Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) ? "plus" : (operationText = Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) ? "minus" : null);
            if (left != null && right != null && operationText != null && AssignOperatorAmbiguityFactoryKt.access$isMutableCollection(CallUtilKt.getType((KtExpression)left, (BindingContext)(context = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL))))) {
                String propertyName;
                KtProperty property;
                KtReference ktReference = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)left));
                PsiElement psiElement = ktReference != null ? ktReference.resolve() : null;
                KtProperty ktProperty = property = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
                String string2 = propertyName = ktProperty != null ? ktProperty.getName() : null;
                if (property != null && propertyName != null && property.isLocal()) {
                    Object[] objectArray = new Object[]{propertyName};
                    ChangeVariableMutabilityFix fix3 = new ChangeVariableMutabilityFix((KtValVarKeywordOwner)property, false, KotlinBundle.message((String)"fix.change.mutability.change.to.val", (Object[])objectArray), false, 8, null);
                    fixes.add(fix3);
                }
                fixes.add(new ReplaceWithAssignFunctionCallFix((KtBinaryExpression)element, operationText));
            }
        }
        return fixes;
    }
}

