/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.quickfix.AddGenericUpperBoundFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "<init>", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "createActionsByInferenceData", "inferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "createAction", "argument", "Lorg/jetbrains/kotlin/types/KotlinType;", "upperBound", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddGenericUpperBoundFixFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddGenericUpperBoundFixFactory.kt\norg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFixFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1611#2,9:82\n1863#2:91\n1864#2:93\n1620#2:94\n1#3:92\n*S KotlinDebug\n*F\n+ 1 AddGenericUpperBoundFixFactory.kt\norg/jetbrains/kotlin/idea/quickfix/AddGenericUpperBoundFixFactory\n*L\n49#1:82,9\n49#1:91\n49#1:93\n49#1:94\n49#1:92\n*E\n"})
public final class AddGenericUpperBoundFixFactory
extends KotlinIntentionActionsFactory {
    @NotNull
    public static final AddGenericUpperBoundFixFactory INSTANCE = new AddGenericUpperBoundFixFactory();

    private AddGenericUpperBoundFixFactory() {
    }

    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
        if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.UPPER_BOUND_VIOLATED)) {
            DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)Errors.UPPER_BOUND_VIOLATED.cast((UnboundDiagnostic)diagnostic);
            Object object = upperBoundViolated.getB();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-b>(...)");
            KotlinType kotlinType = (KotlinType)object;
            Object object2 = upperBoundViolated.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-a>(...)");
            list2 = CollectionsKt.listOfNotNull((Object)this.createAction(kotlinType, (KotlinType)object2));
        } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED)) {
            Object object = ((DiagnosticWithParameters1)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.cast((UnboundDiagnostic)diagnostic)).getA();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
            InferenceErrorData inferenceData = (InferenceErrorData)object;
            list2 = this.createActionsByInferenceData(inferenceData);
        } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS)) {
            DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)ErrorsJvm.UPPER_BOUND_VIOLATED_BASED_ON_JAVA_ANNOTATIONS.cast((UnboundDiagnostic)diagnostic);
            Object object = upperBoundViolated.getB();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-b>(...)");
            KotlinType kotlinType = (KotlinType)object;
            Object object3 = upperBoundViolated.getA();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"<get-a>(...)");
            list2 = CollectionsKt.listOfNotNull((Object)this.createAction(kotlinType, (KotlinType)object3));
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IntentionAction> createActionsByInferenceData(InferenceErrorData inferenceData) {
        void $this$mapNotNullTo$iv$iv;
        ConstraintSystem constraintSystem = inferenceData.constraintSystem;
        Intrinsics.checkNotNullExpressionValue((Object)constraintSystem, (String)"constraintSystem");
        ConstraintSystem successfulConstraintSystem = ConstraintSystemUtilsKt.filterConstraintsOut((ConstraintSystem)constraintSystem, (ConstraintPositionKind)ConstraintPositionKind.TYPE_BOUND_POSITION);
        if (!successfulConstraintSystem.getStatus().isSuccessful()) {
            return CollectionsKt.emptyList();
        }
        TypeSubstitutor resultingSubstitutor = successfulConstraintSystem.getResultingSubstitutor();
        List list2 = inferenceData.descriptor.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTypeParameters(...)");
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            IntentionAction intentionAction;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)element$iv$iv;
            boolean bl2 = false;
            if (ConstraintsUtil.checkUpperBoundIsSatisfied((ConstraintSystem)successfulConstraintSystem, (TypeParameterDescriptor)typeParameterDescriptor, (Call)inferenceData.call, (boolean)true)) {
                intentionAction = null;
            } else {
                KotlinType upperBound;
                KotlinType argument2;
                List list3 = typeParameterDescriptor.getUpperBounds();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getUpperBounds(...)");
                intentionAction = (KotlinType)CollectionsKt.singleOrNull((List)list3) == null ? null : (resultingSubstitutor.substitute((KotlinType)typeParameterDescriptor.getDefaultType(), Variance.INVARIANT) == null ? null : INSTANCE.createAction(argument2, upperBound));
            }
            if (intentionAction == null) continue;
            IntentionAction it$iv$iv = intentionAction;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final IntentionAction createAction(KotlinType argument2, KotlinType upperBound) {
        if (!upperBound.getConstructor().isDenotable()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = argument2.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = classifierDescriptor instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)classifierDescriptor : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
        PsiElement psiElement = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)((DeclarationDescriptor)typeParameterDescriptor2));
        KtTypeParameter ktTypeParameter = psiElement instanceof KtTypeParameter ? (KtTypeParameter)psiElement : null;
        if (ktTypeParameter == null) {
            return null;
        }
        KtTypeParameter typeParameterDeclaration = ktTypeParameter;
        if (typeParameterDeclaration.getName() == null || typeParameterDeclaration.getExtendsBound() != null) {
            return null;
        }
        return new AddGenericUpperBoundFix(typeParameterDeclaration, IdeDescriptorRenderers.SOURCE_CODE.renderType(upperBound), IdeDescriptorRenderers.SOURCE_CODE_TYPES_WITH_SHORT_NAMES.renderType(upperBound)).asIntention();
    }
}

