/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.projectView.impl.nodes.FileNodeWithNestedFileNodes;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.idea.base.projectStructure.LibrarySourceScopeService;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNodeKt;
import org.jetbrains.kotlin.idea.stubindex.KotlinFileFacadeFqNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinJvmNameAnnotationIndex;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B3\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\u0012\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0016J\u0012\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0014J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014R\u0018\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KtInternalFileTreeNode;", "Lcom/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode;", "Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;", "Lcom/intellij/ide/projectView/impl/nodes/FileNodeWithNestedFileNodes;", "project", "Lcom/intellij/openapi/project/Project;", "lightClass", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "nestedFileNodes", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/asJava/classes/KtLightClass;Lcom/intellij/ide/projectView/ViewSettings;Ljava/util/Collection;)V", "navigatablePsiElement", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtElement;", "getNavigatablePsiElement", "()Lcom/intellij/psi/SmartPsiElementPointer;", "navigatablePsiElement$delegate", "Lkotlin/Lazy;", "extractPsiFromValue", "Lcom/intellij/psi/PsiElement;", "getNestedFileNodes", "getChildrenImpl", "canRepresent", "", "element", "", "updateImpl", "", "data", "Lcom/intellij/ide/projectView/PresentationData;", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nKtInternalFileTreeNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtInternalFileTreeNode.kt\norg/jetbrains/kotlin/idea/projectView/KtInternalFileTreeNode\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n66#2,2:102\n1#3:104\n*S KotlinDebug\n*F\n+ 1 KtInternalFileTreeNode.kt\norg/jetbrains/kotlin/idea/projectView/KtInternalFileTreeNode\n*L\n51#1:102,2\n*E\n"})
public final class KtInternalFileTreeNode
extends AbstractPsiBasedNode<KtLightClass>
implements FileNodeWithNestedFileNodes {
    @NotNull
    private final Collection<AbstractTreeNode<?>> nestedFileNodes;
    @NotNull
    private final Lazy navigatablePsiElement$delegate;

    public KtInternalFileTreeNode(@Nullable Project project, @NotNull KtLightClass lightClass, @NotNull ViewSettings viewSettings, @NotNull Collection<? extends AbstractTreeNode<?>> nestedFileNodes) {
        Intrinsics.checkNotNullParameter((Object)lightClass, (String)"lightClass");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter(nestedFileNodes, (String)"nestedFileNodes");
        super(project, (Object)lightClass, viewSettings);
        this.nestedFileNodes = nestedFileNodes;
        this.navigatablePsiElement$delegate = LazyKt.lazy(() -> KtInternalFileTreeNode.navigatablePsiElement_delegate$lambda$5(this));
    }

    private final SmartPsiElementPointer<KtElement> getNavigatablePsiElement() {
        Lazy lazy = this.navigatablePsiElement$delegate;
        return (SmartPsiElementPointer)lazy.getValue();
    }

    @Nullable
    protected PsiElement extractPsiFromValue() {
        KtElement ktElement = this.getNavigatablePsiElement();
        return ktElement != null && (ktElement = (KtElement)ktElement.getElement()) != null ? (PsiElement)ktElement : (PsiElement)this.getValue();
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getNestedFileNodes() {
        return this.nestedFileNodes;
    }

    @NotNull
    protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
        Collection<AbstractPsiBasedNode<? extends KtDeclaration>> members2;
        Collection<AbstractPsiBasedNode<? extends KtDeclaration>> collection;
        if (!this.getSettings().isShowMembers()) {
            return this.nestedFileNodes;
        }
        PsiElement psiElement = this.extractPsiFromValue();
        KtFile ktFile2 = psiElement instanceof KtFile ? (KtFile)psiElement : null;
        if (ktFile2 != null) {
            ViewSettings viewSettings = this.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"getSettings(...)");
            collection = KtFileTreeNodeKt.toDeclarationsNodes(ktFile2, viewSettings);
        } else {
            collection = null;
        }
        Collection<AbstractPsiBasedNode<? extends KtDeclaration>> collection2 = members2 = collection;
        return collection2 == null || collection2.isEmpty() ? this.nestedFileNodes : (Collection)CollectionsKt.plus(this.nestedFileNodes, (Iterable)members2);
    }

    public boolean canRepresent(@Nullable Object element) {
        if (super.canRepresent(element)) {
            return true;
        }
        PsiElement value = this.extractPsiFromValue();
        PsiElement psiElement = element instanceof PsiElement ? (PsiElement)element : null;
        VirtualFile elementVirtualFile = psiElement != null && (psiElement = psiElement.getNavigationElement()) != null && (psiElement = psiElement.getContainingFile()) != null ? psiElement.getVirtualFile() : null;
        PsiElement psiElement2 = value;
        VirtualFile virtualFile = psiElement2 != null && (psiElement2 = psiElement2.getContainingFile()) != null ? psiElement2.getVirtualFile() : null;
        return Intrinsics.areEqual((Object)elementVirtualFile, (Object)virtualFile);
    }

    protected void updateImpl(@NotNull PresentationData data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KtLightClass ktLightClass = (KtLightClass)this.getValue();
            if (ktLightClass == null) break block0;
            KtLightClass it = ktLightClass;
            boolean bl = false;
            data.setPresentableText(it.getName());
        }
    }

    private static final boolean navigatablePsiElement_delegate$lambda$5$lambda$1(SmartList $filesFromFacade, FqName $originalPackageName, KtAnnotationEntry it) {
        block1: {
            KtFile ktFile2;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNull((Object)it);
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)it;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFileAnnotationList.class, (boolean)true) == null) break block1;
            KtFile ktFile3 = ktFile2 = it.getContainingKtFile();
            boolean bl = false;
            Object object = Intrinsics.areEqual((Object)ktFile3.getPackageFqName(), (Object)$originalPackageName) ? ktFile2 : null;
            if (object != null) {
                KtFile p0 = object;
                boolean bl2 = false;
                $filesFromFacade.add((Object)p0);
            }
        }
        return true;
    }

    private static final boolean navigatablePsiElement_delegate$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final SmartPsiElementPointer navigatablePsiElement_delegate$lambda$5(KtInternalFileTreeNode this$0) {
        SmartPsiElementPointer smartPsiElementPointer;
        KtFile file;
        KtFile ktFile2;
        KtLightClass ktLightClass = (KtLightClass)this$0.getValue();
        Object object = ktLightClass != null ? ktLightClass.getNavigationElement() : null;
        KtClsFile ktClsFile = object instanceof KtClsFile ? (KtClsFile)object : null;
        KtClsFile ktClsFile2 = ktClsFile;
        if (ktClsFile2 == null || (ktClsFile2 = ktClsFile2.getContainingFile()) == null || (ktClsFile2 = ktClsFile2.getVirtualFile()) == null) {
            return null;
        }
        KtClsFile virtualFile = ktClsFile2;
        Project prj = this$0.getProject();
        String string = virtualFile.getNameWithoutExtension();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
        String baseName = string;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)prj);
        Intrinsics.checkNotNull((Object)prj);
        List<GlobalSearchScope> scopes = LibrarySourceScopeService.Companion.getInstance(prj).targetClassFilesToSourcesScopes((VirtualFile)virtualFile, prj);
        if (scopes.isEmpty()) {
            return null;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((Collection)scopes);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"union(...)");
        GlobalSearchScope scope = globalSearchScope;
        FqName originalPackageName = ktClsFile.getPackageFqName();
        SmartList filesFromFacade = new SmartList();
        KotlinJvmNameAnnotationIndex.Helper.processElements(StringsKt.substringBefore$default((String)baseName, (String)"__", null, (int)2, null), prj, scope, arg_0 -> KtInternalFileTreeNode.navigatablePsiElement_delegate$lambda$5$lambda$2(arg_0 -> KtInternalFileTreeNode.navigatablePsiElement_delegate$lambda$5$lambda$1(filesFromFacade, originalPackageName, arg_0), arg_0));
        String partShortName = StringsKt.substringAfter$default((String)baseName, (String)"__", null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)baseName, (CharSequence)"__", (boolean)false, (int)2, null)) {
            Iterator iterator = filesFromFacade.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                KtFile ktFile3 = (KtFile)e;
                if (!JvmFileClassUtilKt.isJvmMultifileClassFile((KtFile)ktFile3)) continue;
                String string2 = ktFile3.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!Intrinsics.areEqual((Object)PackagePartClassUtils.getFilePartShortName((String)string2), (Object)partShortName)) continue;
                return smartPointerManager.createSmartPsiElementPointer((PsiElement)ktFile3);
            }
        }
        if ((ktFile2 = (KtFile)CollectionsKt.singleOrNull((List)((List)filesFromFacade))) == null) {
            KtInternalFileTreeNode $this$navigatablePsiElement_delegate_u24lambda_u245_u24lambda_u243 = this$0;
            boolean bl = false;
            Name name2 = Name.identifier((String)baseName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            FqName fqName2 = originalPackageName.child(name2);
            ktFile2 = (KtFile)CollectionsKt.singleOrNull((Iterable)KotlinFileFacadeFqNameIndex.Helper.get(fqName2.asString(), prj, scope));
        }
        KtFile ktFile4 = file = ktFile2;
        if (ktFile4 != null) {
            KtElement p0 = (KtElement)ktFile4;
            boolean bl = false;
            smartPsiElementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)p0);
        } else {
            smartPsiElementPointer = null;
        }
        return smartPsiElementPointer;
    }
}

