/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J<\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\n0\t0\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\t2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KotlinSelectInProjectViewProvider;", "Lcom/intellij/ide/projectView/SelectableTreeStructureProvider;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modify", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "", "parent", "children", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "getTopLevelElement", "Lcom/intellij/psi/PsiElement;", "element", "isSelectable", "", "fileInRoots", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.base.project-structure"})
@SourceDebugExtension(value={"SMAP\nprojectViewProviders.kt\nKotlin\n*S Kotlin\n*F\n+ 1 projectViewProviders.kt\norg/jetbrains/kotlin/idea/projectView/KotlinSelectInProjectViewProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,123:1\n183#2,2:124\n*S KotlinDebug\n*F\n+ 1 projectViewProviders.kt\norg/jetbrains/kotlin/idea/projectView/KotlinSelectInProjectViewProvider\n*L\n91#1:124,2\n*E\n"})
public final class KotlinSelectInProjectViewProvider
implements SelectableTreeStructureProvider,
DumbAware {
    @NotNull
    private final Project project;

    public KotlinSelectInProjectViewProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public Collection<AbstractTreeNode<? extends Object>> modify(@NotNull AbstractTreeNode<?> parent2, @NotNull Collection<? extends AbstractTreeNode<?>> children, @NotNull ViewSettings settings2) {
        Intrinsics.checkNotNullParameter(parent2, (String)"parent");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        return new ArrayList(children);
    }

    @Nullable
    public PsiElement getTopLevelElement(@NotNull PsiElement element) {
        PsiElement psiElement;
        Object v1;
        VirtualFile virtualFile;
        KtFile file;
        block8: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!element.isValid()) {
                return null;
            }
            PsiFile psiFile = element.getContainingFile();
            KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
            if (ktFile2 == null) {
                return null;
            }
            file = ktFile2;
            virtualFile = file.getVirtualFile();
            if (!this.fileInRoots(virtualFile)) {
                return (PsiElement)file;
            }
            Sequence $this$firstOrNull$iv = PsiUtilsKt.getParentsWithSelf((PsiElement)element);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!this.isSelectable(it)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        PsiElement current = v1;
        if (current instanceof KtFile) {
            KtDeclaration declaration = (KtDeclaration)CollectionsKt.singleOrNull((List)((KtFile)current).getDeclarations());
            Object object = virtualFile;
            if (object == null || (object = object.getNameWithoutExtension()) == null) {
                String string = file.getName();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            }
            Object nameWithoutExtension = object;
            if (declaration instanceof KtClassOrObject && Intrinsics.areEqual((Object)nameWithoutExtension, (Object)((KtClassOrObject)declaration).getName())) {
                current = (PsiElement)declaration;
            }
        }
        if ((psiElement = current) == null) {
            psiElement = (PsiElement)file;
        }
        return psiElement;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSelectable(PsiElement $this$isSelectable) {
        PsiElement psiElement = $this$isSelectable;
        if (psiElement instanceof KtFile) {
            return true;
        }
        if (!(psiElement instanceof KtDeclaration)) return false;
        if (((KtDeclaration)$this$isSelectable).getParent() instanceof KtFile) return true;
        PsiElement psiElement2 = ((KtDeclaration)$this$isSelectable).getParent();
        KtClassBody ktClassBody = psiElement2 instanceof KtClassBody ? (KtClassBody)psiElement2 : null;
        PsiElement psiElement3 = ktClassBody != null ? ktClassBody.getParent() : null;
        if (!(psiElement3 instanceof KtClassOrObject)) return false;
        KtClassOrObject ktClassOrObject = (KtClassOrObject)psiElement3;
        if (ktClassOrObject == null) return false;
        boolean bl = this.isSelectable((PsiElement)ktClassOrObject);
        if (!bl) return false;
        return true;
    }

    private final boolean fileInRoots(VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex index2 = projectFileIndex;
        return file != null && (index2.isInSourceContent(file) || index2.isInLibraryClasses(file) || index2.isInLibrarySource(file));
    }
}

