/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinPluginLayout;
import org.jetbrains.kotlin.idea.inspections.PluginVersionDependentInspection;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@WX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DifferentKotlinMavenVersionInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lorg/jetbrains/kotlin/idea/inspections/PluginVersionDependentInspection;", "<init>", "()V", "idePluginVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "getIdePluginVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "idePluginVersion$delegate", "Lkotlin/Lazy;", "value", "", "testVersionMessage", "getTestVersionMessage", "()Ljava/lang/String;", "setTestVersionMessage", "(Ljava/lang/String;)V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "createProblem", "plugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "kotlin.maven"})
public final class DifferentKotlinMavenVersionInspection
extends DomElementsInspection<MavenDomProjectModel>
implements PluginVersionDependentInspection {
    @NotNull
    private final Lazy idePluginVersion$delegate = LazyKt.lazy(DifferentKotlinMavenVersionInspection::idePluginVersion_delegate$lambda$0);
    @Nullable
    private String testVersionMessage;

    public DifferentKotlinMavenVersionInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    private final LanguageVersion getIdePluginVersion() {
        Lazy lazy = this.idePluginVersion$delegate;
        return (LanguageVersion)lazy.getValue();
    }

    @Override
    @Nullable
    public String getTestVersionMessage() {
        return this.testVersionMessage;
    }

    @Override
    @TestOnly
    public void setTestVersionMessage(@Nullable String string) {
        this.testVersionMessage = string;
    }

    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Module module = domFileElement.getModule();
        if (module == null || (module = module.getProject()) == null) {
            return;
        }
        Module project = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager mavenManager = mavenProjectsManager;
        if (!mavenManager.isMavenizedProject() || !mavenManager.isManagedFile(domFileElement.getFile().getVirtualFile())) {
            return;
        }
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        PomFile pomFile = PomFile.Companion.forFileOrNull(xmlFile);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        for (MavenDomPlugin plugin : pomFile2.findKotlinPlugins()) {
            Object mavenPluginVersion;
            IdeKotlinVersion ideKotlinVersion;
            if (!plugin.getVersion().exists()) continue;
            String string = plugin.getVersion().getStringValue();
            if (string == null || (ideKotlinVersion = (IdeKotlinVersion)(Result.isFailure-impl((Object)(mavenPluginVersion = IdeKotlinVersion.Companion.parse-IoAF18A(string))) ? null : mavenPluginVersion)) == null || (ideKotlinVersion = ideKotlinVersion.getLanguageVersion()) == null) continue;
            IdeKotlinVersion mavenPluginLanguageVersion = ideKotlinVersion;
            if (this.getIdePluginVersion().compareTo((Enum)((Object)mavenPluginLanguageVersion)) >= 0 && mavenPluginLanguageVersion.compareTo((Enum)LanguageVersion.FIRST_SUPPORTED) >= 0) continue;
            Intrinsics.checkNotNull((Object)plugin);
            this.createProblem(holder2, plugin);
        }
    }

    private final void createProblem(DomElementAnnotationHolder holder2, MavenDomPlugin plugin) {
        String versionFromMaven = plugin.getVersion().getStringValue();
        String string = this.getTestVersionMessage();
        if (string == null) {
            string = this.getIdePluginVersion();
        }
        String versionFromIde = string;
        Object[] objectArray = new Object[]{String.valueOf(versionFromMaven), versionFromIde};
        holder2.createProblem((DomElement)plugin.getVersion(), HighlightSeverity.WARNING, KotlinMavenBundle.message("version.different.maven.ide", objectArray));
    }

    private static final LanguageVersion idePluginVersion_delegate$lambda$0() {
        return KotlinPluginLayout.getIdeCompilerVersion().getLanguageVersion();
    }
}

