/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.ListResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.liveTemplates.macro.KotlinMacro;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J%\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/liveTemplates/macro/FunctionParametersMacro;", "Lorg/jetbrains/kotlin/idea/liveTemplates/macro/KotlinMacro;", "<init>", "()V", "getName", "", "getPresentableName", "calculateResult", "Lcom/intellij/codeInsight/template/Result;", "params", "", "Lcom/intellij/codeInsight/template/Expression;", "context", "Lcom/intellij/codeInsight/template/ExpressionContext;", "([Lcom/intellij/codeInsight/template/Expression;Lcom/intellij/codeInsight/template/ExpressionContext;)Lcom/intellij/codeInsight/template/Result;", "kotlin.code-insight.live-templates.shared"})
public final class FunctionParametersMacro
extends KotlinMacro {
    @NotNull
    public String getName() {
        return "functionParameters";
    }

    @NotNull
    public String getPresentableName() {
        return "functionParameters()";
    }

    @Nullable
    public Result calculateResult(@NotNull Expression[] params, @NotNull ExpressionContext context) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Project project = context.getProject();
        int templateStartOffset = context.getTemplateStartOffset();
        int offset = templateStartOffset > 0 ? context.getTemplateStartOffset() - 1 : context.getTemplateStartOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        Editor editor = context.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        PsiFile psiFile = psiDocumentManager.getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        for (PsiElement place = file.findElementAt(offset); place != null; place = place.getParent()) {
            if (!(place instanceof KtFunction)) continue;
            ArrayList<TextResult> result2 = new ArrayList<TextResult>();
            for (KtParameter param : ((KtFunction)place).getValueParameters()) {
                String string = param.getName();
                Intrinsics.checkNotNull((Object)string);
                result2.add(new TextResult(string));
            }
            return (Result)new ListResult((List)result2);
        }
        return null;
    }
}

