/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtClassOrObjectKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00142\u00020\u0001:\u0007\u000e\u000f\u0010\u0011\u0012\u0013\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH'R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0002\u0015\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getOrCreateTarget", "Lcom/intellij/psi/PsiElement;", "dirStructureMatchesPkg", "", "Directory", "Declaration", "File", "ClassBody", "CompanionObject", "ClassOrObject", "Companion", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "kotlin.refactorings.move.k2"})
public interface K2MoveTargetDescriptor {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveTargetDescriptor$Companion.$$INSTANCE;

    @NotNull
    public PsiDirectory getBaseDirectory();

    @NotNull
    public FqName getPkgName();

    @RequiresWriteLock
    @NotNull
    public PsiElement getOrCreateTarget(boolean var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$ClassBody;", "T", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration;", "targetClass", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)V", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "addElement", "Lcom/intellij/psi/PsiElement;", "target", "element", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "kotlin.refactorings.move.k2"})
    public static abstract class ClassBody<T extends KtClassOrObject>
    implements Declaration<T> {
        @NotNull
        private final PsiDirectory baseDirectory;
        @NotNull
        private final FqName pkgName;

        public ClassBody(@NotNull KtClassOrObject targetClass) {
            Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
            PsiDirectory psiDirectory = targetClass.getContainingKtFile().getContainingDirectory();
            Intrinsics.checkNotNull((Object)psiDirectory);
            this.baseDirectory = psiDirectory;
            this.pkgName = targetClass.getContainingKtFile().getPackageFqName();
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        @NotNull
        public FqName getPkgName() {
            return this.pkgName;
        }

        @Override
        @NotNull
        public PsiElement addElement(@NotNull T target, @NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return Companion.addElementToClassBody(target, element);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$ClassOrObject;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$ClassBody;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classOrObject", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;)V", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getTargetType", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration$DeclarationTargetType;", "getTarget", "getOrCreateTarget", "dirStructureMatchesPkg", "", "kotlin.refactorings.move.k2"})
    public static final class ClassOrObject
    extends ClassBody<KtClassOrObject> {
        @NotNull
        private final KtClassOrObject classOrObject;
        @NotNull
        private final PsiDirectory baseDirectory;
        @NotNull
        private final FqName pkgName;

        public ClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            super(classOrObject);
            this.classOrObject = classOrObject;
            PsiDirectory psiDirectory = this.classOrObject.getContainingKtFile().getContainingDirectory();
            Intrinsics.checkNotNull((Object)psiDirectory);
            this.baseDirectory = psiDirectory;
            this.pkgName = this.classOrObject.getContainingKtFile().getPackageFqName();
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        @NotNull
        public FqName getPkgName() {
            return this.pkgName;
        }

        @Override
        @NotNull
        public Declaration.DeclarationTargetType getTargetType() {
            if (this.classOrObject instanceof KtObjectDeclaration) {
                if (((KtObjectDeclaration)this.classOrObject).isCompanion()) {
                    return Declaration.DeclarationTargetType.COMPANION_OBJECT;
                }
                return Declaration.DeclarationTargetType.OBJECT;
            }
            return Declaration.DeclarationTargetType.CLASS;
        }

        @Override
        @Nullable
        public KtClassOrObject getTarget() {
            return this.classOrObject;
        }

        @Override
        @NotNull
        public KtClassOrObject getOrCreateTarget(boolean dirStructureMatchesPkg) {
            return this.classOrObject;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\rH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Companion;", "", "<init>", "()V", "Directory", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "directory", "Lcom/intellij/psi/PsiDirectory;", "File", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "addElementToClassBody", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "element", "kotlin.refactorings.move.k2"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final Directory Directory(@NotNull PsiDirectory directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return new Directory(PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot(directory), directory);
        }

        @NotNull
        public final File File(@NotNull KtFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory == null) {
                throw new IllegalStateException("No containing directory was found".toString());
            }
            PsiDirectory directory = psiDirectory;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return new File(string, file.getPackageFqName(), directory);
        }

        private final PsiElement addElementToClassBody(KtClassOrObject $this$addElementToClassBody, PsiElement element) {
            PsiElement psiElement;
            PsiElement anchor;
            KtClassBody body2 = KtClassOrObjectKt.getOrCreateBody((KtClassOrObject)$this$addElementToClassBody);
            PsiElement psiElement2 = body2.getRBrace();
            if (psiElement2 == null) {
                PsiElement psiElement3 = body2.getLastChild();
                psiElement2 = psiElement3;
                Intrinsics.checkNotNull((Object)psiElement3);
            }
            PsiElement psiElement4 = anchor = psiElement2.getPrevSibling();
            if ((psiElement4 != null ? psiElement4.getNextSibling() : null) instanceof PsiErrorElement) {
                PsiElement psiElement5 = body2.addBefore(element, anchor);
                Intrinsics.checkNotNull((Object)psiElement5);
                psiElement = psiElement5;
            } else {
                PsiElement psiElement6 = body2.addAfter(element, anchor);
                Intrinsics.checkNotNull((Object)psiElement6);
                psiElement = psiElement6;
            }
            return psiElement;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$CompanionObject;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$ClassBody;", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "containingClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClass;)V", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getTargetType", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration$DeclarationTargetType;", "getOrCreateTarget", "dirStructureMatchesPkg", "", "getTarget", "kotlin.refactorings.move.k2"})
    @SourceDebugExtension(value={"SMAP\nK2MoveTargetDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveTargetDescriptor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$CompanionObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
    public static final class CompanionObject
    extends ClassBody<KtObjectDeclaration> {
        @NotNull
        private final KtClass containingClass;
        @NotNull
        private final PsiDirectory baseDirectory;
        @NotNull
        private final FqName pkgName;

        public CompanionObject(@NotNull KtClass containingClass) {
            Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
            super((KtClassOrObject)containingClass);
            this.containingClass = containingClass;
            PsiDirectory psiDirectory = this.containingClass.getContainingKtFile().getContainingDirectory();
            Intrinsics.checkNotNull((Object)psiDirectory);
            this.baseDirectory = psiDirectory;
            this.pkgName = this.containingClass.getContainingKtFile().getPackageFqName();
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        @NotNull
        public FqName getPkgName() {
            return this.pkgName;
        }

        @Override
        @NotNull
        public Declaration.DeclarationTargetType getTargetType() {
            return Declaration.DeclarationTargetType.COMPANION_OBJECT;
        }

        @Override
        @NotNull
        public KtObjectDeclaration getOrCreateTarget(boolean dirStructureMatchesPkg) {
            KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)CollectionsKt.firstOrNull((List)this.containingClass.getCompanionObjects());
            if (ktObjectDeclaration != null) {
                KtObjectDeclaration it = ktObjectDeclaration;
                boolean bl = false;
                return it;
            }
            return KotlinPsiModificationUtils.getOrCreateCompanionObject(this.containingClass);
        }

        @Override
        @Nullable
        public KtObjectDeclaration getTarget() {
            return (KtObjectDeclaration)CollectionsKt.firstOrNull((List)this.containingClass.getCompanionObjects());
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0016J\u0015\u0010\u0004\u001a\u00028\u00002\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\b\u001a\u0004\u0018\u00018\u0000H&\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000bH&\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H&J*\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u0082\u0001\u0002\u0017\u0018\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0019\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration;", "T", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "getOrCreateTarget", "dirStructureMatchesPkg", "", "(Z)Lorg/jetbrains/kotlin/psi/KtElement;", "getTarget", "()Lorg/jetbrains/kotlin/psi/KtElement;", "addElement", "Lcom/intellij/psi/PsiElement;", "target", "element", "(Lorg/jetbrains/kotlin/psi/KtElement;Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "getTargetType", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration$DeclarationTargetType;", "addElementsToTarget", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "elements", "", "DeclarationTargetType", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$ClassBody;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "kotlin.refactorings.move.k2"})
    @SourceDebugExtension(value={"SMAP\nK2MoveTargetDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 K2MoveTargetDescriptor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1863#2,2:180\n*S KotlinDebug\n*F\n+ 1 K2MoveTargetDescriptor.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration\n*L\n74#1:180,2\n*E\n"})
    public static interface Declaration<T extends KtElement>
    extends K2MoveTargetDescriptor {
        @NotNull
        public T getOrCreateTarget(boolean var1);

        @Nullable
        public T getTarget();

        @NotNull
        public PsiElement addElement(@NotNull T var1, @NotNull PsiElement var2);

        @NotNull
        public DeclarationTargetType getTargetType();

        @NotNull
        default public Map<KtNamedDeclaration, KtNamedDeclaration> addElementsToTarget(@NotNull Collection<? extends PsiElement> elements, boolean dirStructureMatchesPkg) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            T target = this.getOrCreateTarget(dirStructureMatchesPkg);
            Map oldToNewMap = new LinkedHashMap();
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiElement oldElement = (PsiElement)element$iv;
                boolean bl = false;
                PsiElement movedElement = this.addElement(target, oldElement);
                if (!(movedElement instanceof KtNamedDeclaration)) continue;
                for (Pair pair : CollectionsKt.zip((Iterable)MoveUtilKt.withChildDeclarations(oldElement), (Iterable)MoveUtilKt.withChildDeclarations(movedElement))) {
                    KtNamedDeclaration oldChild = (KtNamedDeclaration)pair.component1();
                    KtNamedDeclaration newChild = (KtNamedDeclaration)pair.component2();
                    oldToNewMap.put(oldChild, newChild);
                }
            }
            return oldToNewMap;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration$DeclarationTargetType;", "", "<init>", "(Ljava/lang/String;I)V", "CLASS", "OBJECT", "COMPANION_OBJECT", "FILE", "kotlin.refactorings.move.k2"})
        public static final class DeclarationTargetType
        extends Enum<DeclarationTargetType> {
            public static final /* enum */ DeclarationTargetType CLASS = new DeclarationTargetType();
            public static final /* enum */ DeclarationTargetType OBJECT = new DeclarationTargetType();
            public static final /* enum */ DeclarationTargetType COMPANION_OBJECT = new DeclarationTargetType();
            public static final /* enum */ DeclarationTargetType FILE = new DeclarationTargetType();
            private static final /* synthetic */ DeclarationTargetType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static DeclarationTargetType[] values() {
                return (DeclarationTargetType[])$VALUES.clone();
            }

            public static DeclarationTargetType valueOf(String value) {
                return Enum.valueOf(DeclarationTargetType.class, value);
            }

            @NotNull
            public static EnumEntries<DeclarationTargetType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = declarationTargetTypeArray = new DeclarationTargetType[]{DeclarationTargetType.CLASS, DeclarationTargetType.OBJECT, DeclarationTargetType.COMPANION_OBJECT, DeclarationTargetType.FILE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor;", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiDirectory;)V", "getPkgName", "()Lorg/jetbrains/kotlin/name/FqName;", "getBaseDirectory", "()Lcom/intellij/psi/PsiDirectory;", "getOrCreateTarget", "Lcom/intellij/psi/PsiFileSystemItem;", "dirStructureMatchesPkg", "", "kotlin.refactorings.move.k2"})
    public static class Directory
    implements K2MoveTargetDescriptor {
        @NotNull
        private final FqName pkgName;
        @NotNull
        private final PsiDirectory baseDirectory;

        public Directory(@NotNull FqName pkgName, @NotNull PsiDirectory baseDirectory) {
            Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
            Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
            this.pkgName = pkgName;
            this.baseDirectory = baseDirectory;
        }

        @Override
        @NotNull
        public FqName getPkgName() {
            return this.pkgName;
        }

        @Override
        @NotNull
        public PsiDirectory getBaseDirectory() {
            return this.baseDirectory;
        }

        @NotNull
        public PsiFileSystemItem getOrCreateTarget(boolean dirStructureMatchesPkg) {
            VirtualFile file;
            if (!dirStructureMatchesPkg) {
                return (PsiFileSystemItem)this.getBaseDirectory();
            }
            FqName implicitPkgPrefix = PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot(this.getBaseDirectory());
            String pkgSuffix = StringsKt.removePrefix((String)StringsKt.removePrefix((String)this.getPkgName().asString(), (CharSequence)implicitPkgPrefix.asString()), (CharSequence)".");
            VirtualFile virtualFile = file = VfsUtilCore.findRelativeFile((String)StringsKt.replace$default((String)pkgSuffix, (char)'.', (char)java.io.File.separatorChar, (boolean)false, (int)4, null), (VirtualFile)this.getBaseDirectory().getVirtualFile());
            if (virtualFile != null) {
                Project project = this.getBaseDirectory().getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                PsiDirectory psiDirectory = PhysicalFileSystemUtilsKt.toPsiDirectory(virtualFile, project);
                if (psiDirectory == null) {
                    throw new IllegalStateException(("Could not find directory " + this.getPkgName()).toString());
                }
                return (PsiFileSystemItem)psiDirectory;
            }
            PsiDirectory psiDirectory = DirectoryUtil.createSubdirectories((String)pkgSuffix, (PsiDirectory)this.getBaseDirectory(), (String)".");
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"createSubdirectories(...)");
            return (PsiFileSystemItem)psiDirectory;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$File;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Directory;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration;", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "", "pkgName", "Lorg/jetbrains/kotlin/name/FqName;", "baseDirectory", "Lcom/intellij/psi/PsiDirectory;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/kotlin/name/FqName;Lcom/intellij/psi/PsiDirectory;)V", "getFileName", "()Ljava/lang/String;", "getOrCreateTarget", "dirStructureMatchesPkg", "", "getTarget", "addElement", "Lcom/intellij/psi/PsiElement;", "target", "element", "getTargetType", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveTargetDescriptor$Declaration$DeclarationTargetType;", "kotlin.refactorings.move.k2"})
    public static final class File
    extends Directory
    implements Declaration<KtFile> {
        @NotNull
        private final String fileName;

        public File(@NotNull String fileName, @NotNull FqName pkgName, @NotNull PsiDirectory baseDirectory) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
            Intrinsics.checkNotNullParameter((Object)baseDirectory, (String)"baseDirectory");
            super(pkgName, baseDirectory);
            this.fileName = fileName;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @Override
        @NotNull
        public KtFile getOrCreateTarget(boolean dirStructureMatchesPkg) {
            PsiFileSystemItem psiFileSystemItem = super.getOrCreateTarget(dirStructureMatchesPkg);
            Intrinsics.checkNotNull((Object)psiFileSystemItem, (String)"null cannot be cast to non-null type com.intellij.psi.PsiDirectory");
            PsiDirectory directory = (PsiDirectory)psiFileSystemItem;
            return MoveUtilKt.getOrCreateKotlinFile(this.fileName, directory, this.getPkgName().asString());
        }

        @Override
        @Nullable
        public KtFile getTarget() {
            PsiFile psiFile = this.getBaseDirectory().findFile(this.fileName);
            return psiFile instanceof KtFile ? (KtFile)psiFile : null;
        }

        @Override
        @NotNull
        public PsiElement addElement(@NotNull KtFile target, @NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = target.add(element);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"add(...)");
            return psiElement;
        }

        @Override
        @NotNull
        public Declaration.DeclarationTargetType getTargetType() {
            return Declaration.DeclarationTargetType.FILE;
        }
    }
}

