/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.components.KaTypeCreator;
import org.jetbrains.kotlin.analysis.api.components.KaTypeRelationChecker;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbolKt;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaErrorType;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ExplicitApiMode;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.base.psi.TextRangeUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.ControlFlowUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.RemoveExplicitTypeUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.TypeParameterUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001b\u0010\f\u001a\u0004\u0018\u00010\u0003*\u00020\r2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u00020\r\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u000b*\u00020\u0002H\u0002R\u00020\r\u00a2\u0006\u0002\u0010\u0014J!\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\r\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\r\u00a2\u0006\u0002\u0010\u001eJ!\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u00020\r\u00a2\u0006\u0002\u0010\"J\u0019\u0010#\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020%H\u0002R\u00020\r\u00a2\u0006\u0002\u0010&J\b\u0010)\u001a\u00020*H\u0016J-\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000200H\u0014\u00a2\u0006\u0002\u00101R\u0018\u0010'\u001a\u00020\u000b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveExplicitTypeIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "", "<init>", "()V", "getApplicableRanges", "", "Lcom/intellij/openapi/util/TextRange;", "element", "isApplicableByPsi", "", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Lkotlin/Unit;", "publicReturnTypeShouldBePresentInApiMode", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;)Z", "isExplicitTypeReferenceNeededForTypeInferenceByAnalyze", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "isInitializerTypeContextIndependent", "initializer", "Lorg/jetbrains/kotlin/psi/KtExpression;", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "isLambdaExpressionTypeContextIndependent", "lambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtLambdaExpression;Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "isAnonymousFunctionTypeContextIndependent", "anonymousFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "isCallableReferenceExpressionTypeContextIndependent", "callableReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;)Z", "isVar", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;)Z", "getFamilyName", "", "invoke", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "kotlin.code-insight.intentions.k2"})
@SourceDebugExtension(value={"SMAP\nRemoveExplicitTypeIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveExplicitTypeIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveExplicitTypeIntention\n+ 2 ContextProvider.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicable/ContextProviderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n45#2:183\n1#3:184\n1734#4,3:185\n1734#4,3:188\n*S KotlinDebug\n*F\n+ 1 RemoveExplicitTypeIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/RemoveExplicitTypeIntention\n*L\n53#1:183\n125#1:185,3\n163#1:188,3\n*E\n"})
public final class RemoveExplicitTypeIntention
extends KotlinApplicableModCommandAction<KtDeclaration, Unit> {
    public RemoveExplicitTypeIntention() {
        super(Reflection.getOrCreateKotlinClass(KtDeclaration.class));
    }

    @Override
    @NotNull
    public List<TextRange> getApplicableRanges(@NotNull KtDeclaration element) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtTypeReference ktTypeReference = ControlFlowUtilsKt.getTypeReference(element);
        if (ktTypeReference == null) {
            return CollectionsKt.emptyList();
        }
        KtTypeReference typeReference = ktTypeReference;
        if (element instanceof KtParameter && KotlinPsiUtilsKt.isSetterParameter((KtParameter)element)) {
            textRange = TextRangeUtilsKt.textRangeIn((PsiElement)typeReference, (PsiElement)element);
        } else {
            int typeReferenceRelativeEndOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)typeReference)) - PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
            textRange = new TextRange(0, typeReferenceRelativeEndOffset);
        }
        TextRange textRange2 = textRange;
        return CollectionsKt.listOf((Object)textRange2);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return ControlFlowUtilsKt.canExplicitTypeBeRemoved(element);
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtDeclaration element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $this$asUnit$iv = element instanceof KtParameter ? true : (element instanceof KtNamedFunction && ((KtNamedFunction)element).hasBlockBody() ? $this$prepareContext.isUnitType($this$prepareContext.getReturnType(element)) : (element instanceof KtNamedFunction && ControlFlowUtilsKt.isRecursive((KtNamedFunction)element) ? false : (element instanceof KtCallableDeclaration && this.publicReturnTypeShouldBePresentInApiMode($this$prepareContext, (KtCallableDeclaration)element) ? false : !this.isExplicitTypeReferenceNeededForTypeInferenceByAnalyze($this$prepareContext, element))));
        boolean $i$f$getAsUnit = false;
        return $this$asUnit$iv ? Unit.INSTANCE : null;
    }

    private final boolean publicReturnTypeShouldBePresentInApiMode(KaSession $context_receiver_0, KtCallableDeclaration declaration) {
        if (LanguageVersionSettingsProviderUtils.getLanguageVersionSettings((PsiElement)declaration).getFlag(AnalysisFlags.getExplicitApiMode()) == ExplicitApiMode.DISABLED) {
            return false;
        }
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)declaration));
        boolean bl = ktClassOrObject != null ? ktClassOrObject.isLocal() : false;
        if (bl) {
            return false;
        }
        if (declaration instanceof KtFunction && ((KtFunction)declaration).isLocal()) {
            return false;
        }
        if (declaration instanceof KtProperty && ((KtProperty)declaration).isLocal()) {
            return false;
        }
        return $context_receiver_0.isPublicApi($context_receiver_0.getSymbol((KtDeclaration)declaration));
    }

    private final boolean isExplicitTypeReferenceNeededForTypeInferenceByAnalyze(KaSession $context_receiver_0, KtDeclaration $this$isExplicitTypeReferenceNeededForTypeInferenceByAnalyze) {
        KtTypeReference ktTypeReference = ControlFlowUtilsKt.getTypeReference($this$isExplicitTypeReferenceNeededForTypeInferenceByAnalyze);
        if (ktTypeReference == null) {
            return false;
        }
        KtTypeReference typeReference = ktTypeReference;
        KtExpression ktExpression = ControlFlowUtilsKt.getInitializerOrGetterInitializer($this$isExplicitTypeReferenceNeededForTypeInferenceByAnalyze);
        if (ktExpression == null) {
            return true;
        }
        KtExpression initializer2 = ktExpression;
        KaType explicitType = $context_receiver_0.getReturnType($this$isExplicitTypeReferenceNeededForTypeInferenceByAnalyze);
        if (explicitType instanceof KaErrorType) {
            return false;
        }
        if (!this.isInitializerTypeContextIndependent($context_receiver_0, initializer2, typeReference)) {
            return true;
        }
        KaType kaType = $context_receiver_0.getExpressionType(initializer2);
        if (kaType == null) {
            return true;
        }
        KaType initializerType = kaType;
        boolean typeCanBeRemoved = this.isVar($this$isExplicitTypeReferenceNeededForTypeInferenceByAnalyze) ? KaTypeRelationChecker.semanticallyEquals$default($context_receiver_0, initializerType, explicitType, null, 2, null) : KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$context_receiver_0, initializerType, explicitType, null, 2, null);
        return !typeCanBeRemoved;
    }

    private final boolean isInitializerTypeContextIndependent(KaSession $context_receiver_0, KtExpression initializer2, KtTypeReference typeReference) {
        boolean bl;
        block32: {
            KtExpression ktExpression = initializer2;
            if (ktExpression instanceof KtStringTemplateExpression) {
                bl = true;
            } else if (ktExpression instanceof KtConstantExpression) {
                KaType kaType;
                ClassId classId;
                ClassId classId2 = classId = KtPsiUtilKt.inferClassIdByPsi((KtConstantExpression)((KtConstantExpression)initializer2));
                if (classId2 != null) {
                    ClassId it = classId2;
                    boolean bl2 = false;
                    kaType = KaTypeCreator.buildClassType$default((KaTypeCreator)$context_receiver_0, it, null, 2, null);
                } else {
                    kaType = null;
                }
                KaType let = kaType;
                KaType superType = $context_receiver_0.getType(typeReference);
                Boolean subTypeOf = let != null ? Boolean.valueOf(KaTypeRelationChecker.isSubtypeOf$default((KaTypeRelationChecker)$context_receiver_0, let, superType, null, 2, null)) : null;
                bl = Intrinsics.areEqual(subTypeOf, (Object)true);
            } else if (ktExpression instanceof KtCallExpression) {
                bl = ((KtCallExpression)initializer2).getTypeArgumentList() != null || !TypeParameterUtils.INSTANCE.returnTypeOfCallDependsOnTypeParameters($context_receiver_0, (KtElement)initializer2);
            } else if (ktExpression instanceof KtArrayAccessExpression) {
                bl = !TypeParameterUtils.INSTANCE.returnTypeOfCallDependsOnTypeParameters($context_receiver_0, (KtElement)initializer2);
            } else if (ktExpression instanceof KtCallableReferenceExpression) {
                bl = this.isCallableReferenceExpressionTypeContextIndependent($context_receiver_0, (KtCallableReferenceExpression)initializer2);
            } else if (ktExpression instanceof KtQualifiedExpression) {
                KtExpression superType = initializer2;
                KtDotQualifiedExpression ktDotQualifiedExpression = superType instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)superType : null;
                if (ktDotQualifiedExpression == null || (ktDotQualifiedExpression = ktDotQualifiedExpression.getSelectorExpression()) == null) {
                    ktDotQualifiedExpression = (KtExpression)KotlinPsiUtilsKt.getCallExpression((KtQualifiedExpression)initializer2);
                }
                if (ktDotQualifiedExpression != null) {
                    KtDotQualifiedExpression it = ktDotQualifiedExpression;
                    boolean bl3 = false;
                    bl = this.isInitializerTypeContextIndependent($context_receiver_0, (KtExpression)it, typeReference);
                } else {
                    bl = false;
                }
            } else if (ktExpression instanceof KtLambdaExpression) {
                bl = this.isLambdaExpressionTypeContextIndependent($context_receiver_0, (KtLambdaExpression)initializer2, typeReference);
            } else if (ktExpression instanceof KtNamedFunction) {
                bl = this.isAnonymousFunctionTypeContextIndependent($context_receiver_0, (KtNamedFunction)initializer2, typeReference);
            } else if (ktExpression instanceof KtSimpleNameExpression || ktExpression instanceof KtBinaryExpression) {
                bl = true;
            } else if (ktExpression instanceof KtIfExpression) {
                KaType elseType;
                KaType type2 = $context_receiver_0.getType(typeReference);
                KtExpression ktExpression2 = ((KtIfExpression)initializer2).getThen();
                KaType thenType = ktExpression2 != null ? $context_receiver_0.getExpressionType(ktExpression2) : null;
                KtExpression ktExpression3 = ((KtIfExpression)initializer2).getElse();
                KaType kaType = elseType = ktExpression3 != null ? $context_receiver_0.getExpressionType(ktExpression3) : null;
                bl = thenType != null && elseType != null && KaTypeRelationChecker.semanticallyEquals$default($context_receiver_0, type2, thenType, null, 2, null) && KaTypeRelationChecker.semanticallyEquals$default($context_receiver_0, type2, elseType, null, 2, null);
            } else if (ktExpression instanceof KtWhenExpression) {
                KaType type3 = $context_receiver_0.getType(typeReference);
                List list2 = ((KtWhenExpression)initializer2).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean bl4;
                        KtWhenEntry it = (KtWhenEntry)element$iv;
                        boolean bl5 = false;
                        Object object = it.getExpression();
                        if (object == null || (object = $context_receiver_0.getExpressionType((KtExpression)object)) == null) {
                            bl4 = false;
                        } else {
                            Object expressionType = object;
                            bl4 = KaTypeRelationChecker.semanticallyEquals$default($context_receiver_0, (KaType)expressionType, type3, null, 2, null);
                        }
                        if (bl4) continue;
                        bl = false;
                        break block32;
                    }
                    bl = true;
                }
            } else {
                bl = $context_receiver_0.evaluate(initializer2) != null;
            }
        }
        return bl;
    }

    private final boolean isLambdaExpressionTypeContextIndependent(KaSession $context_receiver_0, KtLambdaExpression lambdaExpression, KtTypeReference typeReference) {
        Object object = lambdaExpression.getBodyExpression();
        if (object == null || (object = object.getStatements()) == null || (object = (KtExpression)CollectionsKt.lastOrNull((List)object)) == null) {
            return false;
        }
        Object lastStatement = object;
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        KtFunctionType ktFunctionType = ktTypeElement instanceof KtFunctionType ? (KtFunctionType)ktTypeElement : null;
        if (ktFunctionType == null || (ktFunctionType = ktFunctionType.getReturnTypeReference()) == null) {
            return false;
        }
        KtFunctionType returnTypeReference = ktFunctionType;
        return this.isInitializerTypeContextIndependent($context_receiver_0, (KtExpression)lastStatement, (KtTypeReference)returnTypeReference);
    }

    private final boolean isAnonymousFunctionTypeContextIndependent(KaSession $context_receiver_0, KtNamedFunction anonymousFunction, KtTypeReference typeReference) {
        boolean bl;
        if (anonymousFunction.hasDeclaredReturnType() || anonymousFunction.hasBlockBody()) {
            return true;
        }
        KtTypeElement ktTypeElement = typeReference.getTypeElement();
        KtFunctionType ktFunctionType = ktTypeElement instanceof KtFunctionType ? (KtFunctionType)ktTypeElement : null;
        if (ktFunctionType == null || (ktFunctionType = ktFunctionType.getReturnTypeReference()) == null) {
            return false;
        }
        KtFunctionType returnTypeReference = ktFunctionType;
        KtExpression ktExpression = anonymousFunction.getInitializer();
        if (ktExpression != null) {
            KtExpression it = ktExpression;
            boolean bl2 = false;
            bl = this.isInitializerTypeContextIndependent($context_receiver_0, it, (KtTypeReference)returnTypeReference);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCallableReferenceExpressionTypeContextIndependent(KaSession $context_receiver_0, KtCallableReferenceExpression callableReferenceExpression) {
        boolean bl;
        block10: {
            PsiElement psiElement;
            block9: {
                PsiReference[] psiReferenceArray = callableReferenceExpression.getCallableReference().getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                Object[] objectArray = psiReferenceArray;
                int n = objectArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiReference it = (PsiReference)objectArray[j];
                    boolean bl2 = false;
                    psiElement = it.resolve();
                    if (psiElement == null) {
                        continue;
                    }
                    break block9;
                }
                psiElement = null;
            }
            if (psiElement == null) {
                return false;
            }
            PsiElement resolved = psiElement;
            if (!(resolved instanceof KtNamedFunction)) {
                return true;
            }
            KaFunctionSymbol symbol = $context_receiver_0.getSymbol((KtNamedFunction)resolved);
            List<KaTypeParameterSymbol> typeParameters2 = KaDeclarationSymbolKt.getTypeParameters(symbol);
            if (typeParameters2.isEmpty()) {
                return true;
            }
            KaType kaType = KaCallableSymbolKt.getReceiverType(symbol);
            if (kaType == null) {
                return false;
            }
            KaType receiverType = kaType;
            Iterable $this$all$iv = typeParameters2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KaTypeParameterSymbol it = (KaTypeParameterSymbol)element$iv;
                    boolean bl3 = false;
                    if (TypeParameterUtils.INSTANCE.typeReferencesTypeParameter($context_receiver_0, it, receiverType)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isVar(KtDeclaration $this$isVar) {
        KtProperty property;
        Object object = $this$isVar instanceof KtProperty ? (KtProperty)$this$isVar : null;
        if (object == null) {
            KtPropertyAccessor ktPropertyAccessor = $this$isVar instanceof KtPropertyAccessor ? (KtPropertyAccessor)$this$isVar : null;
            object = ktPropertyAccessor != null ? ktPropertyAccessor.getProperty() : null;
        }
        KtProperty ktProperty = property = object;
        return ktProperty != null ? ktProperty.isVar() : false;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"remove.explicit.type.specification", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull ActionContext actionContext, @NotNull KtDeclaration element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        RemoveExplicitTypeUtilsKt.removeDeclarationTypeReference(element);
    }
}

