/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinApplicableInspectionBase;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.inspections.KotlinModCommandQuickFix;
import org.jetbrains.kotlin.idea.codeinsight.utils.ControlFlowUtilsKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.RemoveExplicitTypeArgumentsUtils;
import org.jetbrains.kotlin.idea.k2.refactoring.util.RedundantExplicitTypeArgumentsUtilKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u0003*\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u0010J3\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000bH\u0014\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u001b0\u001a2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u001b2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RemoveExplicitTypeArgumentsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinApplicableInspectionBase;", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "", "<init>", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isApplicableByPsi", "element", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;)Lkotlin/Unit;", "createProblemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Lcom/intellij/codeInspection/InspectionManager;", "context", "rangeInElement", "Lcom/intellij/openapi/util/TextRange;", "onTheFly", "(Lcom/intellij/codeInspection/InspectionManager;Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;Lkotlin/Unit;Lcom/intellij/openapi/util/TextRange;Z)Lcom/intellij/codeInspection/ProblemDescriptor;", "createQuickFixes", "", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/inspections/KotlinModCommandQuickFix;", "createRemoveExplicitTypeArgumentsFix", "createRemoveExplicitTypeFix", "kotlin.code-insight.inspections.k2"})
@SourceDebugExtension(value={"SMAP\nRemoveExplicitTypeArgumentsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveExplicitTypeArgumentsInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RemoveExplicitTypeArgumentsInspection\n+ 2 ContextProvider.kt\norg/jetbrains/kotlin/idea/codeinsight/api/applicable/ContextProviderKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,91:1\n45#2:92\n37#3:93\n36#3,3:94\n213#4:97\n*S KotlinDebug\n*F\n+ 1 RemoveExplicitTypeArgumentsInspection.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/RemoveExplicitTypeArgumentsInspection\n*L\n38#1:92\n51#1:93\n51#1:94,3\n73#1:97\n*E\n"})
public final class RemoveExplicitTypeArgumentsInspection
extends KotlinApplicableInspectionBase<KtTypeArgumentList, Unit> {
    @Override
    @NotNull
    public KtVisitor<?, ?> buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (KtVisitor)new KtVisitorVoid(this, holder2, isOnTheFly){
            final /* synthetic */ RemoveExplicitTypeArgumentsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            public void visitTypeArgumentList(KtTypeArgumentList typeArgumentList) {
                Intrinsics.checkNotNullParameter((Object)typeArgumentList, (String)"typeArgumentList");
                RemoveExplicitTypeArgumentsInspection.access$visitTargetElement(this.this$0, typeArgumentList, this.$holder, this.$isOnTheFly);
            }
        };
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtTypeArgumentList element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        KtCallExpression ktCallExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        if (ktCallExpression == null) {
            return false;
        }
        KtCallExpression callExpression = ktCallExpression;
        return RemoveExplicitTypeArgumentsUtils.INSTANCE.isApplicableByPsi(callExpression);
    }

    @Override
    @Nullable
    public Unit prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtTypeArgumentList element) {
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean $this$asUnit$iv = RedundantExplicitTypeArgumentsUtilKt.areTypeArgumentsRedundant$default($this$prepareContext, element, false, 2, null);
        boolean $i$f$getAsUnit = false;
        return $this$asUnit$iv ? Unit.INSTANCE : null;
    }

    @Override
    @NotNull
    protected ProblemDescriptor createProblemDescriptor(@NotNull InspectionManager $this$createProblemDescriptor, @NotNull KtTypeArgumentList element, @NotNull Unit context, @Nullable TextRange rangeInElement, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)$this$createProblemDescriptor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Collection<KotlinModCommandQuickFix<KtTypeArgumentList>> $this$toTypedArray$iv = this.createQuickFixes(element);
        boolean $i$f$toTypedArray = false;
        Collection<KotlinModCommandQuickFix<KtTypeArgumentList>> thisCollection$iv = $this$toTypedArray$iv;
        KotlinModCommandQuickFix[] kotlinModCommandQuickFixArray = thisCollection$iv.toArray(new KotlinModCommandQuickFix[0]);
        ProblemDescriptor problemDescriptor = $this$createProblemDescriptor.createProblemDescriptor((PsiElement)element, rangeInElement, KotlinBundle.message((String)"explicit.type.arguments.can.be.inferred", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly, (LocalQuickFix[])Arrays.copyOf(kotlinModCommandQuickFixArray, kotlinModCommandQuickFixArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        return problemDescriptor;
    }

    private final Collection<KotlinModCommandQuickFix<KtTypeArgumentList>> createQuickFixes(KtTypeArgumentList element) {
        KotlinModCommandQuickFix[] kotlinModCommandQuickFixArray = new KotlinModCommandQuickFix[]{this.createRemoveExplicitTypeArgumentsFix(), this.createRemoveExplicitTypeFix(element)};
        return CollectionsKt.listOfNotNull((Object[])kotlinModCommandQuickFixArray);
    }

    private final KotlinModCommandQuickFix<KtTypeArgumentList> createRemoveExplicitTypeArgumentsFix() {
        return new KotlinModCommandQuickFix<KtTypeArgumentList>(){

            public String getFamilyName() {
                return KotlinBundle.message((String)"remove.explicit.type.arguments", (Object[])new Object[0]);
            }

            protected void applyFix(Project project, KtTypeArgumentList element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                RemoveExplicitTypeArgumentsUtils.INSTANCE.applyTo(element);
            }
        };
    }

    private final KotlinModCommandQuickFix<KtTypeArgumentList> createRemoveExplicitTypeFix(KtTypeArgumentList element) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
        boolean $i$f$getStrictParentOfType = false;
        KtCallableDeclaration declaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
        Object object = declaration;
        if (object == null || (object = object.getName()) == null) {
            return null;
        }
        Object declarationName = object;
        if (!ControlFlowUtilsKt.canExplicitTypeBeRemoved((KtDeclaration)declaration)) {
            return null;
        }
        return new KotlinModCommandQuickFix<KtTypeArgumentList>((String)declarationName){
            final /* synthetic */ String $declarationName;
            {
                this.$declarationName = $declarationName;
            }

            public String getFamilyName() {
                Object[] objectArray = new Object[]{this.$declarationName};
                return KotlinBundle.message((String)"remove.explicit.type.specification.from.0", (Object[])objectArray);
            }

            protected void applyFix(Project project, KtTypeArgumentList element, ModPsiUpdater updater2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)element;
                boolean $i$f$getStrictParentOfType = false;
                KtCallableDeclaration ktCallableDeclaration = (KtCallableDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallableDeclaration.class, (boolean)true);
                if (ktCallableDeclaration == null) {
                    return;
                }
                KtCallableDeclaration declaration = ktCallableDeclaration;
                declaration.setTypeReference(null);
            }
        };
    }

    public static final /* synthetic */ void access$visitTargetElement(RemoveExplicitTypeArgumentsInspection $this, KtTypeArgumentList element, ProblemsHolder holder2, boolean isOnTheFly) {
        $this.visitTargetElement((KtElement)element, holder2, isOnTheFly);
    }
}

