/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.core.overrideImplement.BodyType;
import org.jetbrains.kotlin.idea.core.overrideImplement.KtClassMember;
import org.jetbrains.kotlin.idea.core.overrideImplement.KtClassMemberInfo;
import org.jetbrains.kotlin.idea.core.overrideImplement.KtClassMemberKt;
import org.jetbrains.kotlin.idea.core.overrideImplement.KtImplementMembersHandler;
import org.jetbrains.kotlin.idea.core.util.KotlinIdeaCoreBundle;
import org.jetbrains.kotlin.psi.KtClassOrObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0014J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/inspections/KtDelegateJavaDefaultMethodsQuickFix;", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtImplementMembersHandler;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "members", "", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtClassMemberInfo;", "bodyType", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/BodyType;", "<init>", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/idea/core/overrideImplement/BodyType;)V", "getFamilyName", "", "getText", "startInWriteAction", "", "getChooserTitle", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "collectMembersToGenerate", "Lorg/jetbrains/kotlin/idea/core/overrideImplement/KtClassMember;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "kotlin.code-insight.inspections.k2"})
@SourceDebugExtension(value={"SMAP\nKtDelegateJavaDefaultMethodsQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtDelegateJavaDefaultMethodsQuickFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/KtDelegateJavaDefaultMethodsQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,45:1\n1557#2:46\n1628#2,3:47\n*S KotlinDebug\n*F\n+ 1 KtDelegateJavaDefaultMethodsQuickFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/inspections/KtDelegateJavaDefaultMethodsQuickFix\n*L\n37#1:46\n37#1:47,3\n*E\n"})
public final class KtDelegateJavaDefaultMethodsQuickFix
extends KtImplementMembersHandler
implements IntentionAction {
    @NotNull
    private final Collection<KtClassMemberInfo> members;
    @NotNull
    private final BodyType bodyType;

    public KtDelegateJavaDefaultMethodsQuickFix(@NotNull Collection<KtClassMemberInfo> members2, @NotNull BodyType bodyType) {
        Intrinsics.checkNotNullParameter(members2, (String)"members");
        Intrinsics.checkNotNullParameter((Object)bodyType, (String)"bodyType");
        this.members = members2;
        this.bodyType = bodyType;
    }

    @NotNull
    public String getFamilyName() {
        String string;
        BodyType bodyType = this.bodyType;
        if (bodyType instanceof BodyType.Delegate) {
            string = KotlinBundle.message((String)"override.java.default.methods.delegate.fix.text", (Object[])new Object[0]);
        } else if (bodyType instanceof BodyType.Super) {
            string = KotlinBundle.message((String)"override.java.default.methods.superclass.fix.text", (Object[])new Object[0]);
        } else {
            UtilKt.getLOG().error("Unexpected body type: " + this.bodyType);
            string = "";
        }
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    protected String getChooserTitle() {
        return KotlinIdeaCoreBundle.message("override.members.handler.title", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        BodyType bodyType = this.bodyType;
        return bodyType instanceof BodyType.Delegate || Intrinsics.areEqual((Object)bodyType, (Object)BodyType.Super.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<KtClassMember> collectMembersToGenerate(@NotNull KtClassOrObject classOrObject) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        Iterable $this$map$iv = this.members;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtClassMemberInfo ktClassMemberInfo = (KtClassMemberInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(KtClassMemberKt.createKtClassMember((KtClassMemberInfo)it, this.bodyType, false));
        }
        return (List)destination$iv$iv;
    }
}

