/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.fixes;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.PrimitiveLiteralData;
import org.jetbrains.kotlin.idea.k2.codeinsight.fixes.WrongPrimitiveLiteralFixKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0002H\u0014J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/WrongPrimitiveLiteralFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "primitiveLiteral", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/PrimitiveLiteralData;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/PrimitiveLiteralData;)V", "getFamilyName", "", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "Companion", "kotlin.code-insight.fixes.k2"})
@SourceDebugExtension(value={"SMAP\nWrongPrimitiveLiteralFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongPrimitiveLiteralFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/WrongPrimitiveLiteralFix\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n*L\n1#1,124:1\n29#2,7:125\n*S KotlinDebug\n*F\n+ 1 WrongPrimitiveLiteralFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/WrongPrimitiveLiteralFix\n*L\n121#1:125,7\n*E\n"})
public final class WrongPrimitiveLiteralFix
extends PsiUpdateModCommandAction<KtExpression> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrimitiveLiteralData primitiveLiteral;

    private WrongPrimitiveLiteralFix(KtExpression element, PrimitiveLiteralData primitiveLiteral) {
        super((PsiElement)element);
        this.primitiveLiteral = primitiveLiteral;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"change.to.correct.primitive.type", (Object[])new Object[0]);
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull KtExpression element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new Object[]{this.primitiveLiteral.getFixedExpression()};
        Presentation presentation = Presentation.of((String)KotlinBundle.message((String)"change.to.0", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"of(...)");
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull KtExpression element, @NotNull ModPsiUpdater updater2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        Project project = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        KtExpression expressionToInsert = new KtPsiFactory(project, false, 2, null).createExpression(this.primitiveLiteral.getFixedExpression());
        PsiElement $this$replaced$iv = (PsiElement)element;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)expressionToInsert))) {
            psiElement = (PsiElement)expressionToInsert;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
            if (result$iv instanceof KtExpression) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement = (PsiElement)ktExpression;
            }
        }
        PsiElement newExpression = GenericPsiUtils.reformatted(psiElement, true);
        updater2.moveCaretTo(PsiUtilsKt.getEndOffset((PsiElement)newExpression));
    }

    public /* synthetic */ WrongPrimitiveLiteralFix(KtExpression element, PrimitiveLiteralData primitiveLiteral, DefaultConstructorMarker $constructor_marker) {
        this(element, primitiveLiteral);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/WrongPrimitiveLiteralFix$Companion;", "", "<init>", "()V", "createIfAvailable", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/fixes/WrongPrimitiveLiteralFix;", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "createIfAvailable$kotlin_code_insight_fixes_k2", "kotlin.code-insight.fixes.k2"})
    @SourceDebugExtension(value={"SMAP\nWrongPrimitiveLiteralFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongPrimitiveLiteralFix.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/fixes/WrongPrimitiveLiteralFix$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final WrongPrimitiveLiteralFix createIfAvailable$kotlin_code_insight_fixes_k2(@NotNull KtExpression element, @NotNull KaType type2, @NotNull KaSession analysisSession) {
            PrimitiveLiteralData primitiveLiteral;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
            KaSession $this$createIfAvailable_u24lambda_u240 = analysisSession;
            boolean bl = false;
            PrimitiveLiteralData $this$createIfAvailable_u24lambda_u241 = primitiveLiteral = WrongPrimitiveLiteralFixKt.access$preparePrimitiveLiteral($this$createIfAvailable_u24lambda_u240, element, type2);
            boolean bl2 = false;
            if ($this$createIfAvailable_u24lambda_u241.getConstValue() == null) {
                return null;
            }
            Long l = WrongPrimitiveLiteralFixKt.access$toLong($this$createIfAvailable_u24lambda_u241.getConstValue());
            if (l == null) {
                return null;
            }
            long longValue = l;
            if ($this$createIfAvailable_u24lambda_u241.getExpectedTypeIsFloat() || $this$createIfAvailable_u24lambda_u241.getExpectedTypeIsDouble() || $this$createIfAvailable_u24lambda_u241.getExpectedTypeIsUnsigned()) {
                return new WrongPrimitiveLiteralFix(element, primitiveLiteral, null);
            }
            if ($this$createIfAvailable_u24lambda_u241.getConstValue() instanceof Float || $this$createIfAvailable_u24lambda_u241.getConstValue() instanceof Double) {
                double value;
                Object object = $this$createIfAvailable_u24lambda_u241.getConstValue();
                Float f = object instanceof Float ? (Float)object : null;
                if (f != null) {
                    v2 = f.floatValue();
                } else {
                    Object object2 = $this$createIfAvailable_u24lambda_u241.getConstValue();
                    Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Double");
                    v2 = value = ((Double)object2).doubleValue();
                }
                if (!(value == Math.floor(value))) {
                    return null;
                }
                if (!(-9.223372036854776E18 <= value ? value <= 9.223372036854776E18 : false)) {
                    return null;
                }
            }
            LongRange longRange = (LongRange)WrongPrimitiveLiteralFixKt.access$getValueRanges$p().get($this$createIfAvailable_u24lambda_u241.getTypeName());
            return !(longRange != null ? longRange.contains(longValue) : false) ? null : new WrongPrimitiveLiteralFix(element, primitiveLiteral, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

