/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal.makeBackup;

import com.intellij.compiler.server.BuildManager;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.io.ZipUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J.\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPatches", "backupDir", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "createPatch", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "file", "Ljava/nio/file/Path;", "isReverse", "", "copyLogs", "copyProjectSystemDir", "zipProjectDir", "projectDir", "Companion", "kotlin.jvm"})
@SourceDebugExtension(value={"SMAP\nCreateIncrementalCompilationBackup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateIncrementalCompilationBackup.kt\norg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1557#2:209\n1628#2,3:210\n*S KotlinDebug\n*F\n+ 1 CreateIncrementalCompilationBackup.kt\norg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup\n*L\n99#1:209\n99#1:210,3\n*E\n"})
final class CreateIncrementalCompilationBackup
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String BACKUP_DIR_NAME = ".backup";
    public static final int PATCHES_TO_CREATE = 5;
    public static final double PATCHES_FRACTION = 0.25;
    public static final double LOGS_FRACTION = 0.05;
    public static final double PROJECT_SYSTEM_FRACTION = 0.05;
    public static final double ZIP_FRACTION = 0.6499999999999999;

    public CreateIncrementalCompilationBackup() {
        super(KotlinJvmBundle.message("create.backup.for.debugging.kotlin.incremental.compilation", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        VirtualFile virtualFile = project2.getBaseDir();
        Intrinsics.checkNotNull((Object)virtualFile);
        File projectBaseDir = new File(virtualFile.getPath());
        File backupDir = new File(FileUtil.createTempDirectory((String)"makeBackup", null), BACKUP_DIR_NAME);
        String string = KotlinJvmBundle.message("creating.backup.for.debugging.kotlin.incremental.compilation", new Object[0]);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, this, backupDir, projectBaseDir, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ CreateIncrementalCompilationBackup this$0;
            final /* synthetic */ File $backupDir;
            final /* synthetic */ File $projectBaseDir;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$backupDir = $backupDir;
                this.$projectBaseDir = $projectBaseDir;
                super($project, $super_call_param$1, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CreateIncrementalCompilationBackup.access$createPatches(this.this$0, this.$backupDir, this.$project, indicator);
                CreateIncrementalCompilationBackup.access$copyLogs(this.this$0, this.$backupDir, indicator);
                CreateIncrementalCompilationBackup.access$copyProjectSystemDir(this.this$0, this.$backupDir, this.$project, indicator);
                CreateIncrementalCompilationBackup.access$zipProjectDir(this.this$0, this.$backupDir, this.$project, this.$projectBaseDir, indicator);
            }
        });
    }

    private final void createPatches(File backupDir, Project project, ProgressIndicator indicator) {
        ActionsKt.runReadAction(() -> CreateIncrementalCompilationBackup.createPatches$lambda$1(project, backupDir, indicator, this));
    }

    private final void createPatch(Project project, List<? extends Change> changes, Path file, boolean isReverse) throws IOException, VcsException {
        Path path2 = ProjectKt.getStateStore((Project)project).getProjectBasePath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getProjectBasePath(...)");
        Path basePath = path2;
        List list2 = IdeaTextPatchBuilder.buildPatch((Project)project, (Collection)changes, (Path)basePath, (boolean)isReverse, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"buildPatch(...)");
        List patches = list2;
        PatchWriter.writePatches((Project)project, (Path)file, (Path)basePath, (List)patches, null);
    }

    private final void copyLogs(File backupDir, ProgressIndicator indicator) {
        indicator.setText(KotlinJvmBundle.message("copying.logs", new Object[0]));
        indicator.setFraction(0.25);
        File logsDir = new File(backupDir, "logs");
        FileUtil.copyDir((File)new File(PathManager.getLogPath()), (File)logsDir);
        indicator.setFraction(0.3);
    }

    private final void copyProjectSystemDir(File backupDir, Project project, ProgressIndicator indicator) {
        indicator.setText(KotlinJvmBundle.message("copying.project.s.system.dir", new Object[0]));
        indicator.setFraction(0.25);
        File projectSystemDir = new File(backupDir, "project-system");
        FileUtil.copyDir((File)BuildManager.getInstance().getProjectSystemDirectory(project), (File)projectSystemDir);
        indicator.setFraction(0.35);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zipProjectDir(File backupDir, Project project, File projectDir, ProgressIndicator indicator) {
        ArrayList files = new ArrayList();
        Ref.LongRef totalBytes = new Ref.LongRef();
        Object[] objectArray = new File[2];
        objectArray[0] = projectDir;
        Intrinsics.checkNotNull((Object)backupDir.getParentFile());
        for (File dir : CollectionsKt.listOf((Object[])objectArray)) {
            FileUtil.processFilesRecursively((File)dir, arg_0 -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$3(arg_0 -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$2(indicator, files, dir, totalBytes, arg_0), arg_0), arg_0 -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$5(CreateIncrementalCompilationBackup::zipProjectDir$lambda$4, arg_0));
        }
        File backupFile = new File(projectDir, "make_backup_" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + ".zip");
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupFile));
        long processedBytes = 0L;
        Closeable closeable = zos;
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            boolean bl = false;
            Iterator iterator = files.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                Pair pair = (Pair)e;
                File file = (File)pair.component1();
                String relativePath = (String)pair.component2();
                Object[] objectArray2 = new Object[]{relativePath};
                indicator.setText(KotlinJvmBundle.message("adding.file.to.backup.0", objectArray2));
                indicator.setFraction(0.3 + (double)processedBytes / (double)totalBytes.element * 0.6499999999999999);
                ZipUtil.addFileToZip((ZipOutputStream)zos, (File)file, (String)relativePath, null, null);
                processedBytes += file.length();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        FileUtil.delete((File)backupDir);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> CreateIncrementalCompilationBackup.zipProjectDir$lambda$7(backupFile, project), null, (Project)project);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createPatches$lambda$1(Project $project, File $backupDir, ProgressIndicator $indicator, CreateIncrementalCompilationBackup this$0) {
        LocalHistoryImpl localHistoryImpl = LocalHistoryImpl.Companion.getInstanceImpl();
        Intrinsics.checkNotNull((Object)localHistoryImpl);
        LocalHistoryImpl localHistoryImpl2 = localHistoryImpl;
        IdeaGateway gateway = localHistoryImpl2.getGateway();
        LocalHistoryFacade localHistoryFacade = localHistoryImpl2.getFacade();
        RootEntry rootEntry = gateway.createTransientRootEntry();
        VirtualFile virtualFile = $project.getBaseDir();
        Intrinsics.checkNotNull((Object)virtualFile);
        List list2 = RevisionsCollector.collect((LocalHistoryFacade)localHistoryFacade, (RootEntry)rootEntry, (String)virtualFile.getPath(), (String)$project.getLocationHash());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"collect(...)");
        List revisions = list2;
        int patchesCreated = 0;
        File patchesDir = new File($backupDir, "patches");
        patchesDir.mkdirs();
        for (Revision rev : revisions) {
            void $this$mapTo$iv$iv;
            List differences;
            String label2 = rev.getLabel();
            if (label2 == null || !StringsKt.startsWith$default((String)label2, (String)"build started ", (boolean)false, (int)2, null)) continue;
            File patchFile = new File(patchesDir, StringsKt.removePrefix((String)label2, (CharSequence)"build started ") + ".patch");
            Object[] objectArray = new Object[]{patchFile};
            $indicator.setText(KotlinJvmBundle.message("creating.patch.0", objectArray));
            $indicator.setFraction(0.25 * (double)patchesCreated / (double)5);
            Revision revision = (Revision)revisions.get(0);
            Revision revision2 = rev;
            Intrinsics.checkNotNull((Object)revision2);
            Intrinsics.checkNotNull((Object)Revision.getDifferencesBetween((Revision)revision, (Revision)revision2));
            Iterable $this$map$iv = differences;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void d;
                Difference difference = (Difference)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Change(d.getLeftContentRevision(gateway), d.getRightContentRevision(gateway)));
            }
            List changes = (List)destination$iv$iv;
            Path path2 = patchFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            this$0.createPatch($project, changes, path2, false);
            if (++patchesCreated < 5) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final boolean zipProjectDir$lambda$2(ProgressIndicator $indicator, ArrayList $files, File $dir, Ref.LongRef $totalBytes, File it) {
        block2: {
            block3: {
                File file = it;
                Intrinsics.checkNotNull((Object)file);
                if (!file.isFile()) break block2;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)".hprof", (boolean)false, (int)2, null)) break block2;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"make_backup_", (boolean)false, (int)2, null)) break block3;
                String string3 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string3, (String)".zip", (boolean)false, (int)2, null)) break block2;
            }
            Object[] objectArray = new Object[]{it};
            $indicator.setText(KotlinJvmBundle.message("scanning.project.dir.0", objectArray));
            String string = FileUtil.getRelativePath((File)$dir, (File)it);
            Intrinsics.checkNotNull((Object)string);
            $files.add(new Pair((Object)it, (Object)string));
            $totalBytes.element += it.length();
        }
        return true;
    }

    private static final boolean zipProjectDir$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean zipProjectDir$lambda$4(File it) {
        File file = it;
        Intrinsics.checkNotNull((Object)file);
        String name2 = file.getName();
        return !Intrinsics.areEqual((Object)name2, (Object)".git") && !Intrinsics.areEqual((Object)name2, (Object)"out");
    }

    private static final boolean zipProjectDir$lambda$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void zipProjectDir$lambda$7(File $backupFile, Project $project) {
        Object[] objectArray = new Object[]{$backupFile.getAbsolutePath()};
        OkCancelDialogBuilder okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(KotlinJvmBundle.message("created.backup", new Object[0]), KotlinJvmBundle.message("successfully.created.backup.0", objectArray));
        String string = RevealFileAction.getActionName(null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionName(...)");
        OkCancelDialogBuilder okCancelDialogBuilder2 = (OkCancelDialogBuilder)okCancelDialogBuilder.yesText(string);
        String string2 = IdeBundle.message((String)"action.close", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        boolean confirmed = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)okCancelDialogBuilder2.noText(string2)).icon(Messages.getInformationIcon())).ask($project);
        if (confirmed) {
            RevealFileAction.openFile((File)$backupFile);
        }
    }

    public static final /* synthetic */ void access$createPatches(CreateIncrementalCompilationBackup $this, File backupDir, Project project, ProgressIndicator indicator) {
        $this.createPatches(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$copyLogs(CreateIncrementalCompilationBackup $this, File backupDir, ProgressIndicator indicator) {
        $this.copyLogs(backupDir, indicator);
    }

    public static final /* synthetic */ void access$copyProjectSystemDir(CreateIncrementalCompilationBackup $this, File backupDir, Project project, ProgressIndicator indicator) {
        $this.copyProjectSystemDir(backupDir, project, indicator);
    }

    public static final /* synthetic */ void access$zipProjectDir(CreateIncrementalCompilationBackup $this, File backupDir, Project project, File projectDir, ProgressIndicator indicator) {
        $this.zipProjectDir(backupDir, project, projectDir, indicator);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/internal/makeBackup/CreateIncrementalCompilationBackup$Companion;", "", "<init>", "()V", "BACKUP_DIR_NAME", "", "PATCHES_TO_CREATE", "", "PATCHES_FRACTION", "", "LOGS_FRACTION", "PROJECT_SYSTEM_FRACTION", "ZIP_FRACTION", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

