/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.idea.util.CommentSaver;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/EliminateWhenSubjectIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nEliminateWhenSubjectIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EliminateWhenSubjectIntention.kt\norg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/EliminateWhenSubjectIntention\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,60:1\n11158#2:61\n11493#2,3:62\n*S KotlinDebug\n*F\n+ 1 EliminateWhenSubjectIntention.kt\norg/jetbrains/kotlin/idea/intentions/branchedTransformations/intentions/EliminateWhenSubjectIntention\n*L\n45#1:61\n45#1:62,3\n*E\n"})
public final class EliminateWhenSubjectIntention
extends SelfTargetingIntention<KtWhenExpression>
implements LowPriorityAction {
    public EliminateWhenSubjectIntention() {
        super(KtWhenExpression.class, KotlinBundle.lazyMessage((String)"inline.when.argument", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtWhenExpression element, int caretOffset) {
        KtWhenEntry lastEntry;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element.getSubjectExpression() instanceof KtNameReferenceExpression)) {
            return false;
        }
        PsiElement psiElement = element.getOpenBrace();
        if (psiElement == null) {
            return false;
        }
        PsiElement lBrace = psiElement;
        if (caretOffset > PsiUtilsKt.getStartOffset((PsiElement)lBrace)) {
            return false;
        }
        List list2 = element.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
        KtWhenEntry ktWhenEntry = lastEntry = (KtWhenEntry)CollectionsKt.lastOrNull((List)list2);
        return (ktWhenEntry != null ? ktWhenEntry.isElse() : false) || !BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)element), (BindingContext)ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL_WITH_CFA));
    }

    @Override
    public void applyTo(@NotNull KtWhenExpression element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getSubjectExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression subject = ktExpression;
        CommentSaver commentSaver = new CommentSaver((PsiElement)element, true);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtExpression whenExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> EliminateWhenSubjectIntention.applyTo$lambda$1(element, subject, arg_0), (int)1, null);
        PsiElement result2 = element.replace((PsiElement)whenExpression);
        CommentSaver.restore$default(commentSaver, result2, false, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit applyTo$lambda$1(KtWhenExpression $element, KtExpression $subject, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        $this$buildExpression.appendFixedText("when {\n");
        for (KtWhenEntry entry : $element.getEntries()) {
            KtExpression branchExpression = entry.getExpression();
            if (entry.isElse()) {
                v0 = $this$buildExpression.appendFixedText("else");
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
                Object[] objectArray = ktWhenConditionArray;
                BuilderByPattern builderByPattern = $this$buildExpression;
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtWhenCondition ktWhenCondition = (KtWhenCondition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(BranchedTransformationUtilsKt.toExpression$default((KtWhenCondition)it, $subject, null, 2, null));
                }
                v0 = builderByPattern.appendExpressions((Iterable)((List)destination$iv$iv), "||");
            }
            $this$buildExpression.appendFixedText("->");
            $this$buildExpression.appendExpression(branchExpression);
            $this$buildExpression.appendFixedText("\n");
        }
        $this$buildExpression.appendFixedText("}");
        return Unit.INSTANCE;
    }
}

