/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.ToOrdinaryStringLiteralIntentionKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0016\u0010\r\u001a\u00020\u000e*\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0007H\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u000eH\u0002J%\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ToOrdinaryStringLiteralIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "isApplicableTo", "", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "escape", "", "escapeLineSeparators", "getTrimIndentCall", "Lorg/jetbrains/kotlin/idea/intentions/ToOrdinaryStringLiteralIntention$TrimIndentCall;", "entries", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;[Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;)Lorg/jetbrains/kotlin/idea/intentions/ToOrdinaryStringLiteralIntention$TrimIndentCall;", "TrimIndentCall", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nToOrdinaryStringLiteralIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToOrdinaryStringLiteralIntention.kt\norg/jetbrains/kotlin/idea/intentions/ToOrdinaryStringLiteralIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n29#2,7:106\n1#3:113\n*S KotlinDebug\n*F\n+ 1 ToOrdinaryStringLiteralIntention.kt\norg/jetbrains/kotlin/idea/intentions/ToOrdinaryStringLiteralIntention\n*L\n47#1:106,7\n*E\n"})
public final class ToOrdinaryStringLiteralIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    public ToOrdinaryStringLiteralIntention() {
        super(KtStringTemplateExpression.class, KotlinBundle.lazyMessage((String)"convert.to.ordinary.string.literal", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.startsWith$default((String)string, (String)"\"\"\"", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element, @Nullable Editor editor) {
        block5: {
            int offset;
            PsiElement psiElement;
            void $this$replaced$iv;
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            int startOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element));
            int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element));
            Editor editor2 = editor;
            int currentOffset = editor2 != null && (editor2 = editor2.getCaretModel()) != null && (editor2 = editor2.getCurrentCaret()) != null ? editor2.getOffset() : startOffset;
            Object[] entries = element.getEntries();
            Intrinsics.checkNotNull((Object)entries);
            TrimIndentCall trimIndentCall = this.getTrimIndentCall(element, (KtStringTemplateEntry[])entries);
            StringBuilder $this$applyTo_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$applyTo_u24lambda_u241.append("\"");
            StringBuilder stringBuilder2 = trimIndentCall != null ? $this$applyTo_u24lambda_u241.append(trimIndentCall.getStringTemplateText()) : (StringBuilder)ArraysKt.joinTo$default((Object[])entries, (Appendable)$this$applyTo_u24lambda_u241, (CharSequence)"", null, null, (int)0, null, arg_0 -> ToOrdinaryStringLiteralIntention.applyTo$lambda$1$lambda$0(this, arg_0), (int)60, null);
            $this$applyTo_u24lambda_u241.append("\"");
            String text = stringBuilder.toString();
            TrimIndentCall trimIndentCall2 = trimIndentCall;
            $this$applyTo_u24lambda_u241 = (PsiElement)(trimIndentCall2 != null && (trimIndentCall2 = trimIndentCall2.getQualifiedExpression()) != null ? (KtExpression)trimIndentCall2 : (KtExpression)element);
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            PsiElement newElement$iv = (PsiElement)new KtPsiFactory(project, false, 2, null).createExpression(text);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression;
                }
            }
            KtExpression replaced = (KtExpression)psiElement;
            int n = offset = currentOffset - startOffset < 2 ? startOffset : (endOffset - currentOffset < 2 ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)replaced)) : Math.max(currentOffset - 2, PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)replaced))));
            Editor editor3 = editor;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block5;
            editor3.moveToOffset(offset);
        }
    }

    private final String escape(String $this$escape, boolean escapeLineSeparators) {
        String text = $this$escape;
        text = StringsKt.replace$default((String)text, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
        text = StringsKt.replace$default((String)text, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        return escapeLineSeparators ? this.escapeLineSeparators(text) : text;
    }

    static /* synthetic */ String escape$default(ToOrdinaryStringLiteralIntention toOrdinaryStringLiteralIntention, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return toOrdinaryStringLiteralIntention.escape(string, bl);
    }

    private final String escapeLineSeparators(String $this$escapeLineSeparators) {
        String string = StringUtil.convertLineSeparators((String)$this$escapeLineSeparators, (String)"\\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TrimIndentCall getTrimIndentCall(KtStringTemplateExpression element, KtStringTemplateEntry[] entries) {
        String string;
        KtQualifiedExpression ktQualifiedExpression;
        KtQualifiedExpression ktQualifiedExpression3 = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)element));
        ktQualifiedExpression3 = ktQualifiedExpression3;
        if (ktQualifiedExpression2 == null) return null;
        KtQualifiedExpression ktQualifiedExpression4 = ktQualifiedExpression = ktQualifiedExpression3;
        boolean bl = false;
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(ktQualifiedExpression4);
        if (ktCallExpression == null) return null;
        if (!FunctionUtilsKt.isCalling$default(ktCallExpression, ToOrdinaryStringLiteralIntentionKt.access$getTRIM_INDENT_FUNCTIONS$p(), null, 2, null)) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        KtQualifiedExpression ktQualifiedExpression3 = ktQualifiedExpression;
        ktQualifiedExpression3 = ktQualifiedExpression3;
        if (ktQualifiedExpression5 == null) {
            return null;
        }
        KtQualifiedExpression qualifiedExpression = ktQualifiedExpression3;
        if (Intrinsics.areEqual((Object)UtilsKt.getCalleeName(qualifiedExpression), (Object)"trimMargin")) {
            String string2;
            KtExpression arg;
            Object object = UtilsKt.getCallExpression(qualifiedExpression);
            KtExpression ktExpression = object != null && (object = object.getValueArguments()) != null && (object = (KtValueArgument)CollectionsKt.singleOrNull((List)object)) != null ? object.getArgumentExpression() : (arg = null);
            if (arg == null) {
                string2 = "|";
            } else {
                KtStringTemplateEntry ktStringTemplateEntry;
                if (!(arg instanceof KtStringTemplateExpression)) return null;
                KtStringTemplateEntry[] ktStringTemplateEntryArray = ((KtStringTemplateExpression)arg).getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
                KtStringTemplateEntry ktStringTemplateEntry3 = (KtStringTemplateEntry)ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
                ktStringTemplateEntry3 = ktStringTemplateEntry3;
                if (ktStringTemplateEntry2 == null) return null;
                KtStringTemplateEntry it = ktStringTemplateEntry = ktStringTemplateEntry3;
                boolean bl3 = false;
                if (!(it instanceof KtLiteralStringTemplateEntry)) return null;
                KtStringTemplateEntry ktStringTemplateEntry3 = ktStringTemplateEntry;
                ktStringTemplateEntry3 = ktStringTemplateEntry3;
                if (ktStringTemplateEntry4 == null) return null;
                string2 = ktStringTemplateEntry3.getText();
            }
            string = string2;
            if (string2 == null) {
                return null;
            }
        } else {
            string = null;
        }
        String marginPrefix = string;
        String string3 = ArraysKt.joinToString$default((Object[])entries, (CharSequence)"", null, null, (int)0, null, arg_0 -> ToOrdinaryStringLiteralIntention.getTrimIndentCall$lambda$4(this, arg_0), (int)30, null);
        ToOrdinaryStringLiteralIntention toOrdinaryStringLiteralIntention = this;
        boolean bl4 = false;
        String string4 = marginPrefix;
        String stringTemplateText = toOrdinaryStringLiteralIntention.escapeLineSeparators(string4 != null ? StringsKt.trimMargin((String)string3, (String)string4) : StringsKt.trimIndent((String)string3));
        return new TrimIndentCall(qualifiedExpression, stringTemplateText);
    }

    private static final CharSequence applyTo$lambda$1$lambda$0(ToOrdinaryStringLiteralIntention this$0, KtStringTemplateEntry it) {
        CharSequence charSequence;
        if (it instanceof KtLiteralStringTemplateEntry) {
            String string = ((KtLiteralStringTemplateEntry)it).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            charSequence = ToOrdinaryStringLiteralIntention.escape$default(this$0, string, false, 1, null);
        } else {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            charSequence = string;
        }
        return charSequence;
    }

    private static final CharSequence getTrimIndentCall$lambda$4(ToOrdinaryStringLiteralIntention this$0, KtStringTemplateEntry it) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof KtLiteralStringTemplateEntry) {
            String string = ((KtLiteralStringTemplateEntry)it).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            charSequence = this$0.escape(string, false);
        } else {
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            charSequence = string;
        }
        return charSequence;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ToOrdinaryStringLiteralIntention$TrimIndentCall;", "", "qualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "stringTemplateText", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Ljava/lang/String;)V", "getQualifiedExpression", "()Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "getStringTemplateText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.idea"})
    private static final class TrimIndentCall {
        @NotNull
        private final KtQualifiedExpression qualifiedExpression;
        @NotNull
        private final String stringTemplateText;

        public TrimIndentCall(@NotNull KtQualifiedExpression qualifiedExpression, @NotNull String stringTemplateText) {
            Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
            Intrinsics.checkNotNullParameter((Object)stringTemplateText, (String)"stringTemplateText");
            this.qualifiedExpression = qualifiedExpression;
            this.stringTemplateText = stringTemplateText;
        }

        @NotNull
        public final KtQualifiedExpression getQualifiedExpression() {
            return this.qualifiedExpression;
        }

        @NotNull
        public final String getStringTemplateText() {
            return this.stringTemplateText;
        }

        @NotNull
        public final KtQualifiedExpression component1() {
            return this.qualifiedExpression;
        }

        @NotNull
        public final String component2() {
            return this.stringTemplateText;
        }

        @NotNull
        public final TrimIndentCall copy(@NotNull KtQualifiedExpression qualifiedExpression, @NotNull String stringTemplateText) {
            Intrinsics.checkNotNullParameter((Object)qualifiedExpression, (String)"qualifiedExpression");
            Intrinsics.checkNotNullParameter((Object)stringTemplateText, (String)"stringTemplateText");
            return new TrimIndentCall(qualifiedExpression, stringTemplateText);
        }

        public static /* synthetic */ TrimIndentCall copy$default(TrimIndentCall trimIndentCall, KtQualifiedExpression ktQualifiedExpression, String string, int n, Object object) {
            if ((n & 1) != 0) {
                ktQualifiedExpression = trimIndentCall.qualifiedExpression;
            }
            if ((n & 2) != 0) {
                string = trimIndentCall.stringTemplateText;
            }
            return trimIndentCall.copy(ktQualifiedExpression, string);
        }

        @NotNull
        public String toString() {
            return "TrimIndentCall(qualifiedExpression=" + this.qualifiedExpression + ", stringTemplateText=" + this.stringTemplateText + ")";
        }

        public int hashCode() {
            int result2 = this.qualifiedExpression.hashCode();
            result2 = result2 * 31 + this.stringTemplateText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrimIndentCall)) {
                return false;
            }
            TrimIndentCall trimIndentCall = (TrimIndentCall)other;
            if (!Intrinsics.areEqual((Object)this.qualifiedExpression, (Object)trimIndentCall.qualifiedExpression)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stringTemplateText, (Object)trimIndentCall.stringTemplateText);
        }
    }
}

