/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.UtilsKt;
import org.jetbrains.kotlin.idea.inspections.CanBePrimaryConstructorPropertyUtils;
import org.jetbrains.kotlin.idea.intentions.JoinDeclarationAndAssignmentInspection;
import org.jetbrains.kotlin.idea.intentions.JoinDeclarationAndAssignmentIntentionKt;
import org.jetbrains.kotlin.idea.intentions.MovePropertyToConstructorUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u0002H\u0002J\u001c\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u0014\u0010\u0018\u001a\u00020\r*\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\f\u0010\u001b\u001a\u00020\r*\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u00020\r*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u001c\u0010\u001e\u001a\u00020\r*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\"\u001a\u00020\r*\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\u001e\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u001f0#2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\"\u0010\"\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u001f0#2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010$\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010\u00102\b\u0010&\u001a\u0004\u0018\u00010\u0010H\u0002J\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0#*\u00020\u001fH\u0002J\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001f0#*\u00020\u001fH\u0002J\u0016\u0010)\u001a\u0004\u0018\u00010!*\u00020*2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010)\u001a\u0004\u0018\u00010!*\u00020+2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0002J\u0012\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016*\u00020.H\u0002J\u0012\u00101\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016*\u00020.H\u0002J\u0012\u00102\u001a\u00020\r*\b\u0012\u0004\u0012\u00020\u001f0\u0016H\u0002\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/JoinDeclarationAndAssignmentIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableByPsi", "", "equalNullableTypes", "type1", "Lorg/jetbrains/kotlin/types/KotlinType;", "type2", "findAssignment", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "property", "collectAssignments", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "hasReferenceToSecondaryConstructorParameter", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isEmpty", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "dependsOnNextSiblingsOfProperty", "hasReference", "Lcom/intellij/psi/PsiElement;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "hasSmartCast", "Lkotlin/sequences/Sequence;", "isSubtype", "type", "superType", "prevSiblings", "nextSiblings", "descriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "moveComments", "from", "Lorg/jetbrains/kotlin/psi/KtExpression;", "to", "prevComments", "nextComments", "hasComments", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nJoinDeclarationAndAssignmentIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JoinDeclarationAndAssignmentIntention.kt\norg/jetbrains/kotlin/idea/intentions/JoinDeclarationAndAssignmentIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,331:1\n29#2,7:332\n340#3,9:339\n359#3:348\n213#3:349\n384#3:350\n395#3,10:351\n417#3:361\n384#3:362\n395#3,10:363\n417#3:373\n384#3:374\n395#3,10:375\n417#3:385\n384#3:386\n395#3,10:387\n417#3:397\n1251#4,2:398\n1251#4,2:400\n1251#4,2:446\n967#5,7:402\n739#5,9:409\n944#5,15:419\n739#5,9:434\n1755#5,3:443\n1#6:418\n*S KotlinDebug\n*F\n+ 1 JoinDeclarationAndAssignmentIntention.kt\norg/jetbrains/kotlin/idea/intentions/JoinDeclarationAndAssignmentIntention\n*L\n123#1:332,7\n189#1:339,9\n189#1:348\n194#1:349\n195#1:350\n195#1:351,10\n195#1:361\n206#1:362\n206#1:363,10\n206#1:373\n213#1:374\n213#1:375,10\n213#1:385\n220#1:386\n220#1:387,10\n220#1:397\n227#1:398,2\n230#1:400,2\n207#1:446,2\n275#1:402,7\n276#1:409,9\n282#1:419,15\n283#1:434,9\n287#1:443,3\n*E\n"})
public final class JoinDeclarationAndAssignmentIntention
extends SelfTargetingRangeIntention<KtProperty> {
    public JoinDeclarationAndAssignmentIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage((String)"join.declaration.and.assignment", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.isApplicableByPsi(element)) {
            return null;
        }
        KtBinaryExpression ktBinaryExpression = this.findAssignment(element);
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression assignment2 = ktBinaryExpression;
        KtExpression ktExpression = assignment2.getRight();
        if (ktExpression == null) {
            return null;
        }
        KtExpression initializer2 = ktExpression;
        BindingContext context = ResolutionUtils.analyze$default((KtElement)assignment2, null, 1, null);
        DeclarationDescriptor declarationDescriptor = this.descriptor((KtDeclaration)element, context);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor propertyDescriptor = declarationDescriptor;
        boolean isNonLocalVar = element.isVar() && !element.isLocal();
        Lazy typesCanBeMergedSafely = LazyKt.lazy(() -> JoinDeclarationAndAssignmentIntention.applicabilityRange$lambda$0(initializer2, context, element, this, assignment2, propertyDescriptor));
        Lazy isUsedBeforeAssignment = LazyKt.lazy(() -> JoinDeclarationAndAssignmentIntention.applicabilityRange$lambda$2(this, element, propertyDescriptor, context, assignment2));
        if (this.hasReference((PsiElement)initializer2, propertyDescriptor, context)) {
            return null;
        }
        if (this.dependsOnNextSiblingsOfProperty((KtElement)initializer2, element)) {
            return null;
        }
        if (!isNonLocalVar && !((Boolean)typesCanBeMergedSafely.getValue()).booleanValue()) {
            return null;
        }
        if (element.isLocal()) {
            if (element.hasModifier(KtTokens.LATEINIT_KEYWORD) && ((Boolean)isUsedBeforeAssignment.getValue()).booleanValue()) {
                return null;
            }
        } else {
            boolean reportWithComplexInitializationOfMemberProperties;
            IntentionBasedInspection intentionBasedInspection = this.getInspection();
            JoinDeclarationAndAssignmentInspection joinDeclarationAndAssignmentInspection = intentionBasedInspection instanceof JoinDeclarationAndAssignmentInspection ? (JoinDeclarationAndAssignmentInspection)intentionBasedInspection : null;
            boolean bl = reportWithComplexInitializationOfMemberProperties = joinDeclarationAndAssignmentInspection != null ? joinDeclarationAndAssignmentInspection.reportWithComplexInitializationOfMemberProperties : true;
            if (!reportWithComplexInitializationOfMemberProperties) {
                if (UtilsKt.isComplexInitializer(initializer2)) {
                    return null;
                }
                if (this.hasReference(this.nextSiblings((PsiElement)assignment2), propertyDescriptor, context)) {
                    return null;
                }
            }
        }
        KtModifierList ktModifierList = element.getModifierList();
        PsiElement psiElement = ktModifierList != null ? (PsiElement)ktModifierList : element.getValOrVarKeyword();
        Intrinsics.checkNotNull((Object)psiElement);
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)psiElement);
        KtTypeReference ktTypeReference = element.getTypeReference();
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)(ktTypeReference != null ? (KtModifierListOwnerStub)ktTypeReference : (KtModifierListOwnerStub)element)));
        return new TextRange(startOffset, endOffset);
    }

    @Override
    public void applyTo(@NotNull KtProperty element, @Nullable Editor editor) {
        block14: {
            KtProperty newProperty;
            KtSecondaryConstructor secondaryConstructor;
            PsiElement psiElement;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.getTypeReference() == null) {
                return;
            }
            KtBinaryExpression ktBinaryExpression = this.findAssignment(element);
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression assignment2 = ktBinaryExpression;
            KtExpression ktExpression = assignment2.getRight();
            if (ktExpression == null) {
                return;
            }
            KtExpression initializer2 = ktExpression;
            element.setInitializer(initializer2);
            if (element.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
                element.removeModifier(KtTokens.LATEINIT_KEYWORD);
            }
            KtBlockExpression ktBlockExpression = (psiElement = assignment2.getParent()) instanceof KtBlockExpression ? (KtBlockExpression)psiElement : null;
            PsiElement grandParent = ktBlockExpression != null ? ktBlockExpression.getParent() : null;
            KtAnonymousInitializer initializerBlock = grandParent instanceof KtAnonymousInitializer ? (KtAnonymousInitializer)grandParent : null;
            KtSecondaryConstructor ktSecondaryConstructor = secondaryConstructor = grandParent instanceof KtSecondaryConstructor ? (KtSecondaryConstructor)grandParent : null;
            if (!(element.isLocal() || initializerBlock == null && secondaryConstructor == null)) {
                KtBlockExpression secondaryConstructorBlock;
                this.moveComments((KtExpression)assignment2, (KtExpression)element);
                JoinDeclarationAndAssignmentIntentionKt.access$deleteWithPreviousWhitespace((KtElement)assignment2);
                KtAnonymousInitializer ktAnonymousInitializer = initializerBlock;
                KtExpression ktExpression2 = ktAnonymousInitializer != null ? ktAnonymousInitializer.getBody() : null;
                KtBlockExpression ktBlockExpression2 = ktExpression2 instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null;
                boolean bl = ktBlockExpression2 != null ? this.isEmpty(ktBlockExpression2) : false;
                if (bl) {
                    JoinDeclarationAndAssignmentIntentionKt.access$deleteWithPreviousWhitespace((KtElement)initializerBlock);
                }
                KtSecondaryConstructor ktSecondaryConstructor2 = secondaryConstructor;
                KtBlockExpression ktBlockExpression3 = secondaryConstructorBlock = ktSecondaryConstructor2 != null ? ktSecondaryConstructor2.getBodyBlockExpression() : null;
                boolean bl2 = ktBlockExpression3 != null ? this.isEmpty(ktBlockExpression3) : false;
                if (bl2) {
                    JoinDeclarationAndAssignmentIntentionKt.access$deleteWithPreviousWhitespace((KtElement)secondaryConstructorBlock);
                }
                v10 = element;
            } else {
                PsiElement psiElement2;
                this.moveComments((KtExpression)element, (KtExpression)assignment2);
                PsiElement $this$replaced$iv = (PsiElement)assignment2;
                boolean $i$f$replaced = false;
                if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)((PsiElement)element))) {
                    psiElement2 = (PsiElement)element;
                } else {
                    PsiElement result$iv = $this$replaced$iv.replace((PsiElement)element);
                    if (result$iv instanceof KtProperty) {
                        psiElement2 = result$iv;
                    } else {
                        Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                        KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                        if (ktExpression3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                        }
                        psiElement2 = (PsiElement)((KtProperty)ktExpression3);
                    }
                }
                PsiElement psiElement3 = psiElement2;
                KtProperty it = (KtProperty)psiElement3;
                boolean bl = false;
                JoinDeclarationAndAssignmentIntentionKt.access$deleteWithPreviousWhitespace((KtElement)element);
                v10 = newProperty = (KtProperty)psiElement3;
            }
            if (CanBePrimaryConstructorPropertyUtils.INSTANCE.canBePrimaryConstructorProperty(newProperty)) {
                MovePropertyToConstructorUtils.INSTANCE.moveToConstructor(newProperty);
                return;
            }
            Editor editor2 = editor;
            if (editor2 == null) break block14;
            JoinDeclarationAndAssignmentIntentionKt.access$update(editor2, newProperty);
        }
    }

    private final boolean isApplicableByPsi(KtProperty $this$isApplicableByPsi) {
        return !$this$isApplicableByPsi.hasDelegate() && !$this$isApplicableByPsi.hasInitializer() && $this$isApplicableByPsi.getGetter() == null && $this$isApplicableByPsi.getSetter() == null && $this$isApplicableByPsi.getReceiverTypeReference() == null && $this$isApplicableByPsi.getName() != null;
    }

    private final boolean equalNullableTypes(KotlinType type1, KotlinType type2) {
        if (type1 == null) {
            return type2 == null;
        }
        if (type2 == null) {
            return false;
        }
        return TypeUtils.equalTypes((KotlinType)type1, (KotlinType)type2);
    }

    private final KtBinaryExpression findAssignment(KtProperty property) {
        if (property.getTypeReference() == null) {
            return null;
        }
        PsiElement psiElement = property.getParent();
        KtElement ktElement = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        if (ktElement == null) {
            return null;
        }
        KtElement propertyContainer = ktElement;
        List<KtBinaryExpression> assignments = this.collectAssignments(propertyContainer, property);
        if (!JoinDeclarationAndAssignmentIntentionKt.access$validate(assignments, propertyContainer)) {
            return null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)CollectionsKt.firstOrNull(assignments);
        if (ktBinaryExpression == null) {
            return null;
        }
        KtBinaryExpression firstAssignment = ktBinaryExpression;
        BindingContext context = ResolutionUtils.analyze$default((KtElement)firstAssignment, null, 1, null);
        if (!property.isLocal() && !Intrinsics.areEqual((Object)firstAssignment.getParent(), (Object)propertyContainer) && this.hasReferenceToSecondaryConstructorParameter(firstAssignment, context)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = this.descriptor((KtDeclaration)property, context);
        if (declarationDescriptor == null) {
            return null;
        }
        DeclarationDescriptor propertyDescriptor = declarationDescriptor;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)firstAssignment.getLeft()), (BindingContext)context);
        if (resolvedCall == null || (resolvedCall = resolvedCall.getCandidateDescriptor()) == null) {
            return null;
        }
        ResolvedCall assignedDescriptor = resolvedCall;
        if (!Intrinsics.areEqual((Object)propertyDescriptor, (Object)assignedDescriptor)) {
            return null;
        }
        if (!(propertyContainer instanceof KtClassBody)) {
            return firstAssignment;
        }
        PsiElement psiElement2 = firstAssignment.getParent();
        KtBlockExpression ktBlockExpression = psiElement2 instanceof KtBlockExpression ? (KtBlockExpression)psiElement2 : null;
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression blockParent = ktBlockExpression;
        List list2 = blockParent.getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
        return Intrinsics.areEqual((Object)CollectionsKt.firstOrNull((List)list2), (Object)firstAssignment) ? firstAssignment : null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtBinaryExpression> collectAssignments(KtElement $this$collectAssignments, KtProperty property) {
        void $this$forEachDescendantOfType$iv;
        List assignments = new ArrayList();
        PsiElement psiElement = (PsiElement)$this$collectAssignments;
        Function1 action$iv = (Function1)new Function1<KtBinaryExpression, Unit>(property, (List<KtBinaryExpression>)assignments){
            final /* synthetic */ KtProperty $property;
            final /* synthetic */ List<KtBinaryExpression> $assignments;
            {
                this.$property = $property;
                this.$assignments = $assignments;
                super(1, Intrinsics.Kotlin.class, "process", "collectAssignments$process(Lorg/jetbrains/kotlin/psi/KtProperty;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtBinaryExpression;)V", 0);
            }

            public final void invoke(KtBinaryExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                JoinDeclarationAndAssignmentIntention.access$collectAssignments$process(this.$property, this.$assignments, p0);
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
        $this$forEachDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtBinaryExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        return assignments;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasReferenceToSecondaryConstructorParameter(KtBinaryExpression $this$hasReferenceToSecondaryConstructorParameter, BindingContext context) {
        boolean bl;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$hasReferenceToSecondaryConstructorParameter;
        boolean $i$f$getStrictParentOfType = false;
        KtSecondaryConstructor ktSecondaryConstructor = (KtSecondaryConstructor)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtSecondaryConstructor.class, (boolean)true);
        if (ktSecondaryConstructor == null || (ktSecondaryConstructor = this.descriptor((KtDeclaration)ktSecondaryConstructor, context)) == null) {
            return false;
        }
        KtSecondaryConstructor secondaryConstructor = ktSecondaryConstructor;
        KtExpression ktExpression = $this$hasReferenceToSecondaryConstructorParameter.getRight();
        if (ktExpression != null) {
            void $this$anyDescendantOfType$iv;
            $this$getStrictParentOfType$iv = (PsiElement)ktExpression;
            Function1 predicate$iv = arg_0 -> JoinDeclarationAndAssignmentIntention.hasReferenceToSecondaryConstructorParameter$lambda$4(this, context, (DeclarationDescriptor)secondaryConstructor, arg_0);
            boolean $i$f$anyDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
            boolean $i$f$findDescendantOfType = false;
            void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
            boolean $i$f$findDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
            Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
            $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ Ref.ObjectRef $result;
                {
                    this.$predicate = $predicate;
                    this.$result = $result;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                        this.$result.element = element;
                        this.stopWalking();
                        return;
                    }
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                }
            });
            bl = (PsiElement)result$iv$iv$iv.element != null;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isEmpty(KtBlockExpression $this$isEmpty) {
        return KtPsiUtilKt.contentRange((KtBlockExpression)$this$isEmpty).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean dependsOnNextSiblingsOfProperty(KtElement $this$dependsOnNextSiblingsOfProperty, KtProperty property) {
        void $this$anyDescendantOfType$iv;
        PsiElement propertyScope = property.getParent();
        Sequence<PsiElement> nextSiblings = this.nextSiblings((PsiElement)property);
        PsiElement psiElement = (PsiElement)$this$dependsOnNextSiblingsOfProperty;
        Function1 predicate$iv = arg_0 -> JoinDeclarationAndAssignmentIntention.dependsOnNextSiblingsOfProperty$lambda$6(propertyScope, nextSiblings, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasReference(PsiElement $this$hasReference, DeclarationDescriptor declaration, BindingContext context) {
        void $this$anyDescendantOfType$iv;
        String string = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String declarationName = string;
        PsiElement psiElement = $this$hasReference;
        Function1 predicate$iv = arg_0 -> JoinDeclarationAndAssignmentIntention.hasReference$lambda$7(declarationName, this, context, declaration, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasSmartCast(PsiElement $this$hasSmartCast, DeclarationDescriptor declaration, BindingContext context) {
        void $this$anyDescendantOfType$iv;
        String string = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String declarationName = string;
        PsiElement psiElement = $this$hasSmartCast;
        Function1 predicate$iv = arg_0 -> JoinDeclarationAndAssignmentIntention.hasSmartCast$lambda$8(declarationName, this, context, declaration, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean hasReference(Sequence<? extends PsiElement> $this$hasReference, DeclarationDescriptor declaration, BindingContext context) {
        boolean bl;
        block1: {
            Sequence<? extends PsiElement> $this$any$iv = $this$hasReference;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!this.hasReference(it, declaration, context)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean hasSmartCast(Sequence<? extends PsiElement> $this$hasSmartCast, DeclarationDescriptor declaration, BindingContext context) {
        boolean bl;
        block1: {
            Sequence<? extends PsiElement> $this$any$iv = $this$hasSmartCast;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!this.hasSmartCast(it, declaration, context)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isSubtype(KotlinType type2, KotlinType superType) {
        if (type2 == null || superType == null) {
            return false;
        }
        return TypeUtilsKt.isSubtypeOf((KotlinType)type2, (KotlinType)superType);
    }

    private final Sequence<PsiElement> prevSiblings(PsiElement $this$prevSiblings) {
        return PsiUtilsKt.siblings((PsiElement)$this$prevSiblings, (boolean)false, (boolean)false);
    }

    private final Sequence<PsiElement> nextSiblings(PsiElement $this$nextSiblings) {
        return PsiUtilsKt.siblings((PsiElement)$this$nextSiblings, (boolean)true, (boolean)false);
    }

    private final DeclarationDescriptor descriptor(KtDeclaration $this$descriptor, BindingContext context) {
        return (DeclarationDescriptor)context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$descriptor);
    }

    private final DeclarationDescriptor descriptor(KtNameReferenceExpression $this$descriptor, BindingContext context) {
        return (DeclarationDescriptor)context.get((ReadOnlySlice)BindingContext.REFERENCE_TARGET, (Object)$this$descriptor);
    }

    private final void moveComments(KtExpression from, KtExpression to2) {
        PsiElement anchor;
        PsiElement last;
        PsiElement first2;
        Project project = from.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        List<PsiElement> prevComments2 = this.prevComments(from);
        List<PsiElement> nextComments2 = this.nextComments(from);
        if (!((Collection)prevComments2).isEmpty()) {
            first2 = (PsiElement)CollectionsKt.first(prevComments2);
            last = (PsiElement)CollectionsKt.last(prevComments2);
            PsiElement psiElement = (PsiElement)CollectionsKt.lastOrNull(this.prevComments(to2));
            if (psiElement == null || (psiElement = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default((PsiElement)psiElement, (boolean)false, (int)1, null)) == null) {
                psiElement = (PsiElement)to2;
            }
            anchor = psiElement;
            anchor.getParent().addRangeBefore(first2, last, anchor);
            first2.getParent().deleteChildRange(first2, last);
        }
        if (!((Collection)nextComments2).isEmpty()) {
            first2 = (PsiElement)CollectionsKt.first(nextComments2);
            last = (PsiElement)CollectionsKt.last(nextComments2);
            PsiElement psiElement = (PsiElement)CollectionsKt.lastOrNull(this.nextComments(to2));
            if (psiElement == null) {
                psiElement = (PsiElement)to2;
            }
            anchor = psiElement;
            anchor.getParent().addRangeAfter(first2, last, anchor);
            if (anchor instanceof PsiComment) {
                ((PsiComment)anchor).getParent().addAfter(psiFactory.createNewLine(), anchor);
            }
            first2.getParent().deleteChildRange(first2, last);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> prevComments(KtExpression $this$prevComments) {
        List comments2;
        List list2;
        List list3;
        void $this$dropLastWhile$iv;
        Iterable $this$takeWhile$iv = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$prevComments))));
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            PsiElement it = (PsiElement)item$iv;
            boolean bl = false;
            if (!JoinDeclarationAndAssignmentIntention.prevComments$isComment(it)) break;
            list$iv.add(item$iv);
        }
        $this$takeWhile$iv = CollectionsKt.reversed((Iterable)SequencesKt.toList((Sequence)SequencesKt.takeWhile(this.prevSiblings((PsiElement)$this$prevComments), JoinDeclarationAndAssignmentIntention::prevComments$lambda$12)));
        Collection collection = list$iv;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                PsiElement it = (PsiElement)iterator$iv.previous();
                boolean bl = false;
                if (it instanceof PsiWhiteSpace) continue;
                list3 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List it = list2 = (comments2 = CollectionsKt.plus((Collection)collection, (Iterable)list3));
        boolean bl = false;
        List list4 = this.hasComments(it) ? list2 : null;
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        return list4;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> nextComments(KtExpression $this$nextComments) {
        List comments2;
        List list2;
        List list3;
        void $this$dropLastWhile$iv;
        PsiElement it;
        ListIterator iterator$iv;
        List list4;
        List $this$takeLastWhile$iv;
        block10: {
            $this$takeLastWhile$iv = SequencesKt.toList((Sequence)((Sequence)PsiUtilsKt.getAllChildren((PsiElement)((PsiElement)$this$nextComments))));
            boolean $i$f$takeLastWhile = false;
            if ($this$takeLastWhile$iv.isEmpty()) {
                list4 = CollectionsKt.emptyList();
            } else {
                iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = (PsiElement)iterator$iv.previous();
                    boolean bl = false;
                    if (JoinDeclarationAndAssignmentIntention.nextComments$isComment$15(it)) continue;
                    iterator$iv.next();
                    int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                    if (expectedSize$iv == 0) {
                        list4 = CollectionsKt.emptyList();
                    } else {
                        ArrayList arrayList;
                        ArrayList $this$takeLastWhile_u24lambda_u246$iv = arrayList = new ArrayList(expectedSize$iv);
                        boolean bl2 = false;
                        while (iterator$iv.hasNext()) {
                            $this$takeLastWhile_u24lambda_u246$iv.add(iterator$iv.next());
                        }
                        list4 = arrayList;
                    }
                    break block10;
                }
                list4 = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
            }
        }
        $this$takeLastWhile$iv = SequencesKt.toList((Sequence)SequencesKt.takeWhile(this.nextSiblings((PsiElement)$this$nextComments), JoinDeclarationAndAssignmentIntention::nextComments$lambda$17));
        Collection collection = list4;
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (PsiElement)iterator$iv.previous();
                boolean bl = false;
                if (it instanceof PsiWhiteSpace) continue;
                list3 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list3 = CollectionsKt.emptyList();
        }
        List it2 = list2 = (comments2 = CollectionsKt.plus((Collection)collection, (Iterable)list3));
        boolean bl = false;
        List list5 = this.hasComments(it2) ? list2 : null;
        if (list5 == null) {
            list5 = CollectionsKt.emptyList();
        }
        return list5;
    }

    private final boolean hasComments(List<? extends PsiElement> $this$hasComments) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$hasComments;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof PsiComment)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean applicabilityRange$lambda$0(KtExpression $initializer, BindingContext $context, KtProperty $element, JoinDeclarationAndAssignmentIntention this$0, KtBinaryExpression $assignment, DeclarationDescriptor $propertyDescriptor) {
        KotlinType initializerType = CallUtilKt.getType((KtExpression)$initializer, (BindingContext)$context);
        KotlinType propertyType = (KotlinType)$context.get((ReadOnlySlice)BindingContext.TYPE, (Object)$element.getTypeReference());
        return this$0.equalNullableTypes(initializerType, propertyType) ? true : (this$0.isSubtype(initializerType, propertyType) ? !this$0.hasSmartCast(this$0.nextSiblings((PsiElement)$assignment), $propertyDescriptor, $context) : false);
    }

    private static final boolean applicabilityRange$lambda$2$lambda$1(KtBinaryExpression $assignment, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it, (Object)$assignment);
    }

    private static final boolean applicabilityRange$lambda$2(JoinDeclarationAndAssignmentIntention this$0, KtProperty $element, DeclarationDescriptor $propertyDescriptor, BindingContext $context, KtBinaryExpression $assignment) {
        return this$0.hasReference((Sequence<? extends PsiElement>)SequencesKt.takeWhile(this$0.nextSiblings((PsiElement)$element), arg_0 -> JoinDeclarationAndAssignmentIntention.applicabilityRange$lambda$2$lambda$1($assignment, arg_0)), $propertyDescriptor, $context);
    }

    private static final void collectAssignments$process(KtProperty $property, List<KtBinaryExpression> assignments, KtBinaryExpression binaryExpr) {
        KtExpression ktExpression;
        if (!Intrinsics.areEqual((Object)binaryExpr.getOperationToken(), (Object)KtTokens.EQ)) {
            return;
        }
        KtExpression left = binaryExpr.getLeft();
        Object object = left instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)left : (left instanceof KtDotQualifiedExpression ? ((ktExpression = ((KtDotQualifiedExpression)left).getSelectorExpression()) instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null) : null);
        if (object == null) {
            return;
        }
        KtNameReferenceExpression leftReference = object;
        if (Intrinsics.areEqual((Object)leftReference.getReferencedName(), (Object)$property.getName())) {
            ((Collection)assignments).add(binaryExpr);
        }
    }

    private static final boolean hasReferenceToSecondaryConstructorParameter$lambda$4(JoinDeclarationAndAssignmentIntention this$0, BindingContext $context, DeclarationDescriptor $secondaryConstructor, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DeclarationDescriptor declarationDescriptor = this$0.descriptor(it, $context);
        ValueParameterDescriptor valueParameterDescriptor = declarationDescriptor instanceof ValueParameterDescriptor ? (ValueParameterDescriptor)declarationDescriptor : null;
        return Intrinsics.areEqual((Object)(valueParameterDescriptor != null ? valueParameterDescriptor.getContainingDeclaration() : null), (Object)$secondaryConstructor);
    }

    private static final boolean dependsOnNextSiblingsOfProperty$lambda$6(PsiElement $propertyScope, Sequence $nextSiblings, PsiElement child) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)child, (String)"child");
            Sequence $this$any$iv = JoinDeclarationAndAssignmentIntentionKt.access$resolveAllReferences(child);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!(it != null && PsiTreeUtil.isAncestor((PsiElement)$propertyScope, (PsiElement)it, (boolean)false) && SequencesKt.contains((Sequence)$nextSiblings, (Object)it))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private static final boolean hasReference$lambda$7(String $declarationName, JoinDeclarationAndAssignmentIntention this$0, BindingContext $context, DeclarationDescriptor $declaration, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getText(), (Object)$declarationName) && Intrinsics.areEqual((Object)this$0.descriptor(it, $context), (Object)$declaration);
    }

    private static final boolean hasSmartCast$lambda$8(String $declarationName, JoinDeclarationAndAssignmentIntention this$0, BindingContext $context, DeclarationDescriptor $declaration, KtNameReferenceExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getText(), (Object)$declarationName) && Intrinsics.areEqual((Object)this$0.descriptor(it, $context), (Object)$declaration) && $context.get((ReadOnlySlice)BindingContext.SMARTCAST, (Object)it) != null;
    }

    private static final boolean prevComments$isComment(PsiElement $this$prevComments_u24isComment) {
        return $this$prevComments_u24isComment instanceof PsiComment || $this$prevComments_u24isComment instanceof PsiWhiteSpace;
    }

    private static final boolean prevComments$lambda$12(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JoinDeclarationAndAssignmentIntention.prevComments$isComment(it);
    }

    private static final boolean nextComments$isComment$15(PsiElement $this$nextComments_u24isComment_u2415) {
        return $this$nextComments_u24isComment_u2415 instanceof PsiComment || $this$nextComments_u24isComment_u2415 instanceof PsiWhiteSpace && !$this$nextComments_u24isComment_u2415.textContains('\n');
    }

    private static final boolean nextComments$lambda$17(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return JoinDeclarationAndAssignmentIntention.nextComments$isComment$15(it);
    }

    public static final /* synthetic */ void access$collectAssignments$process(KtProperty $property, List assignments, KtBinaryExpression binaryExpr) {
        JoinDeclarationAndAssignmentIntention.collectAssignments$process($property, assignments, binaryExpr);
    }
}

