/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ExpectActualUtilKt;
import org.jetbrains.kotlin.idea.util.ModifierListModifactorKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"canIntroduceBackingProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "introduceBackingProperty", "", "createGetter", "element", "createSetter", "addAccessor", "newAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "createBackingProperty", "backingName", "", "replaceFieldReferences", "Lorg/jetbrains/kotlin/psi/KtElement;", "propertyName", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nIntroduceBackingPropertyIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntroduceBackingPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntentionKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n213#2:133\n2632#3,3:134\n*S KotlinDebug\n*F\n+ 1 IntroduceBackingPropertyIntention.kt\norg/jetbrains/kotlin/idea/intentions/IntroduceBackingPropertyIntentionKt\n*L\n40#1:133\n42#1:134,3\n*E\n"})
public final class IntroduceBackingPropertyIntentionKt {
    private static final boolean canIntroduceBackingProperty(KtProperty property) {
        boolean bl;
        block10: {
            String string = property.getName();
            if (string == null) {
                return false;
            }
            String name2 = string;
            if (property.hasModifier(KtTokens.CONST_KEYWORD)) {
                return false;
            }
            if (ModifierListModifactorKt.hasJvmFieldAnnotation((KtAnnotated)property)) {
                return false;
            }
            BindingContext bindingContext = ResolutionFacade.analyzeWithAllCompilerChecks$default(ResolutionUtils.getResolutionFacade((KtElement)property), (KtElement)property, null, 2, null).getBindingContext();
            Object object = bindingContext.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)property);
            PropertyDescriptor propertyDescriptor = object instanceof PropertyDescriptor ? (PropertyDescriptor)object : null;
            if (propertyDescriptor == null) {
                return false;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor;
            if (!Intrinsics.areEqual((Object)bindingContext.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)descriptor2), (Object)true)) {
                return false;
            }
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)property;
            boolean $i$f$getStrictParentOfType = false;
            KtClassOrObject ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClassOrObject.class, (boolean)true);
            if (ktClassOrObject == null) {
                return false;
            }
            KtClassOrObject containingClass = ktClassOrObject;
            if (ExpectActualUtilKt.isExpectDeclaration((KtDeclaration)containingClass)) {
                return false;
            }
            Iterable $this$none$iv = containingClass.getDeclarations();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KtDeclaration it = (KtDeclaration)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof KtProperty && Intrinsics.areEqual((Object)((KtProperty)it).getName(), (Object)("_" + name2)))) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final void introduceBackingProperty(KtProperty property) {
        KtPropertyAccessor getter;
        IntroduceBackingPropertyIntentionKt.createBackingProperty(property);
        property.removeModifier(KtTokens.LATEINIT_KEYWORD);
        if (property.getTypeReference() == null) {
            KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration((KtCallableDeclaration)property);
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(null, (KtCallableDeclaration)property, type2);
        }
        if ((getter = property.getGetter()) == null) {
            IntroduceBackingPropertyIntentionKt.createGetter(property);
        } else {
            KtElement ktElement = (KtElement)getter;
            String string = property.getName();
            Intrinsics.checkNotNull((Object)string);
            IntroduceBackingPropertyIntentionKt.replaceFieldReferences(ktElement, string);
        }
        if (property.isVar()) {
            KtPropertyAccessor setter = property.getSetter();
            if (setter == null) {
                IntroduceBackingPropertyIntentionKt.createSetter(property);
            } else {
                KtElement ktElement = (KtElement)setter;
                String string = property.getName();
                Intrinsics.checkNotNull((Object)string);
                IntroduceBackingPropertyIntentionKt.replaceFieldReferences(ktElement, string);
            }
        }
        property.setInitializer(null);
    }

    private static final void createGetter(KtProperty element) {
        String body2 = "get() = " + IntroduceBackingPropertyIntentionKt.backingName(element);
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPropertyAccessor ktPropertyAccessor = new KtPsiFactory(project, false, 2, null).createProperty("val x " + body2).getGetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        KtPropertyAccessor newGetter = ktPropertyAccessor;
        IntroduceBackingPropertyIntentionKt.addAccessor(element, newGetter);
    }

    private static final void createSetter(KtProperty element) {
        String body2 = "set(value) { " + IntroduceBackingPropertyIntentionKt.backingName(element) + " = value }";
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPropertyAccessor ktPropertyAccessor = new KtPsiFactory(project, false, 2, null).createProperty("val x " + body2).getSetter();
        Intrinsics.checkNotNull((Object)ktPropertyAccessor);
        KtPropertyAccessor newSetter = ktPropertyAccessor;
        IntroduceBackingPropertyIntentionKt.addAccessor(element, newSetter);
    }

    private static final void addAccessor(KtProperty $this$addAccessor, KtPropertyAccessor newAccessor) {
        ASTNode semicolon = $this$addAccessor.getNode().findChildByType((IElementType)KtTokens.SEMICOLON);
        ASTNode aSTNode = semicolon;
        $this$addAccessor.addBefore((PsiElement)newAccessor, (PsiElement)(aSTNode != null ? aSTNode.getPsi() : null));
    }

    private static final void createBackingProperty(KtProperty property) {
        Project project = property.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtDeclaration backingProperty = CreateByPatternKt.buildDeclaration((KtPsiFactory)new KtPsiFactory(project, false, 2, null), arg_0 -> IntroduceBackingPropertyIntentionKt.createBackingProperty$lambda$1(property, arg_0));
        if (property.hasModifier(KtTokens.LATEINIT_KEYWORD)) {
            backingProperty.addModifier(KtTokens.LATEINIT_KEYWORD);
        }
        property.getParent().addBefore((PsiElement)backingProperty, (PsiElement)property);
    }

    private static final String backingName(KtProperty property) {
        Object object = property.getNameIdentifier();
        return (object != null && (object = object.getText()) != null ? StringsKt.startsWith$default((CharSequence)((CharSequence)object), (char)'`', (boolean)false, (int)2, null) : false) ? "`_" + property.getName() + "`" : "_" + property.getName();
    }

    private static final void replaceFieldReferences(KtElement element, String propertyName) {
        element.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid(element, propertyName){
            final /* synthetic */ KtElement $element;
            final /* synthetic */ String $propertyName;
            {
                this.$element = $element;
                this.$propertyName = $propertyName;
            }

            public void visitSimpleNameExpression(KtSimpleNameExpression expression) {
                CallableDescriptor target;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)expression, null, 1, null);
                Object object = target = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
                if (target instanceof SyntheticFieldDescriptor) {
                    Project project = this.$element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    expression.replace((PsiElement)new KtPsiFactory(project, false, 2, null).createSimpleName("_" + this.$propertyName));
                }
            }

            public void visitPropertyAccessor(KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
            }
        });
    }

    private static final Unit createBackingProperty$lambda$1(KtProperty $property, BuilderByPattern $this$buildDeclaration) {
        Intrinsics.checkNotNullParameter((Object)$this$buildDeclaration, (String)"$this$buildDeclaration");
        $this$buildDeclaration.appendFixedText("private ");
        String string = $property.getValOrVarKeyword().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $this$buildDeclaration.appendFixedText(string);
        $this$buildDeclaration.appendFixedText(" ");
        $this$buildDeclaration.appendNonFormattedText(IntroduceBackingPropertyIntentionKt.backingName($property));
        if ($property.getTypeReference() != null) {
            $this$buildDeclaration.appendFixedText(": ");
            $this$buildDeclaration.appendTypeReference($property.getTypeReference());
        }
        if ($property.getInitializer() != null) {
            $this$buildDeclaration.appendFixedText(" = ");
            $this$buildDeclaration.appendExpression($property.getInitializer());
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$canIntroduceBackingProperty(KtProperty property) {
        return IntroduceBackingPropertyIntentionKt.canIntroduceBackingProperty(property);
    }

    public static final /* synthetic */ void access$introduceBackingProperty(KtProperty property) {
        IntroduceBackingPropertyIntentionKt.introduceBackingProperty(property);
    }
}

