/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.quickFix.ConvertPropertyInitializerToGetterUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyInitializerToGetterIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "skipProcessingFurtherElementsAfter", "", "Lcom/intellij/psi/PsiElement;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Factory", "kotlin.idea"})
public final class ConvertPropertyInitializerToGetterIntention
extends SelfTargetingRangeIntention<KtProperty> {
    public ConvertPropertyInitializerToGetterIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage((String)"convert.property.initializer.to.getter", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtProperty element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getInitializer();
        if (ktExpression == null) {
            return null;
        }
        KtExpression initializer2 = ktExpression;
        PsiElement psiElement = element.getNameIdentifier();
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        if (!ConvertPropertyInitializerToGetterUtilsKt.canConvertPropertyInitializerToGetterByPsi(element)) {
            return null;
        }
        if (ConvertPropertyInitializerToGetterUtilsKt.hasReferenceToPrimaryConstructorParameter(initializer2)) {
            return null;
        }
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)nameIdentifier), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)initializer2)));
    }

    @Override
    protected boolean skipProcessingFurtherElementsAfter(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtDeclaration || super.skipProcessingFurtherElementsAfter(element);
    }

    @Override
    public void applyTo(@NotNull KtProperty element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Factory.INSTANCE.convertPropertyInitializerToGetter(element, editor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyInitializerToGetterIntention$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "convertPropertyInitializerToGetter", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
    public static final class Factory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        @NotNull
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            return new ConvertPropertyInitializerToGetterIntention();
        }

        public final void convertPropertyInitializerToGetter(@NotNull KtProperty property, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            ConvertPropertyInitializerToGetterUtilsKt.convertPropertyInitializerToGetterInner(property, (Function0<Unit>)((Function0)() -> Factory.convertPropertyInitializerToGetter$lambda$0(property, editor)));
        }

        private static final Unit convertPropertyInitializerToGetter$lambda$0(KtProperty $property, Editor $editor) {
            KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration((KtCallableDeclaration)$property);
            if (!KotlinTypeKt.isError((KotlinType)type2)) {
                SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation($editor, (KtCallableDeclaration)$property, type2);
            }
            return Unit.INSTANCE;
        }
    }
}

