/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertOrdinaryPropertyToLazyIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "<init>", "()V", "isApplicableTo", "", "element", "caretOffset", "", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.idea"})
public final class ConvertOrdinaryPropertyToLazyIntention
extends SelfTargetingIntention<KtProperty> {
    public ConvertOrdinaryPropertyToLazyIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage((String)"convert.to.lazy.property", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    public boolean isApplicableTo(@NotNull KtProperty element, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return !element.isVar() && element.getInitializer() != null && element.getGetter() == null && !element.isLocal() && !element.hasModifier(KtTokens.CONST_KEYWORD);
    }

    @Override
    public void applyTo(@NotNull KtProperty element, @Nullable Editor editor) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression2 = element.getInitializer();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression initializer2 = ktExpression2;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (initializer2 instanceof KtCallExpression && FunctionUtilsKt.isCalling$default((KtCallExpression)initializer2, new FqName("kotlin.run"), null, 2, null)) {
            KtExpression ktExpression3 = ((KtCallExpression)initializer2).getCalleeExpression();
            if (ktExpression3 != null) {
                ktExpression3.replace((PsiElement)psiFactory.createExpression("lazy"));
            }
            ktExpression = initializer2;
        } else {
            Object[] objectArray = new Object[]{initializer2};
            ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"lazy { $0 }", (Object[])objectArray, (boolean)false, (int)4, null);
        }
        KtExpression newExpression = ktExpression;
        element.addAfter((PsiElement)psiFactory.createPropertyDelegate(newExpression), (PsiElement)initializer2);
        element.setInitializer(null);
    }
}

