/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinBaseCodeInsightBundle;
import org.jetbrains.kotlin.idea.inspections.suppress.AnnotationHostKind;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bJ!\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001f\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020 2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010!J\u001f\u0010\"\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020#2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010$J!\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010&\u001a\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010(\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/suppress/DeclarationKindDetector;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "", "<init>", "()V", "detect", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "visitDeclaration", "", "data", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lkotlin/Unit;)Ljava/lang/Void;", "getDeclarationName", "", "Lcom/intellij/openapi/util/NlsSafe;", "visitClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitEnumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "(Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "visitObjectDeclaration", "d", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nKotlinSuppressableWarningProblemGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSuppressableWarningProblemGroup.kt\norg/jetbrains/kotlin/idea/inspections/suppress/DeclarationKindDetector\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,146:1\n213#2:147\n*S KotlinDebug\n*F\n+ 1 KotlinSuppressableWarningProblemGroup.kt\norg/jetbrains/kotlin/idea/inspections/suppress/DeclarationKindDetector\n*L\n135#1:147\n*E\n"})
final class DeclarationKindDetector
extends KtVisitor<AnnotationHostKind, Unit> {
    @NotNull
    public static final DeclarationKindDetector INSTANCE = new DeclarationKindDetector();

    private DeclarationKindDetector() {
    }

    @Nullable
    public final AnnotationHostKind detect(@NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return (AnnotationHostKind)declaration.accept((KtVisitor)this, null);
    }

    @Nullable
    public Void visitDeclaration(@NotNull KtDeclaration declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        return null;
    }

    private final String getDeclarationName(KtDeclaration declaration) {
        String string = declaration.getName();
        if (string == null) {
            string = KotlinBaseCodeInsightBundle.message("declaration.name.anonymous", new Object[0]);
        }
        return string;
    }

    @NotNull
    public AnnotationHostKind visitClass(@NotNull KtClass declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = declaration.isInterface() ? KotlinBaseCodeInsightBundle.message("declaration.kind.interface", new Object[0]) : KotlinBaseCodeInsightBundle.message("declaration.kind.class", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), true);
    }

    @NotNull
    public AnnotationHostKind visitNamedFunction(@NotNull KtNamedFunction declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = KotlinBaseCodeInsightBundle.message("declaration.kind.fun", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), true);
    }

    @NotNull
    public AnnotationHostKind visitProperty(@NotNull KtProperty declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = declaration.isVar() ? KotlinBaseCodeInsightBundle.message("declaration.kind.var", new Object[0]) : KotlinBaseCodeInsightBundle.message("declaration.kind.val", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), true);
    }

    @NotNull
    public AnnotationHostKind visitTypeParameter(@NotNull KtTypeParameter declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = KotlinBaseCodeInsightBundle.message("declaration.kind.type.parameter", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), false);
    }

    @NotNull
    public AnnotationHostKind visitEnumEntry(@NotNull KtEnumEntry declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = KotlinBaseCodeInsightBundle.message("declaration.kind.enum.entry", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), true);
    }

    @NotNull
    public AnnotationHostKind visitParameter(@NotNull KtParameter declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = KotlinBaseCodeInsightBundle.message("declaration.kind.parameter", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), false);
    }

    @NotNull
    public AnnotationHostKind visitSecondaryConstructor(@NotNull KtSecondaryConstructor declaration, @Nullable Unit data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        String kind2 = KotlinBaseCodeInsightBundle.message("declaration.kind.secondary.constructor.of", new Object[0]);
        return new AnnotationHostKind(kind2, this.getDeclarationName((KtDeclaration)declaration), true);
    }

    @Nullable
    public AnnotationHostKind visitObjectDeclaration(@NotNull KtObjectDeclaration d, @Nullable Unit data) {
        AnnotationHostKind annotationHostKind;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        if (d.isCompanion()) {
            String kind2 = KotlinBaseCodeInsightBundle.message("declaration.kind.companion.object", new Object[0]);
            Object[] objectArray = new Object[2];
            objectArray[0] = String.valueOf(d.getName());
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)d;
            boolean $i$f$getStrictParentOfType = false;
            KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
            objectArray[1] = String.valueOf(ktClass != null ? ktClass.getName() : null);
            String name2 = KotlinBaseCodeInsightBundle.message("declaration.name.0.of.1", objectArray);
            annotationHostKind = new AnnotationHostKind(kind2, name2, true);
        } else if (d.getParent() instanceof KtObjectLiteralExpression) {
            annotationHostKind = null;
        } else {
            String kind3 = KotlinBaseCodeInsightBundle.message("declaration.kind.object", new Object[0]);
            annotationHostKind = new AnnotationHostKind(kind3, this.getDeclarationName((KtDeclaration)d), true);
        }
        return annotationHostKind;
    }
}

