/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.blockingCallsDetection;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.utils.DocumentUtilsKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.blockingCallsDetection.CoroutineBlockingCallInspectionUtils$findFlowOnCall$;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.refactoring.fqName.FqNameUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\t\u001a\u00020\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0012\u0010\f\u001a\u00020\u00052\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0018\u0010\r\u001a\u00020\u00052\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000bH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0017\u0010\u0015\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u00010\u000b*\u00020\u0016H\u0086\u0010R\u000e\u0010\u0017\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0018X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingCallInspectionUtils;", "", "<init>", "()V", "isInSuspendLambdaOrFunction", "", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "isKotlinxOnClasspath", "isInsideFlowChain", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isCalledInsideNonIoContext", "isNonBlockingDispatcher", "call", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "postProcessQuickFix", "", "replacedElement", "project", "Lcom/intellij/openapi/project/Project;", "findFlowOnCall", "Lorg/jetbrains/kotlin/psi/KtExpression;", "BLOCKING_EXECUTOR_ANNOTATION", "", "NONBLOCKING_EXECUTOR_ANNOTATION", "DISPATCHERS_FQN", "IO_DISPATCHER_FQN", "MAIN_DISPATCHER_FQN", "DEFAULT_DISPATCHER_FQN", "COROUTINE_SCOPE", "COROUTINE_CONTEXT", "FLOW_ON_FQN", "FLOW_PACKAGE_FQN", "FLOW_FQN", "WITH_CONTEXT_FQN", "COROUTINE_NAME", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nCoroutineBlockingCallInspectionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBlockingCallInspectionUtils.kt\norg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingCallInspectionUtils\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,101:1\n66#2,2:102\n66#2,2:105\n213#3:104\n213#3:107\n477#4:108\n183#4,2:109\n*S KotlinDebug\n*F\n+ 1 CoroutineBlockingCallInspectionUtils.kt\norg/jetbrains/kotlin/idea/inspections/blockingCallsDetection/CoroutineBlockingCallInspectionUtils\n*L\n33#1:102,2\n41#1:105,2\n35#1:104\n78#1:107\n82#1:108\n84#1:109,2\n*E\n"})
public final class CoroutineBlockingCallInspectionUtils {
    @NotNull
    public static final CoroutineBlockingCallInspectionUtils INSTANCE = new CoroutineBlockingCallInspectionUtils();
    @NotNull
    public static final String BLOCKING_EXECUTOR_ANNOTATION = "org.jetbrains.annotations.BlockingExecutor";
    @NotNull
    public static final String NONBLOCKING_EXECUTOR_ANNOTATION = "org.jetbrains.annotations.NonBlockingExecutor";
    @NotNull
    private static final String DISPATCHERS_FQN = "kotlinx.coroutines.Dispatchers";
    @NotNull
    public static final String IO_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.IO";
    @NotNull
    public static final String MAIN_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.Main";
    @NotNull
    public static final String DEFAULT_DISPATCHER_FQN = "kotlinx.coroutines.Dispatchers.Default";
    @NotNull
    public static final String COROUTINE_SCOPE = "kotlinx.coroutines.CoroutineScope";
    @NotNull
    public static final String COROUTINE_CONTEXT = "kotlin.coroutines.CoroutineContext";
    @NotNull
    private static final String FLOW_ON_FQN = "kotlinx.coroutines.flow.flowOn";
    @NotNull
    public static final String FLOW_PACKAGE_FQN = "kotlinx.coroutines.flow";
    @NotNull
    private static final String FLOW_FQN = "kotlinx.coroutines.flow.Flow";
    @NotNull
    public static final String WITH_CONTEXT_FQN = "kotlinx.coroutines.withContext";
    @NotNull
    public static final String COROUTINE_NAME = "kotlinx.coroutines.CoroutineName";

    private CoroutineBlockingCallInspectionUtils() {
    }

    public final boolean isInSuspendLambdaOrFunction(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)ktElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtLambdaArgument lambdaArgument = (KtLambdaArgument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLambdaArgument.class, (boolean)true);
        if (lambdaArgument != null) {
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)lambdaArgument;
            boolean $i$f$getStrictParentOfType = false;
            KtCallExpression ktCallExpression = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtCallExpression.class, (boolean)true);
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression = ktCallExpression;
            ResolvedCall<? extends CallableDescriptor> resolvedCall = ResolutionUtils.resolveToCall((KtElement)callExpression, BodyResolveMode.PARTIAL);
            if (resolvedCall == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall;
            ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument(call2, (ValueArgument)((ValueArgument)lambdaArgument));
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor parameterForArgument = valueParameterDescriptor;
            KotlinType kotlinType = parameterForArgument.getReturnType();
            return kotlinType != null ? FunctionTypesKt.isSuspendFunctionType((KotlinType)kotlinType) : false;
        }
        PsiElement $this$parentOfType_u24default$iv2 = (PsiElement)ktElement;
        boolean withSelf$iv2 = false;
        boolean $i$f$parentOfType2 = false;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv2, KtNamedFunction.class, (boolean)true);
        return ktNamedFunction != null ? ktNamedFunction.hasModifier(KtTokens.SUSPEND_KEYWORD) : false;
    }

    public final boolean isKotlinxOnClasspath(@NotNull KtElement ktElement) {
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)ktElement));
        if (module == null) {
            return false;
        }
        Module module2 = module;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithLibrariesScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        return JavaPsiFacade.getInstance((Project)module2.getProject()).findClass(DISPATCHERS_FQN, searchScope) != null;
    }

    public final boolean isInsideFlowChain(@NotNull ResolvedCall<?> resolvedCall) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor descriptor2 = callableDescriptor;
        Object object = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
        boolean isFlowGenerator = object != null && (object = object.asString()) != null ? StringsKt.startsWith$default((String)object, (String)FLOW_PACKAGE_FQN, (boolean)false, (int)2, null) : false;
        KotlinType kotlinType = UtilsKt.receiverType(descriptor2);
        return Intrinsics.areEqual((Object)(kotlinType != null && (kotlinType = FqNameUtilKt.getFqName(kotlinType)) != null ? kotlinType.asString() : null), (Object)FLOW_FQN) || UtilsKt.receiverType(descriptor2) == null && isFlowGenerator;
    }

    public final boolean isCalledInsideNonIoContext(@NotNull ResolvedCall<?> resolvedCall) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Object object = resolvedCall.getResultingDescriptor();
        if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)object))) == null || (object = object.asString()) == null) {
            return false;
        }
        Object callFqn = object;
        if (!Intrinsics.areEqual((Object)callFqn, (Object)WITH_CONTEXT_FQN)) {
            return false;
        }
        return this.isNonBlockingDispatcher(resolvedCall);
    }

    private final boolean isNonBlockingDispatcher(ResolvedCall<? extends CallableDescriptor> call2) {
        FqName fqName2;
        CallableDescriptor callableDescriptor;
        ResolvedCall resolvedCall;
        KtExpression ktExpression = CallUtilKt.getFirstArgumentExpression(call2);
        String dispatcherFqnOrNull = ktExpression != null && (resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)ktExpression, null, 1, null)) != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null && (fqName2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))) != null ? fqName2.asString() : null;
        return dispatcherFqnOrNull != null && !Intrinsics.areEqual(dispatcherFqnOrNull, (Object)IO_DISPATCHER_FQN);
    }

    public final void postProcessQuickFix(@NotNull KtElement replacedElement, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)replacedElement, (String)"replacedElement");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtFile ktFile2 = replacedElement.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile containingKtFile = ktFile2;
        PsiElement psiElement = GenericPsiUtils.reformatted$default((PsiElement)replacedElement, false, 1, null);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
        ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtElement)psiElement, null, 2, null);
        new OptimizeImportsProcessor(project, (PsiFile)containingKtFile).run();
        DocumentUtilsKt.commitAndUnblockDocument((PsiFile)containingKtFile);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ResolvedCall<? extends CallableDescriptor> findFlowOnCall(@NotNull KtExpression $this$findFlowOnCall) {
        ResolvedCall resolvedCall;
        Intrinsics.checkNotNullParameter((Object)$this$findFlowOnCall, (String)"<this>");
        CoroutineBlockingCallInspectionUtils coroutineBlockingCallInspectionUtils = this;
        while (true) {
            ResolvedCall candidate;
            Object v2;
            KtDotQualifiedExpression dotQualifiedExpression;
            block3: {
                void $this$firstOrNull$iv;
                Sequence $this$filterIsInstance$iv;
                PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$findFlowOnCall;
                boolean $i$f$getStrictParentOfType = false;
                if ((KtDotQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtDotQualifiedExpression.class, (boolean)true) == null) {
                    return null;
                }
                PsiElement[] psiElementArray = dotQualifiedExpression.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                $this$getStrictParentOfType$iv = ArraysKt.asSequence((Object[])psiElementArray);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findFlowOnCall$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = SequencesKt.mapNotNull((Sequence)sequence, CoroutineBlockingCallInspectionUtils::findFlowOnCall$lambda$0);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ResolvedCall it = (ResolvedCall)element$iv;
                    boolean bl = false;
                    if (!FunctionUtilsKt.isCalling((ResolvedCall<? extends CallableDescriptor>)it, new FqName(FLOW_ON_FQN))) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            resolvedCall = candidate = (ResolvedCall)v2;
            if (resolvedCall != null) break;
            $this$findFlowOnCall = (KtExpression)dotQualifiedExpression;
        }
        return resolvedCall;
    }

    private static final ResolvedCall findFlowOnCall$lambda$0(KtCallExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ResolutionUtils.resolveToCall((KtElement)it, BodyResolveMode.PARTIAL);
    }
}

