/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.hints.RangeKtExpressionType;
import org.jetbrains.kotlin.idea.inspections.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceIndexLoopWithCollectionLoopQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallQuickFix;
import org.jetbrains.kotlin.idea.inspections.ReplaceManualRangeWithIndicesCallsInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.util.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractRangeInspection;", "<init>", "()V", "visitRange", "", "range", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "type", "Lorg/jetbrains/kotlin/idea/codeInsight/hints/RangeKtExpressionType;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nReplaceManualRangeWithIndicesCallsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceManualRangeWithIndicesCallsInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,188:1\n123#2:189\n1#3:190\n*S KotlinDebug\n*F\n+ 1 ReplaceManualRangeWithIndicesCallsInspection.kt\norg/jetbrains/kotlin/idea/inspections/ReplaceManualRangeWithIndicesCallsInspection\n*L\n48#1:189\n*E\n"})
public final class ReplaceManualRangeWithIndicesCallsInspection
extends AbstractRangeInspection {
    public ReplaceManualRangeWithIndicesCallsInspection() {
        super(null, null, 3, null);
    }

    @Override
    public void visitRange(@NotNull KtExpression range2, @NotNull Lazy<? extends BindingContext> context, @NotNull RangeKtExpressionType type2, @NotNull ProblemsHolder holder2, @NotNull LocalInspectionToolSession session) {
        KtExpression collection;
        KtExpression sizeOrLengthCall;
        Intrinsics.checkNotNullParameter((Object)range2, (String)"range");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(range2);
        if (pair == null) {
            return;
        }
        Pair<KtExpression, KtExpression> pair2 = pair;
        KtExpression left = (KtExpression)pair2.component1();
        KtExpression right = (KtExpression)pair2.component2();
        if (left == null) {
            return;
        }
        if (right == null) {
            return;
        }
        Integer n = ReplaceManualRangeWithIndicesCallsInspectionKt.access$toIntConstant(left);
        if (n == null || n != 0) {
            return;
        }
        KtExpression ktExpression = ReplaceManualRangeWithIndicesCallsInspectionKt.access$sizeOrLengthCall(right, type2);
        if (ktExpression == null) {
            return;
        }
        KtExpression $this$safeAs$iv = sizeOrLengthCall = ktExpression;
        boolean $i$f$safeAs = false;
        KtExpression ktExpression2 = $this$safeAs$iv;
        if (!(ktExpression2 instanceof KtQualifiedExpression)) {
            ktExpression2 = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression2;
        Object object = collection = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (collection != null && !(collection instanceof KtSimpleNameExpression) && !(collection instanceof KtThisExpression)) {
            return;
        }
        KtParameter ktParameter = new KtParameter[]{Reflection.getOrCreateKotlinClass(KtContainerNode.class)};
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])CollectionUtilsKt.match((Sequence<? extends Object>)PsiUtilsKt.getParents((PsiElement)((PsiElement)range2)), ktParameter, Reflection.getOrCreateKotlinClass(KtForExpression.class));
        if (localQuickFixArray != null) {
            LocalQuickFix[] it = localQuickFixArray;
            boolean bl = false;
            KtParameter ktParameter2 = it.getLoopParameter();
            if (ktParameter2 == null || (ktParameter2 = ktParameter2.getOriginalElement()) == null) {
                return;
            }
            ktParameter = ktParameter2;
            if (ktParameter != null) {
                KtArrayAccessExpression arrayAccess;
                LocalQuickFix[] localQuickFixArray2;
                KtParameter paramElement = ktParameter;
                boolean bl2 = false;
                Iterable iterable = ReferencesSearch.search((PsiElement)paramElement).asIterable();
                Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"asIterable(...)");
                PsiReference psiReference = (PsiReference)CollectionsKt.singleOrNull((Iterable)iterable);
                Object usageElement = psiReference != null ? psiReference.getElement() : null;
                PsiElement psiElement = usageElement;
                if (psiElement != null && (psiElement = PsiUtilsKt.getParents((PsiElement)psiElement)) != null) {
                    localQuickFixArray2 = new LocalQuickFix[]{Reflection.getOrCreateKotlinClass(KtContainerNode.class)};
                    v10 = (KtArrayAccessExpression)CollectionUtilsKt.match((Sequence<? extends Object>)psiElement, localQuickFixArray2, Reflection.getOrCreateKotlinClass(KtArrayAccessExpression.class));
                } else {
                    v10 = arrayAccess = null;
                }
                if (arrayAccess != null) {
                    PsiElement arrayAccessParent;
                    KtExpression ktExpression3;
                    KtSimpleNameExpression ktSimpleNameExpression;
                    List list2 = arrayAccess.getIndexExpressions();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIndexExpressions(...)");
                    if (!(!Intrinsics.areEqual((Object)CollectionsKt.singleOrNull((List)list2), (Object)usageElement) || !Intrinsics.areEqual((Object)((ktSimpleNameExpression = (localQuickFixArray2 = arrayAccess.getArrayExpression()) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)localQuickFixArray2 : null) != null && (ktSimpleNameExpression = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ktSimpleNameExpression)) != null ? ktSimpleNameExpression.resolve() : null), (ktExpression3 = collection) != null && (ktExpression3 = ReferenceUtilsKt.getMainReference((KtElement)((KtElement)ktExpression3))) != null ? ktExpression3.resolve() : null) || (arrayAccessParent = arrayAccess.getParent()) instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)arrayAccessParent).getLeft(), (Object)arrayAccess) && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)arrayAccessParent).getOperationToken()))) {
                        localQuickFixArray2 = new LocalQuickFix[]{new ReplaceIndexLoopWithCollectionLoopQuickFix(type2)};
                        holder2.registerProblem((PsiElement)range2, KotlinBundle.message((String)"for.loop.over.indices.could.be.replaced.with.loop.over.elements", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray2);
                        return;
                    }
                }
            }
        }
        localQuickFixArray = new LocalQuickFix[]{new ReplaceManualRangeWithIndicesCallQuickFix()};
        holder2.registerProblem((PsiElement)range2, KotlinBundle.message((String)"range.could.be.replaced.with.indices.call", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
    }
}

