/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.AddExternalQuickFix;
import org.jetbrains.kotlin.idea.inspections.JavaScriptIrMigrationInspectionsKt;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/NonExternalClassifierExtendingStateOrPropsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class NonExternalClassifierExtendingStateOrPropsInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)VisitorWrappersKt.classOrObjectVisitor(arg_0 -> NonExternalClassifierExtendingStateOrPropsInspection.buildVisitor$lambda$0(holder2, arg_0));
    }

    private static final Unit buildVisitor$lambda$0(ProblemsHolder $holder, KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        if (JsPlatformKt.isJs((TargetPlatform)TargetPlatformDetectorUtils.getPlatform((KtElement)classOrObject))) {
            LocalQuickFix[] localQuickFixArray = SearchHelpersKt.getDescriptor((KtDeclaration)classOrObject);
            ClassDescriptor classDescriptor = localQuickFixArray instanceof ClassDescriptor ? (ClassDescriptor)localQuickFixArray : null;
            if (classDescriptor == null) {
                return Unit.INSTANCE;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (JavaScriptIrMigrationInspectionsKt.access$getImplementsRProps(classDescriptor2) || JavaScriptIrMigrationInspectionsKt.access$getImplementsRState(classDescriptor2)) {
                if (classOrObject instanceof KtClass) {
                    if (((KtClass)classOrObject).isInterface() && !classDescriptor2.isExternal()) {
                        PsiElement psiElement = ((KtClass)classOrObject).getNameIdentifier();
                        if (psiElement == null) {
                            return Unit.INSTANCE;
                        }
                        PsiElement nameIdentifier = psiElement;
                        localQuickFixArray = new LocalQuickFix[]{AddExternalQuickFix.INSTANCE};
                        $holder.registerProblem(nameIdentifier, KotlinBundle.message((String)"interface.should.be.external", (Object[])new Object[0]), localQuickFixArray);
                    } else {
                        PsiElement psiElement = ((KtClass)classOrObject).getClassKeyword();
                        if (psiElement == null) {
                            return Unit.INSTANCE;
                        }
                        PsiElement classKeyword = psiElement;
                        $holder.registerProblem(classKeyword, KotlinBundle.message((String)"class.should.be.external.interface", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
                if (classOrObject instanceof KtObjectDeclaration) {
                    PsiElement psiElement = ((KtObjectDeclaration)classOrObject).getObjectKeyword();
                    if (psiElement == null) {
                        return Unit.INSTANCE;
                    }
                    PsiElement objectKeyword = psiElement;
                    $holder.registerProblem(objectKeyword, KotlinBundle.message((String)"object.should.be.external.interface", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }
        }
        return Unit.INSTANCE;
    }
}

