/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.utils.PropertyModifierUtilsKt;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.MayBeConstantInspectionBase;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.MayBeConstantInspectionBaseKt;
import org.jetbrains.kotlin.idea.quickfix.AddConstModifierFix;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\f\u0010\b\u001a\u00020\t*\u00020\u0007H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MayBeConstantInspection;", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/MayBeConstantInspectionBase;", "<init>", "()V", "createAddConstModifierFix", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getConstantStatus", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/MayBeConstantInspectionBase$Status;", "Util", "kotlin.idea"})
public final class MayBeConstantInspection
extends MayBeConstantInspectionBase {
    @Override
    @NotNull
    protected AddModifierFix createAddConstModifierFix(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return new AddConstModifierFix(property);
    }

    @Override
    @NotNull
    protected MayBeConstantInspectionBase.Status getConstantStatus(@NotNull KtProperty $this$getConstantStatus) {
        Intrinsics.checkNotNullParameter((Object)$this$getConstantStatus, (String)"<this>");
        return Util.INSTANCE.getStatus($this$getConstantStatus);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MayBeConstantInspection$Util;", "", "<init>", "()V", "getStatus", "Lorg/jetbrains/kotlin/idea/codeinsights/impl/base/inspections/MayBeConstantInspectionBase$Status;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "kotlin.idea"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();

        private Util() {
        }

        @NotNull
        public final MayBeConstantInspectionBase.Status getStatus(@NotNull KtProperty $this$getStatus) {
            MayBeConstantInspectionBase.Status status;
            BindingContext context;
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$getStatus, (String)"<this>");
            if (!PropertyModifierUtilsKt.checkMayBeConstantByFields($this$getStatus)) {
                return MayBeConstantInspectionBase.Status.NONE;
            }
            KtExpression initializer2 = $this$getStatus.getInitializer();
            KtExpression ktExpression = initializer2;
            if (ktExpression == null) {
                ktExpression = (KtExpression)$this$getStatus;
            }
            VariableDescriptor variableDescriptor = (object = (context = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode((KtElement)ktExpression, BodyResolveMode.PARTIAL)).get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$getStatus)) instanceof VariableDescriptor ? (VariableDescriptor)object : null;
            if (variableDescriptor == null) {
                return MayBeConstantInspectionBase.Status.NONE;
            }
            VariableDescriptor propertyDescriptor = variableDescriptor;
            KotlinType kotlinType = propertyDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType type2 = kotlinType;
            if (!KotlinBuiltIns.isPrimitiveType((KotlinType)type2) && !KotlinBuiltIns.isString((KotlinType)type2)) {
                return MayBeConstantInspectionBase.Status.NONE;
            }
            boolean withJvmField = JvmAnnotationUtilKt.hasJvmFieldAnnotation((DeclarationDescriptor)((DeclarationDescriptor)propertyDescriptor));
            List list2 = $this$getStatus.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAnnotationEntries(...)");
            if (!((Collection)list2).isEmpty() && !withJvmField) {
                return MayBeConstantInspectionBase.Status.NONE;
            }
            if (initializer2 != null) {
                ConstantValue constantValue;
                CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(initializer2, context);
                if (compileTimeConstant == null) {
                    return MayBeConstantInspectionBase.Status.NONE;
                }
                CompileTimeConstant compileTimeConstant2 = compileTimeConstant;
                boolean erroneousConstant = compileTimeConstant2.getUsesNonConstValAsConstant();
                KotlinType kotlinType2 = propertyDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                ConstantValue it = constantValue = compileTimeConstant2.toConstantValue(kotlinType2);
                boolean bl = false;
                if ((!ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant((ConstantValue)it) && !(it instanceof NullValue) && !(it instanceof ErrorValue) ? constantValue : null) == null) {
                    return MayBeConstantInspectionBase.Status.NONE;
                }
                status = MayBeConstantInspectionBaseKt.matchStatus(withJvmField, erroneousConstant);
            } else {
                status = withJvmField ? MayBeConstantInspectionBase.Status.JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER : MayBeConstantInspectionBase.Status.NONE;
            }
            return status;
        }
    }
}

