/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ExplicitThisExpressionFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "text", "", "<init>", "(Ljava/lang/String;)V", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Companion", "kotlin.idea"})
public final class ExplicitThisExpressionFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;

    public ExplicitThisExpressionFix(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.text};
        return KotlinBundle.message((String)"explicit.this.expression.fix.family.name", (Object[])objectArray);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        KtThisExpression ktThisExpression = psiElement instanceof KtThisExpression ? (KtThisExpression)psiElement : null;
        if (ktThisExpression == null) {
            return;
        }
        KtThisExpression thisExpression = ktThisExpression;
        Companion.removeExplicitThisExpression(thisExpression);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ExplicitThisExpressionFix$Companion;", "", "<init>", "()V", "removeExplicitThisExpression", "", "thisExpression", "Lorg/jetbrains/kotlin/psi/KtThisExpression;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        public final void removeExplicitThisExpression(@NotNull KtThisExpression thisExpression) {
            Intrinsics.checkNotNullParameter((Object)thisExpression, (String)"thisExpression");
            PsiElement parent2 = thisExpression.getParent();
            if (parent2 instanceof KtDotQualifiedExpression) {
                KtExpression ktExpression = ((KtDotQualifiedExpression)parent2).getSelectorExpression();
                if (ktExpression == null) {
                    return;
                }
                ((KtDotQualifiedExpression)parent2).replace((PsiElement)ktExpression);
            } else if (parent2 instanceof KtCallableReferenceExpression) {
                thisExpression.delete();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

