/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.BackgroundUpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSinkKt;
import org.jetbrains.kotlin.idea.script.ScriptDiagnosticFixProvider;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001a\u001bB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016J$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0014\u001a\u00020\u0010*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "computeOffsets", "Lkotlin/Pair;", "", "position", "Lkotlin/script/experimental/api/SourceCode$Location;", "coerceLineIn", "offsetBy", "line", "col", "convertSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lkotlin/script/experimental/api/ScriptDiagnostic$Severity;", "Registrar", "Factory", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptExternalHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptExternalHighlightingPass.kt\norg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,117:1\n1611#2,9:118\n1863#2:127\n1863#2,2:129\n1864#2:132\n1620#2:133\n1#3:128\n1#3:131\n81#4:134\n*S KotlinDebug\n*F\n+ 1 ScriptExternalHighlightingPass.kt\norg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass\n*L\n33#1:118,9\n33#1:127\n49#1:129,2\n33#1:132\n33#1:133\n33#1:131\n94#1:134\n*E\n"})
public final class ScriptExternalHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final KtFile file;

    public ScriptExternalHighlightingPass(@NotNull KtFile file, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super(file.getProject(), document);
        this.file = file;
    }

    /*
     * WARNING - void declaration
     */
    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        Document document = this.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        if (!this.file.isScript()) {
            return;
        }
        List<ScriptDiagnostic> reports = IdeScriptReportSinkKt.getScriptReports(this.file);
        Iterable $this$mapNotNull$iv = reports;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HighlightInfo highlightInfo;
            Throwable exception;
            Pair<Integer, Integer> pair;
            ScriptDiagnostic scriptDiagnostic;
            block11: {
                block10: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    scriptDiagnostic = (ScriptDiagnostic)element$iv$iv;
                    boolean bl2 = false;
                    pair = scriptDiagnostic.getLocation();
                    if (pair == null) break block10;
                    Pair<Integer, Integer> it = pair;
                    boolean bl3 = false;
                    Pair<Integer, Integer> pair2 = this.computeOffsets(document2, (SourceCode.Location)it);
                    pair = pair2;
                    if (pair2 != null) break block11;
                }
                pair = TuplesKt.to((Object)0, (Object)0);
            }
            Pair<Integer, Integer> pair3 = pair;
            int startOffset = ((Number)pair3.component1()).intValue();
            int endOffset = ((Number)pair3.component2()).intValue();
            Throwable throwable = exception = scriptDiagnostic.getException();
            Object exceptionMessage = throwable != null ? " (" + throwable + ")" : "";
            String message2 = scriptDiagnostic.getMessage() + (String)exceptionMessage;
            if (this.convertSeverity(scriptDiagnostic.getSeverity()) == null) {
                highlightInfo = null;
            } else {
                HighlightInfo.Builder annotation;
                HighlightSeverity severity;
                Intrinsics.checkNotNullExpressionValue((Object)HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfo.convertSeverity((HighlightSeverity)severity)).range(startOffset, endOffset).descriptionAndTooltip(message2), (String)"descriptionAndTooltip(...)");
                if (startOffset == endOffset) {
                    annotation.fileLevelAnnotation();
                }
                for (ScriptDiagnosticFixProvider provider : ScriptDiagnosticFixProvider.Companion.getEP_NAME().getExtensionList()) {
                    Iterable $this$forEach$iv = provider.provideFixes(scriptDiagnostic);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IntentionAction it = (IntentionAction)element$iv;
                        boolean bl = false;
                        annotation.registerFix(it, null, null, null, null);
                    }
                }
                highlightInfo = annotation.create();
            }
            if (highlightInfo == null) continue;
            HighlightInfo it$iv$iv = highlightInfo;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List infos = (List)destination$iv$iv;
        BackgroundUpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (PsiFile)((PsiFile)this.file), (Document)this.myDocument, (int)0, (int)this.file.getTextLength(), (Collection)infos, (int)this.getId());
    }

    public void doApplyInformationToEditor() {
    }

    private final Pair<Integer, Integer> computeOffsets(Document document, SourceCode.Location position) {
        int n;
        int n2;
        Integer n3 = position.getStart().getAbsolutePos();
        if (n3 != null) {
            n2 = n3;
        } else {
            ScriptExternalHighlightingPass $this$computeOffsets_u24lambda_u243 = this;
            boolean bl = false;
            int startLine = $this$computeOffsets_u24lambda_u243.coerceLineIn(position.getStart().getLine(), document);
            n2 = $this$computeOffsets_u24lambda_u243.offsetBy(document, startLine, position.getStart().getCol());
        }
        int startOffset = n2;
        Serializable serializable = position.getEnd();
        if (serializable != null && (serializable = ((SourceCode.Position)serializable).getAbsolutePos()) != null) {
            n = (Integer)serializable;
        } else {
            int n4;
            ScriptExternalHighlightingPass $this$computeOffsets_u24lambda_u244 = this;
            boolean bl = false;
            int startLine = $this$computeOffsets_u24lambda_u244.coerceLineIn(position.getStart().getLine(), document);
            SourceCode.Position position2 = position.getEnd();
            if (position2 != null) {
                int n5 = RangesKt.coerceAtLeast((int)position2.getLine(), (int)startLine);
                n4 = $this$computeOffsets_u24lambda_u244.coerceLineIn(n5, document);
            } else {
                n4 = startLine;
            }
            int endLine = n4;
            SourceCode.Position position3 = position.getEnd();
            n = RangesKt.coerceAtLeast((int)$this$computeOffsets_u24lambda_u244.offsetBy(document, endLine, position3 != null ? position3.getCol() : document.getLineEndOffset(endLine)), (int)startOffset);
        }
        int endOffset = n;
        return TuplesKt.to((Object)startOffset, (Object)endOffset);
    }

    private final int coerceLineIn(int $this$coerceLineIn, Document document) {
        return RangesKt.coerceIn((int)$this$coerceLineIn, (int)0, (int)(document.getLineCount() - 1));
    }

    private final int offsetBy(Document $this$offsetBy, int line, int col) {
        return RangesKt.coerceIn((int)($this$offsetBy.getLineStartOffset(line) + col), (int)$this$offsetBy.getLineStartOffset(line), (int)$this$offsetBy.getLineEndOffset(line));
    }

    private final HighlightSeverity convertSeverity(ScriptDiagnostic.Severity $this$convertSeverity) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$convertSeverity.ordinal()]) {
            case 1 -> HighlightSeverity.ERROR;
            case 2 -> HighlightSeverity.ERROR;
            case 3 -> HighlightSeverity.WARNING;
            case 4 -> HighlightSeverity.INFORMATION;
            case 5 -> {
                boolean $i$f$isApplicationInternalMode = false;
                if (ApplicationManager.getApplication().isInternal()) {
                    yield HighlightSeverity.INFORMATION;
                }
                yield null;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "<init>", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "kotlin.base.scripting"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile psiFile, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!(psiFile instanceof KtFile)) {
                return null;
            }
            KtFile ktFile2 = (KtFile)psiFile;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            return new ScriptExternalHighlightingPass(ktFile2, document);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "<init>", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.scripting"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)registrar2, (String)"registrar");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            registrar2.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 1, false, false);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

