/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.highlighter.KotlinRecursiveCallLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.idea.inspections.RecursivePropertyAccessorInspection;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0016\u0010\u0011\u001a\u0012\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012j\u0002`\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0017H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRecursiveCallLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getLineMarkerInfo", "", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lorg/jetbrains/kotlin/idea/highlighter/markers/LineMarkerInfos;", "getEnclosingFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lorg/jetbrains/kotlin/psi/KtElement;", "stopOnNonInlinedLambdas", "", "isRecursiveCall", "RecursiveMethodCallMarkerInfo", "kotlin.idea"})
public final class KotlinRecursiveCallLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return KotlinBundle.message((String)"highlighter.tool.tip.text.recursive.call", (Object[])new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = AllIcons.Gutter.RecursiveMethod;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"RecursiveMethod");
        return icon2;
    }

    @Nullable
    public Void getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (!KotlinLineMarkerOptions.INSTANCE.getRecursiveOption().isEnabled()) {
            return;
        }
        HashSet<Integer> markedLineNumbers = new HashSet<Integer>();
        Iterator<? extends PsiElement> iterator = elements.iterator();
        while (iterator.hasNext()) {
            int lineNumber;
            PsiElement element;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            ProgressManager.checkCanceled();
            if (!(element instanceof KtElement) || markedLineNumbers.contains(lineNumber = KotlinRecursiveCallLineMarkerProviderKt.access$getLineNumber(element)) || !this.isRecursiveCall((KtElement)element)) continue;
            markedLineNumbers.add(lineNumber);
            result2.add(new RecursiveMethodCallMarkerInfo(KotlinRecursiveCallLineMarkerProviderKt.getElementForLineMark(element)));
        }
    }

    private final KtNamedFunction getEnclosingFunction(KtElement element, boolean stopOnNonInlinedLambdas) {
        for (Object e : PsiUtilsKt.getParents((PsiElement)((PsiElement)element))) {
            PsiElement parent2;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PsiElement psiElement = parent2 = (PsiElement)e;
            if (psiElement instanceof KtFunctionLiteral) {
                if (!stopOnNonInlinedLambdas || InlineUtil.isInlinedArgument((KtFunction)((KtFunction)parent2), (BindingContext)ResolutionUtils.analyze$default((KtElement)parent2, null, 1, null), (boolean)false)) continue;
                return null;
            }
            if (psiElement instanceof KtNamedFunction) {
                PsiElement psiElement2 = ((KtNamedFunction)parent2).getParent();
                if (psiElement2 instanceof KtBlockExpression || psiElement2 instanceof KtClassBody || psiElement2 instanceof KtFile || psiElement2 instanceof KtScript) {
                    return (KtNamedFunction)parent2;
                }
                if (!stopOnNonInlinedLambdas || InlineUtil.isInlinedArgument((KtFunction)((KtFunction)parent2), (BindingContext)ResolutionUtils.analyze$default((KtElement)parent2, null, 1, null), (boolean)false)) continue;
                return null;
            }
            if (!(psiElement instanceof KtClassOrObject)) continue;
            return null;
        }
        return null;
    }

    private final boolean isRecursiveCall(KtElement element) {
        if (RecursivePropertyAccessorInspection.Companion.isRecursivePropertyAccess(element, true)) {
            return true;
        }
        if (RecursivePropertyAccessorInspection.Companion.isRecursiveSyntheticPropertyAccess(element)) {
            return true;
        }
        Name name2 = KotlinRecursiveCallLineMarkerProviderKt.access$getCallNameFromPsi(element);
        if (name2 == null) {
            return false;
        }
        Name resolveName = name2;
        KtNamedFunction ktNamedFunction = this.getEnclosingFunction(element, false);
        if (ktNamedFunction == null) {
            return false;
        }
        KtNamedFunction enclosingFunction = ktNamedFunction;
        String enclosingFunctionName = enclosingFunction.getName();
        if (!Intrinsics.areEqual((Object)enclosingFunctionName, (Object)OperatorNameConventions.INVOKE.asString()) && !Intrinsics.areEqual((Object)enclosingFunctionName, (Object)resolveName.asString())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)enclosingFunction, (Object)this.getEnclosingFunction(element, true))) {
            return false;
        }
        BindingContext bindingContext = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default(element, null, 1, null);
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)bindingContext.get((ReadOnlySlice)BindingContext.FUNCTION, (Object)enclosingFunction);
        if (simpleFunctionDescriptor == null) {
            return false;
        }
        SimpleFunctionDescriptor enclosingFunctionDescriptor = simpleFunctionDescriptor;
        Call call2 = (Call)bindingContext.get((ReadOnlySlice)BindingContext.CALL, (Object)element);
        if (call2 == null) {
            return false;
        }
        Call call3 = call2;
        ResolvedCall resolvedCall = (ResolvedCall)bindingContext.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call3);
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        if (!Intrinsics.areEqual((Object)resolvedCall2.getCandidateDescriptor().getOriginal(), (Object)enclosingFunctionDescriptor)) {
            return false;
        }
        return !KotlinRecursiveCallLineMarkerProvider.isRecursiveCall$isDifferentReceiver(bindingContext, enclosingFunctionDescriptor, (Receiver)resolvedCall2.getDispatchReceiver());
    }

    private static final boolean isRecursiveCall$isDifferentReceiver(BindingContext bindingContext, SimpleFunctionDescriptor enclosingFunctionDescriptor, Receiver receiver2) {
        boolean bl;
        if (!(receiver2 instanceof ReceiverValue)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ExtensionUtils.getReceiverTargetDescriptor((ReceiverValue)receiver2, bindingContext);
        if (declarationDescriptor == null) {
            return true;
        }
        DeclarationDescriptor receiverOwner = declarationDescriptor;
        DeclarationDescriptor declarationDescriptor2 = receiverOwner;
        if (declarationDescriptor2 instanceof SimpleFunctionDescriptor) {
            bl = !Intrinsics.areEqual((Object)receiverOwner, (Object)enclosingFunctionDescriptor);
        } else if (declarationDescriptor2 instanceof ClassDescriptor) {
            bl = !Intrinsics.areEqual((Object)receiverOwner, (Object)enclosingFunctionDescriptor.getContainingDeclaration());
        } else if (declarationDescriptor2 instanceof PropertyDescriptor) {
            bl = !Intrinsics.areEqual((Object)((PropertyDescriptor)receiverOwner).getContainingDeclaration(), (Object)enclosingFunctionDescriptor.getContainingDeclaration());
        } else {
            return true;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/KotlinRecursiveCallLineMarkerProvider$RecursiveMethodCallMarkerInfo;", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "callElement", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "createGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "kotlin.idea"})
    private static final class RecursiveMethodCallMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        public RecursiveMethodCallMarkerInfo(@NotNull PsiElement callElement) {
            Intrinsics.checkNotNullParameter((Object)callElement, (String)"callElement");
            super(callElement, callElement.getTextRange(), AllIcons.Gutter.RecursiveMethod, arg_0 -> RecursiveMethodCallMarkerInfo._init_$lambda$1(RecursiveMethodCallMarkerInfo::_init_$lambda$0, arg_0), null, GutterIconRenderer.Alignment.RIGHT, RecursiveMethodCallMarkerInfo::_init_$lambda$2);
        }

        @NotNull
        public GutterIconRenderer createGutterRenderer() {
            return (GutterIconRenderer)new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>(this){

                public Void getClickAction() {
                    return null;
                }
            };
        }

        private static final String _init_$lambda$0(PsiElement it) {
            return KotlinBundle.message((String)"highlighter.tool.tip.text.recursive.call", (Object[])new Object[0]);
        }

        private static final String _init_$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String _init_$lambda$2() {
            return KotlinBundle.message((String)"highlighter.tool.tip.text.recursive.call", (Object[])new Object[0]);
        }
    }
}

