/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.settings;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.scripting.settings.KotlinStandaloneScriptsModel;
import org.jetbrains.kotlin.idea.gradle.scripting.settings.StandaloneScriptsStorage;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.StandaloneScriptsUpdater;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/settings/StandaloneScriptsUIComponent;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "fileChooser", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "panel", "Ljavax/swing/JComponent;", "scriptsFromStorage", "", "", "scriptsInTable", "", "table", "Lcom/intellij/ui/table/JBTable;", "model", "Lorg/jetbrains/kotlin/idea/gradle/scripting/settings/KotlinStandaloneScriptsModel;", "reset", "", "apply", "createComponent", "isModified", "", "disposeUIResources", "addScripts", "removeScripts", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nStandaloneScriptsUIComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandaloneScriptsUIComponent.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/settings/StandaloneScriptsUIComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n827#2:120\n855#2,2:121\n1863#2,2:123\n827#2:125\n855#2,2:126\n1863#2,2:128\n*S KotlinDebug\n*F\n+ 1 StandaloneScriptsUIComponent.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/settings/StandaloneScriptsUIComponent\n*L\n63#1:120\n63#1:121,2\n64#1:123,2\n67#1:125\n67#1:126,2\n68#1:128,2\n*E\n"})
public final class StandaloneScriptsUIComponent
implements UnnamedConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final FileChooserDescriptor fileChooser;
    @Nullable
    private JComponent panel;
    @NotNull
    private final List<String> scriptsFromStorage;
    @NotNull
    private final List<String> scriptsInTable;
    @NotNull
    private final JBTable table;
    @NotNull
    private final KotlinStandaloneScriptsModel model;

    public StandaloneScriptsUIComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fileChooser = new FileChooserDescriptor(this){
            final /* synthetic */ StandaloneScriptsUIComponent this$0;
            {
                this.this$0 = $receiver;
                super(true, false, false, false, false, true);
            }

            public boolean isFileSelectable(VirtualFile file) {
                GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot;
                GradleBuildRootsManager rootsManager;
                if (file == null) {
                    return false;
                }
                GradleBuildRootsManager gradleBuildRootsManager = rootsManager = GradleBuildRootsManager.Companion.getInstance(this.this$0.getProject());
                GradleBuildRootsLocator.ScriptUnderRoot scriptUnderRoot2 = scriptUnderRoot = gradleBuildRootsManager != null ? gradleBuildRootsManager.findScriptBuildRoot(file) : null;
                GradleBuildRootsLocator.NotificationKind notificationKind = scriptUnderRoot2 != null ? scriptUnderRoot2.getNotificationKind() : null;
                return notificationKind == GradleBuildRootsLocator.NotificationKind.legacyOutside || notificationKind == GradleBuildRootsLocator.NotificationKind.notEvaluatedInLastImport;
            }
        };
        Object object = StandaloneScriptsStorage.Companion.getInstance(this.project);
        if (object == null || (object = ((StandaloneScriptsStorage)object).getFiles()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        this.scriptsFromStorage = object;
        this.scriptsInTable = CollectionsKt.toMutableList((Collection)this.scriptsFromStorage);
        this.model = KotlinStandaloneScriptsModel.Companion.createModel((Collection<String>)this.scriptsInTable);
        this.table = (JBTable)new TableView((ListTableModel)this.model);
        ((TableView)this.table).setPreferredScrollableViewportSize((Dimension)JBUI.size((int)300, (int)-1));
        ((TableView)this.table).getSelectionModel().setSelectionMode(2);
        this.model.addTableModelListener((TableModelListener)this.table);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void reset() {
        this.scriptsInTable.clear();
        this.scriptsInTable.addAll((Collection<String>)this.scriptsFromStorage);
        this.model.setItems(this.scriptsInTable);
    }

    public void apply() {
        block0: {
            GradleBuildRootsManager gradleBuildRootsManager = GradleBuildRootsManager.Companion.getInstance(this.project);
            if (gradleBuildRootsManager == null) break block0;
            gradleBuildRootsManager.updateStandaloneScripts((Function1<? super StandaloneScriptsUpdater, Unit>)((Function1)arg_0 -> StandaloneScriptsUIComponent.apply$lambda$4(this, arg_0)));
        }
    }

    @Nullable
    public JComponent createComponent() {
        if (this.panel == null) {
            JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)this.table)).setAddAction(arg_0 -> StandaloneScriptsUIComponent.createComponent$lambda$5(this, arg_0)).setRemoveAction(arg_0 -> StandaloneScriptsUIComponent.createComponent$lambda$6(this, arg_0)).setRemoveActionUpdater(arg_0 -> StandaloneScriptsUIComponent.createComponent$lambda$7(this, arg_0)).disableUpDownActions().createPanel();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
            JPanel component = jPanel;
            this.panel = component;
        }
        return this.panel;
    }

    public boolean isModified() {
        return !Intrinsics.areEqual(this.scriptsFromStorage, this.scriptsInTable);
    }

    public void disposeUIResources() {
        this.panel = null;
    }

    private final void addScripts() {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)this.fileChooser, (Project)this.project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        for (VirtualFile chosenFile : virtualFileArray) {
            String path2;
            Intrinsics.checkNotNullExpressionValue((Object)chosenFile.getPath(), (String)"getPath(...)");
            if (this.scriptsInTable.contains(path2)) continue;
            this.scriptsInTable.add(path2);
            this.model.addRow(path2);
        }
    }

    private final void removeScripts() {
        int[] selected = this.table.getSelectedRows();
        if (selected == null || selected.length == 0) {
            return;
        }
        int n = selected.length;
        for (int j = 0; j < n; ++j) {
            int removedCount = j;
            int indexToRemove = selected[j];
            int row = indexToRemove - removedCount;
            this.scriptsInTable.remove(row);
            this.model.removeRow(row);
        }
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> StandaloneScriptsUIComponent.removeScripts$lambda$8(this));
    }

    private static final Unit apply$lambda$4(StandaloneScriptsUIComponent this$0, StandaloneScriptsUpdater $this$updateStandaloneScripts) {
        String it;
        Object element$iv$iv;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$updateStandaloneScripts, (String)"$this$updateStandaloneScripts");
        List<String> previousScripts = this$0.scriptsFromStorage;
        Iterable $this$filterNot$iv = this$0.scriptsInTable;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (String)element$iv$iv;
            boolean bl = false;
            if (previousScripts.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            $this$updateStandaloneScripts.addStandaloneScript(it2);
        }
        $this$filterNot$iv = previousScripts;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        Iterator bl = $this$filterNotTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (String)element$iv$iv;
            boolean bl2 = false;
            if (this$0.scriptsInTable.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$forEach$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it3 = (String)element$iv;
            boolean bl3 = false;
            $this$updateStandaloneScripts.removeStandaloneScript(it3);
        }
        return Unit.INSTANCE;
    }

    private static final void createComponent$lambda$5(StandaloneScriptsUIComponent this$0, AnActionButton it) {
        this$0.addScripts();
    }

    private static final void createComponent$lambda$6(StandaloneScriptsUIComponent this$0, AnActionButton it) {
        this$0.removeScripts();
    }

    private static final boolean createComponent$lambda$7(StandaloneScriptsUIComponent this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.table.getSelectedRow() >= 0;
    }

    private static final void removeScripts$lambda$8(StandaloneScriptsUIComponent this$0) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this$0.table, true);
    }
}

