/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.plugin.KotlinPluginModeProvider;
import org.jetbrains.kotlin.idea.core.script.k2.ScriptConfigurationWithSdk;
import org.jetbrains.kotlin.idea.core.script.k2.ScriptConfigurationsProviderImpl;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootIndex;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleScriptInfo;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Imported;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.Legacy;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.New;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0002'(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH&J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\rJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH&J\u0014\u0010#\u001a\b\u0018\u00010$R\u00020\u00002\u0006\u0010%\u001a\u00020\u0014J\u001e\u0010#\u001a\b\u0018\u00010$R\u00020\u00002\u0006\u0010\u001c\u001a\u00020\r2\b\b\u0002\u0010&\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\f\u001a\f0\r\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u0016*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "roots", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;", "getRoots", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;", "getScriptInfo", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;", "localPath", "", "getAllRoots", "", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "getBuildRootByWorkingDir", "gradleWorkingDir", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NonNls;", "Lorg/jetbrains/annotations/NotNull;", "getLocalPath", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "gradleWrapperEnding", "maybeAffectedGradleProjectFile", "", "filePath", "isAffectedGradleProjectFile", "findAffectedFileRoot", "findGradleWrapperPropertiesBuildDir", "getScriptFirstSeenTs", "", "path", "findScriptBuildRoot", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "gradleKtsFile", "searchNearestLegacy", "NotificationKind", "ScriptUnderRoot", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nGradleBuildRootsLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootsLocator.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public abstract class GradleBuildRootsLocator {
    @NotNull
    private final Project project;
    @NotNull
    private final GradleBuildRootIndex roots;
    @NotNull
    private final String gradleWrapperEnding;

    public GradleBuildRootsLocator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.roots = new GradleBuildRootIndex(this.project);
        this.gradleWrapperEnding = "/gradle/wrapper/gradle-wrapper.properties";
    }

    @NotNull
    protected final GradleBuildRootIndex getRoots() {
        return this.roots;
    }

    @Nullable
    public abstract GradleScriptInfo getScriptInfo(@NotNull String var1);

    @NotNull
    public final Collection<GradleBuildRoot> getAllRoots() {
        return this.roots.getList();
    }

    @Nullable
    public final GradleBuildRoot getBuildRootByWorkingDir(@NotNull String gradleWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)gradleWorkingDir, (String)"gradleWorkingDir");
        return this.roots.getBuildByRootDir(gradleWorkingDir);
    }

    @Nullable
    public final GradleScriptInfo getScriptInfo(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.getScriptInfo(this.getLocalPath(file));
    }

    private final String getLocalPath(VirtualFile $this$localPath) {
        String string = $this$localPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    public final boolean maybeAffectedGradleProjectFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/gradle.local", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null);
    }

    public final boolean isAffectedGradleProjectFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.findAffectedFileRoot(filePath) != null || this.roots.isStandaloneScript(filePath);
    }

    @Nullable
    public final GradleBuildRoot findAffectedFileRoot(@NotNull String filePath) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                if (StringsKt.endsWith$default((String)filePath, (String)"/gradle.properties", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/gradle.local", (boolean)false, (int)2, null)) {
                    return this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null));
                }
                object = this.findGradleWrapperPropertiesBuildDir(filePath);
                if (object == null) break block4;
                String it = object;
                boolean bl = false;
                GradleBuildRoot gradleBuildRoot = this.roots.getBuildByRootDir(it);
                object = gradleBuildRoot;
                if (gradleBuildRoot != null) break block5;
            }
            ScriptUnderRoot scriptUnderRoot = this.findScriptBuildRoot(filePath, false);
            object = scriptUnderRoot != null ? scriptUnderRoot.getRoot() : null;
        }
        return object;
    }

    @Nullable
    public final String findGradleWrapperPropertiesBuildDir(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (StringsKt.endsWith$default((String)filePath, (String)this.gradleWrapperEnding, (boolean)false, (int)2, null)) {
            String string = filePath.substring(0, filePath.length() - this.gradleWrapperEnding.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return null;
    }

    public abstract long getScriptFirstSeenTs(@NotNull String var1);

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull VirtualFile gradleKtsFile) {
        Intrinsics.checkNotNullParameter((Object)gradleKtsFile, (String)"gradleKtsFile");
        String string = gradleKtsFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return GradleBuildRootsLocator.findScriptBuildRoot$default(this, string, false, 2, null);
    }

    @Nullable
    public final ScriptUnderRoot findScriptBuildRoot(@NotNull String filePath, boolean searchNearestLegacy) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.project.isDisposed()) {
            return null;
        }
        if (!StringsKt.endsWith$default((String)filePath, (String)".gradle.kts", (boolean)false, (int)2, null)) {
            return null;
        }
        GradleScriptInfo scriptInfo = this.getScriptInfo(filePath);
        if (scriptInfo != null && (gradleBuildRoot = scriptInfo.getBuildRoot()) != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath, it, scriptInfo, false, null, 24, null);
        }
        gradleBuildRoot = this.roots.getStandaloneScriptRoot(filePath);
        if (gradleBuildRoot != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath, it, null, true, null, 20, null);
        }
        if ((StringsKt.endsWith$default((String)filePath, (String)"/build.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/settings.gradle.kts", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)filePath, (String)"/init.gradle.kts", (boolean)false, (int)2, null)) && (gradleBuildRoot = this.roots.getBuildByProjectDir(StringsKt.substringBeforeLast$default((String)filePath, (String)"/", null, (int)2, null))) != null) {
            GradleBuildRoot it = gradleBuildRoot;
            boolean bl = false;
            return new ScriptUnderRoot(this, filePath, it, null, false, null, 28, null);
        }
        GradleBuildRoot nearest = searchNearestLegacy ? this.roots.findNearestRoot(filePath) : null;
        return new ScriptUnderRoot(this, filePath, null, null, false, nearest, 12, null);
    }

    public static /* synthetic */ ScriptUnderRoot findScriptBuildRoot$default(GradleBuildRootsLocator gradleBuildRootsLocator, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findScriptBuildRoot");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return gradleBuildRootsLocator.findScriptBuildRoot(string, bl);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$NotificationKind;", "", "<init>", "(Ljava/lang/String;I)V", "dontCare", "legacy", "legacyOutside", "outsideAnything", "wasNotImportedAfterCreation", "notEvaluatedInLastImport", "standalone", "standaloneLegacy", "kotlin.gradle.gradle-java"})
    public static final class NotificationKind
    extends Enum<NotificationKind> {
        public static final /* enum */ NotificationKind dontCare = new NotificationKind();
        public static final /* enum */ NotificationKind legacy = new NotificationKind();
        public static final /* enum */ NotificationKind legacyOutside = new NotificationKind();
        public static final /* enum */ NotificationKind outsideAnything = new NotificationKind();
        public static final /* enum */ NotificationKind wasNotImportedAfterCreation = new NotificationKind();
        public static final /* enum */ NotificationKind notEvaluatedInLastImport = new NotificationKind();
        public static final /* enum */ NotificationKind standalone = new NotificationKind();
        public static final /* enum */ NotificationKind standaloneLegacy = new NotificationKind();
        private static final /* synthetic */ NotificationKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NotificationKind[] values() {
            return (NotificationKind[])$VALUES.clone();
        }

        public static NotificationKind valueOf(String value) {
            return Enum.valueOf(NotificationKind.class, value);
        }

        @NotNull
        public static EnumEntries<NotificationKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = notificationKindArray = new NotificationKind[]{NotificationKind.dontCare, NotificationKind.legacy, NotificationKind.legacyOutside, NotificationKind.outsideAnything, NotificationKind.wasNotImportedAfterCreation, NotificationKind.notEvaluatedInLastImport, NotificationKind.standalone, NotificationKind.standaloneLegacy};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001f\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014R\u0014\u0010\u001c\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0014R\u0014\u0010\u001d\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$ScriptUnderRoot;", "", "filePath", "", "root", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "script", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;", "standalone", "", "nearest", "<init>", "(Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;ZLorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;)V", "getFilePath", "()Ljava/lang/String;", "getRoot", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "getScript", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleScriptInfo;", "getStandalone", "()Z", "getNearest", "notificationKind", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$NotificationKind;", "getNotificationKind", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootsLocator$NotificationKind;", "importing", "getImporting", "isImported", "wasImportedAndNotEvaluated", "getWasImportedAndNotEvaluated", "toString", "kotlin.gradle.gradle-java"})
    public final class ScriptUnderRoot {
        @NotNull
        private final String filePath;
        @Nullable
        private final GradleBuildRoot root;
        @Nullable
        private final GradleScriptInfo script;
        private final boolean standalone;
        @Nullable
        private final GradleBuildRoot nearest;
        final /* synthetic */ GradleBuildRootsLocator this$0;

        public ScriptUnderRoot(@NotNull GradleBuildRootsLocator this$0, @Nullable String filePath, @Nullable GradleBuildRoot root, GradleScriptInfo script, @Nullable boolean standalone, GradleBuildRoot nearest) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.this$0 = this$0;
            this.filePath = filePath;
            this.root = root;
            this.script = script;
            this.standalone = standalone;
            this.nearest = nearest;
        }

        public /* synthetic */ ScriptUnderRoot(GradleBuildRootsLocator gradleBuildRootsLocator, String string, GradleBuildRoot gradleBuildRoot, GradleScriptInfo gradleScriptInfo, boolean bl, GradleBuildRoot gradleBuildRoot2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                gradleScriptInfo = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                gradleBuildRoot2 = gradleBuildRoot;
            }
            this(gradleBuildRootsLocator, string, gradleBuildRoot, gradleScriptInfo, bl, gradleBuildRoot2);
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @Nullable
        public final GradleBuildRoot getRoot() {
            return this.root;
        }

        @Nullable
        public final GradleScriptInfo getScript() {
            return this.script;
        }

        public final boolean getStandalone() {
            return this.standalone;
        }

        @Nullable
        public final GradleBuildRoot getNearest() {
            return this.nearest;
        }

        @NotNull
        public final NotificationKind getNotificationKind() {
            NotificationKind notificationKind;
            if (this.isImported()) {
                notificationKind = NotificationKind.dontCare;
            } else if (this.standalone) {
                notificationKind = this.nearest instanceof Legacy ? NotificationKind.standaloneLegacy : NotificationKind.standalone;
            } else if (this.nearest == null) {
                notificationKind = NotificationKind.outsideAnything;
            } else if (this.getImporting()) {
                notificationKind = NotificationKind.dontCare;
            } else {
                GradleBuildRoot gradleBuildRoot = this.nearest;
                if (gradleBuildRoot instanceof Legacy) {
                    notificationKind = this.root == null ? NotificationKind.legacyOutside : NotificationKind.legacy;
                } else if (gradleBuildRoot instanceof New) {
                    notificationKind = NotificationKind.wasNotImportedAfterCreation;
                } else if (gradleBuildRoot instanceof Imported) {
                    notificationKind = this.getWasImportedAndNotEvaluated() ? NotificationKind.notEvaluatedInLastImport : NotificationKind.wasNotImportedAfterCreation;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return notificationKind;
        }

        private final boolean getImporting() {
            return this.nearest != null && this.nearest.isImportingInProgress();
        }

        private final boolean isImported() {
            if (KotlinPluginModeProvider.Companion.isK2Mode()) {
                ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
                ScriptConfigurationWithSdk scriptConfigurationWithSdk;
                VirtualFileSystem virtualFileSystem = StandardFileSystems.local();
                if (virtualFileSystem == null || (virtualFileSystem = virtualFileSystem.refreshAndFindFileByPath(this.filePath)) == null) {
                    return false;
                }
                VirtualFileSystem virtualFile = virtualFileSystem;
                ScriptConfigurationsProviderImpl scriptConfigurationsProviderImpl = ScriptConfigurationsProviderImpl.Companion.getInstanceIfCreated(this.this$0.project);
                return (scriptConfigurationsProviderImpl != null && (scriptConfigurationWithSdk = scriptConfigurationsProviderImpl.getConfigurationWithSdk((VirtualFile)virtualFile)) != null && (resultWithDiagnostics = scriptConfigurationWithSdk.getScriptConfiguration()) != null ? ErrorHandlingKt.valueOrNull(resultWithDiagnostics) : null) != null;
            }
            return this.script != null;
        }

        private final boolean getWasImportedAndNotEvaluated() {
            if (KotlinPluginModeProvider.Companion.isK2Mode()) {
                return false;
            }
            return this.nearest instanceof Imported && this.this$0.getScriptFirstSeenTs(this.filePath) < ((Imported)this.nearest).getData().getImportTs();
        }

        @NotNull
        public String toString() {
            return "ScriptUnderRoot(root=" + this.root + ", script=" + this.script + ", standalone=" + this.standalone + ", nearest=" + this.nearest + ")";
        }
    }
}

