/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleJava.scripting.GradleKotlinScriptConfigurationInputs;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsLocator;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRootsManager;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0002\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\n\u001a\u00020\u000b\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"sections", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "isGradleKotlinScript", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getGradleScriptInputsStamp", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/GradleKotlinScriptConfigurationInputs;", "project", "Lcom/intellij/openapi/project/Project;", "file", "givenKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "givenTimeStamp", "", "minimal_gradle_version_supported", "kotlinDslScriptsModelImportSupported", "gradleVersion", "getGradleProjectSettings", "", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "kotlin.gradle.gradle-java"})
@SourceDebugExtension(value={"SMAP\nutils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/UtilsKt\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,73:1\n229#2:74\n13402#3,2:75\n*S KotlinDebug\n*F\n+ 1 utils.kt\norg/jetbrains/kotlin/idea/gradleJava/scripting/UtilsKt\n*L\n39#1:74\n40#1:75,2\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final ArrayList<String> sections;
    @NotNull
    public static final String minimal_gradle_version_supported = "6.0";

    public static final boolean isGradleKotlinScript(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        CharSequence charSequence = virtualFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        return StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".gradle.kts", (boolean)false, (int)2, null);
    }

    @Nullable
    public static final GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp(@NotNull Project project, @NotNull VirtualFile file, @Nullable KtFile givenKtFile, long givenTimeStamp) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!UtilsKt.isGradleKotlinScript(file)) {
            return null;
        }
        return (GradleKotlinScriptConfigurationInputs)ActionsKt.runReadAction(() -> UtilsKt.getGradleScriptInputsStamp$lambda$1(givenKtFile, project, file, givenTimeStamp));
    }

    public static /* synthetic */ GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp$default(Project project, VirtualFile virtualFile, KtFile ktFile2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            ktFile2 = null;
        }
        if ((n & 8) != 0) {
            l = virtualFile.getModificationStamp();
        }
        return UtilsKt.getGradleScriptInputsStamp(project, virtualFile, ktFile2, l);
    }

    public static final boolean kotlinDslScriptsModelImportSupported(@NotNull String gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        return GradleVersionUtil.isGradleAtLeast((String)gradleVersion, (String)minimal_gradle_version_supported);
    }

    @NotNull
    public static final Collection<GradleProjectSettings> getGradleProjectSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)abstractExternalSystemSettings, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gradle.settings.GradleSettings");
        Collection collection = ((GradleSettings)abstractExternalSystemSettings).getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getLinkedProjectsSettings(...)");
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    private static final GradleKotlinScriptConfigurationInputs getGradleScriptInputsStamp$lambda$1(KtFile $givenKtFile, Project $project, VirtualFile $file, long $givenTimeStamp) {
        Object object;
        KtBlockExpression ktBlockExpression;
        PsiFile psiFile;
        KtFile ktFile2 = $givenKtFile;
        if (ktFile2 == null && (ktFile2 = (psiFile = PsiManager.getInstance((Project)$project).findFile($file)) instanceof KtFile ? (KtFile)psiFile : null) == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        StringBuilder result2 = new StringBuilder();
        psiFile = ktFile3.getScript();
        if (psiFile != null && (ktBlockExpression = psiFile.getBlockExpression()) != null) {
            KtScriptInitializer[] ktScriptInitializerArray;
            KtScriptInitializer[] $this$getChildrenOfType$iv;
            PsiElement psiElement = (PsiElement)ktBlockExpression;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtScriptInitializer.class);
            if (psiElementArray == null) {
                psiElementArray = (PsiElement[])new KtScriptInitializer[0];
            }
            if ((ktScriptInitializerArray = (KtScriptInitializer[])psiElementArray) != null) {
                void $this$forEach$iv;
                $this$getChildrenOfType$iv = ktScriptInitializerArray;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    PsiElement[] psiElementArray2 = it.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getChildren(...)");
                    Object object2 = ArraysKt.singleOrNull((Object[])psiElementArray2);
                    KtCallExpression call2 = object2 instanceof KtCallExpression ? (KtCallExpression)object2 : null;
                    Object object3 = call2;
                    if (object3 != null && (object3 = object3.getFirstChild()) != null) {
                        KtLambdaArgument lambda2;
                        Object callRef;
                        if ((object3 = object3.getText()) == null || !sections.contains(callRef = object3)) continue;
                        result2.append((String)callRef);
                        List list2 = call2.getLambdaArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getLambdaArguments(...)");
                        KtLambdaArgument ktLambdaArgument = lambda2 = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
                        if (ktLambdaArgument != null) {
                            ktLambdaArgument.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(result2){
                                final /* synthetic */ StringBuilder $result;
                                {
                                    this.$result = $result;
                                    super(false);
                                }

                                public void visitElement(PsiElement element) {
                                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                    super.visitElement(element);
                                    PsiElement psiElement = element;
                                    if (psiElement instanceof PsiWhiteSpace) {
                                        String string = ((PsiWhiteSpace)element).getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"\n", (boolean)false, (int)2, null)) {
                                            this.$result.append("\n");
                                        }
                                    } else if (!(psiElement instanceof PsiComment) && psiElement instanceof LeafPsiElement) {
                                        this.$result.append(((LeafPsiElement)element).getText());
                                    }
                                }
                            });
                        }
                        result2.append("\n");
                    }
                }
            }
        }
        GradleBuildRoot buildRoot = (object = GradleBuildRootsManager.Companion.getInstance($project)) != null && (object = ((GradleBuildRootsLocator)object).findScriptBuildRoot($file)) != null ? ((GradleBuildRootsLocator.ScriptUnderRoot)object).getNearest() : null;
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        GradleBuildRoot gradleBuildRoot = buildRoot;
        return new GradleKotlinScriptConfigurationInputs(string, $givenTimeStamp, gradleBuildRoot != null ? gradleBuildRoot.getPathPrefix() : null);
    }

    static {
        Object[] objectArray = new String[]{"buildscript", "plugins", "initscript", "pluginManagement"};
        sections = CollectionsKt.arrayListOf((Object[])objectArray);
    }
}

