/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.configuration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradleJava.configuration.GradleModuleBuilderUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getNewFileWriter", "Ljava/io/Writer;", "module", "Lcom/intellij/openapi/module/Module;", "relativeDir", "", "fileName", "addBrowserSupport", "", "browserConfiguration", "kotlinDsl", "", "kotlin.gradle.gradle-java"})
public final class GradleKotlinFrameworkSupportProviderUtilsKt {
    @Nullable
    public static final Writer getNewFileWriter(@NotNull Module module, @NotNull String relativeDir, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)relativeDir, (String)"relativeDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object object = GradleModuleBuilderUtilsKt.getGradleModuleBuilder(module);
        if (object == null || (object = object.getContentEntryPath()) == null) {
            return null;
        }
        Object contentEntryPath = object;
        if (((CharSequence)contentEntryPath).length() == 0) {
            return null;
        }
        File contentRootDir = new File((String)contentEntryPath);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentRootDir);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile modelContentRootDir = virtualFile;
        VirtualFile virtualFile2 = VfsUtil.createDirectoryIfMissing((VirtualFile)modelContentRootDir, (String)relativeDir);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile dir = virtualFile2;
        if (dir.findChild(fileName) != null) {
            return null;
        }
        VirtualFile virtualFile3 = dir.createChildData(null, fileName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"createChildData(...)");
        VirtualFile file = virtualFile3;
        OutputStream outputStream = file.getOutputStream(null);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        OutputStream outputStream2 = outputStream;
        Charset charset = Charsets.UTF_8;
        return new OutputStreamWriter(outputStream2, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addBrowserSupport(@NotNull Module module) {
        Writer it;
        Throwable throwable;
        Closeable closeable;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Writer writer = GradleKotlinFrameworkSupportProviderUtilsKt.getNewFileWriter(module, "src/main/resources", "index.html");
        if (writer != null) {
            closeable = writer;
            throwable = null;
            try {
                it = (Writer)closeable;
                boolean bl = false;
                it.write(((Object)StringsKt.trim((CharSequence)StringsKt.trimIndent((String)("\n                <!DOCTYPE html>\n                <html lang=\"en\">\n                <head>\n                    <meta charset=\"UTF-8\">\n                    <title>" + module.getName() + "</title>\n                    <script src=\"" + module.getName() + ".js\"></script>\n                </head>\n                <body>\n                \n                </body>\n                </html>\n            ")))).toString());
                it = Unit.INSTANCE;
            }
            catch (Throwable bl) {
                throwable = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        Writer writer2 = GradleKotlinFrameworkSupportProviderUtilsKt.getNewFileWriter(module, "src/main/kotlin", "main.kt");
        if (writer2 != null) {
            closeable = writer2;
            throwable = null;
            try {
                it = (Writer)closeable;
                boolean bl = false;
                it.write(((Object)StringsKt.trim((CharSequence)"import kotlinx.browser.document\n\nfun main() {\n    document.write(\"Hello, world!\")\n}")).toString());
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final String browserConfiguration(boolean kotlinDsl) {
        String receiver2 = kotlinDsl ? "" : "it.";
        return StringsKt.trimIndent((String)("\n        webpackTask {\n            cssSupport {\n                " + receiver2 + "enabled.set(true)\n            }\n        }\n        \n        runTask {\n            cssSupport {\n                " + receiver2 + "enabled.set(true)\n            }\n        }\n        \n        testTask {\n            useKarma {\n                useChromeHeadless()\n                webpackConfig.cssSupport {\n                    " + receiver2 + "enabled.set(true)\n                }\n            }\n        }\n    "));
    }
}

