/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.BrowserHyperlinkListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.KotlinIdeaGradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/actions/ShowKotlinGradleDslLogs;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "actionPerformed", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isAvailable", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "openLogsDirIfPresent", "findLogsDir", "Ljava/nio/file/Path;", "startInWriteAction", "getText", "", "getFamilyName", "Companion", "kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nShowKotlinGradleDslLogs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowKotlinGradleDslLogs.kt\norg/jetbrains/kotlin/idea/gradle/actions/ShowKotlinGradleDslLogs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class ShowKotlinGradleDslLogs
extends AnAction
implements IntentionAction,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String gradleTroubleshootingLink = "https://docs.gradle.org/current/userguide/kotlin_dsl.html#troubleshooting";
    @NotNull
    private static final String NAME;

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.openLogsDirIfPresent(project);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        this.openLogsDirIfPresent(project2);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RevealFileAction.isSupported();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        presentation2.setEnabledAndVisible(e.getProject() != null && RevealFileAction.isSupported());
        presentation2.setText(NAME);
    }

    private final void openLogsDirIfPresent(Project project) {
        Path logsDir = this.findLogsDir();
        if (logsDir != null) {
            RevealFileAction.openDirectory((Path)logsDir);
        } else {
            Object object = WindowManager.getInstance().getStatusBar(project);
            if (object == null || (object = object.getComponent()) == null) {
                JFrame jFrame = WindowManager.getInstance().findVisibleFrame();
                object = jFrame != null ? jFrame.getRootPane() : null;
            }
            Object parent2 = object;
            Object[] objectArray = new Object[]{gradleTroubleshootingLink};
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(KotlinIdeaGradleBundle.message("text.gradle.dsl.logs.cannot.be.found.automatically.see.how.to.find.logs", objectArray), MessageType.ERROR, (HyperlinkListener)BrowserHyperlinkListener.INSTANCE).setFadeoutTime(5000L).createBalloon().showInCenterOf((JComponent)parent2);
        }
    }

    private final Path findLogsDir() {
        Path path2;
        String string = System.getProperty("user.home");
        if (string != null) {
            Path path3;
            String userHome = string;
            boolean bl = false;
            if (SystemInfo.isMac) {
                Path path4 = Paths.get(userHome + "/Library/Logs/gradle-kotlin-dsl", new String[0]);
                v2 = path4;
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
            } else if (SystemInfo.isLinux) {
                Path path5 = Paths.get(userHome + "/.gradle-kotlin-dsl/logs", new String[0]);
                v2 = path5;
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
            } else if (SystemInfo.isWindows) {
                Path path6 = Paths.get(userHome + "/AppData/Local/gradle-kotlin-dsl/log", new String[0]);
                v2 = path6;
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"get(...)");
            } else {
                v2 = path3 = null;
            }
            if (path3 != null) {
                Path path7;
                Path p0 = path7 = path3;
                boolean bl2 = false;
                boolean $i$f$findLogsDir$lambda$0$exists = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                path2 = Files.exists(p0, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path7 : null;
            } else {
                path2 = null;
            }
        } else {
            path2 = null;
        }
        return path2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return NAME;
    }

    @NotNull
    public String getFamilyName() {
        return NAME;
    }

    static {
        Object[] objectArray = new Object[]{RevealFileAction.getFileManagerName()};
        NAME = KotlinIdeaGradleBundle.message("action.text.show.kotlin.gradle.dsl.logs.in", objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/actions/ShowKotlinGradleDslLogs$Companion;", "", "<init>", "()V", "gradleTroubleshootingLink", "", "NAME", "getNAME", "()Ljava/lang/String;", "kotlin.gradle.gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

