/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineDescriptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFramesProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStacksInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u0000 S2\u00020\u0001:\u0001SBW\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010A\u001a\u00020=2\u0006\u0010B\u001a\u00020CR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0015\"\u0004\b!\u0010\"R\u001c\u0010#\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0015\"\u0004\b%\u0010\"R\u001b\u0010&\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b'\u0010\u0015R\u001b\u0010*\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010)\u001a\u0004\b+\u0010\u0015R\u001d\u0010-\u001a\u0004\u0018\u00010.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010)\u001a\u0004\b/\u00100R!\u00102\u001a\b\u0012\u0004\u0012\u000204038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010)\u001a\u0004\b5\u00106R!\u00108\u001a\b\u0012\u0004\u0012\u000209038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010)\u001a\u0004\b:\u00106R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010>R\u0011\u0010?\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010>R\u0011\u0010@\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010>R!\u0010D\u001a\u00020E8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\bJ\u0010)\u0012\u0004\bF\u0010G\u001a\u0004\bH\u0010IR#\u0010K\u001a\u0004\u0018\u00010\u000b8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\bN\u0010)\u0012\u0004\bL\u0010G\u001a\u0004\bM\u0010\u0019R'\u0010O\u001a\b\u0012\u0004\u0012\u00020\u0003038FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\bR\u0010)\u0012\u0004\bP\u0010G\u001a\u0004\bQ\u00106\u00a8\u0006T"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "", "name", "", "id", "", "state", "dispatcher", "lastObservedFrame", "Lcom/sun/jdi/ObjectReference;", "lastObservedThread", "Lcom/sun/jdi/ThreadReference;", "debugCoroutineInfoRef", "stackFrameProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFramesProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/String;Lcom/sun/jdi/ObjectReference;Lcom/sun/jdi/ThreadReference;Lcom/sun/jdi/ObjectReference;Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFramesProvider;)V", "getId", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getDispatcher", "()Ljava/lang/String;", "getLastObservedFrame", "()Lcom/sun/jdi/ObjectReference;", "getLastObservedThread", "()Lcom/sun/jdi/ThreadReference;", "getDebugCoroutineInfoRef", "getName", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/State;", "getState", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/State;", "job", "getJob", "setJob", "(Ljava/lang/String;)V", "parentJob", "getParentJob", "setParentJob", "contextSummary", "getContextSummary", "contextSummary$delegate", "Lkotlin/Lazy;", "coroutineDescriptor", "getCoroutineDescriptor", "coroutineDescriptor$delegate", "coroutineStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStacksInfoData;", "getCoroutineStackFrames", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStacksInfoData;", "coroutineStackFrames$delegate", "continuationStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "getContinuationStackFrames", "()Ljava/util/List;", "continuationStackFrames$delegate", "creationStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "getCreationStackFrames", "creationStackFrames$delegate", "isSuspended", "", "()Z", "isRunning", "isCreated", "isRunningOnCurrentThread", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContext;", "descriptor", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "getDescriptor$annotations", "()V", "getDescriptor", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "descriptor$delegate", "activeThread", "getActiveThread$annotations", "getActiveThread", "activeThread$delegate", "jobHierarchy", "getJobHierarchy$annotations", "getJobHierarchy", "jobHierarchy$delegate", "Companion", "kotlin.jvm-debugger.coroutines"})
public class CoroutineInfoData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Long id;
    @Nullable
    private final String dispatcher;
    @Nullable
    private final ObjectReference lastObservedFrame;
    @Nullable
    private final ThreadReference lastObservedThread;
    @Nullable
    private final ObjectReference debugCoroutineInfoRef;
    @Nullable
    private final CoroutineStackFramesProvider stackFrameProvider;
    @NotNull
    private final String name;
    @NotNull
    private final State state;
    @Nullable
    private String job;
    @Nullable
    private String parentJob;
    @NotNull
    private final Lazy contextSummary$delegate;
    @NotNull
    private final Lazy coroutineDescriptor$delegate;
    @NotNull
    private final Lazy coroutineStackFrames$delegate;
    @NotNull
    private final Lazy continuationStackFrames$delegate;
    @NotNull
    private final Lazy creationStackFrames$delegate;
    private final boolean isSuspended;
    private final boolean isRunning;
    private final boolean isCreated;
    @NotNull
    private final Lazy descriptor$delegate;
    @NotNull
    private final Lazy activeThread$delegate;
    @NotNull
    private final Lazy jobHierarchy$delegate;
    @NotNull
    public static final String DEFAULT_COROUTINE_NAME = "coroutine";
    @NotNull
    public static final String DEFAULT_COROUTINE_STATE = "UNKNOWN";
    @NotNull
    public static final String UNKNOWN_JOB = "UNKNOWN_JOB";
    @NotNull
    private static final String UNKNOWN_THREAD = "UNKNOWN_THREAD";

    public CoroutineInfoData(@Nullable String name2, @Nullable Long id, @Nullable String state, @Nullable String dispatcher, @Nullable ObjectReference lastObservedFrame, @Nullable ThreadReference lastObservedThread, @Nullable ObjectReference debugCoroutineInfoRef, @Nullable CoroutineStackFramesProvider stackFrameProvider) {
        this.id = id;
        this.dispatcher = dispatcher;
        this.lastObservedFrame = lastObservedFrame;
        this.lastObservedThread = lastObservedThread;
        this.debugCoroutineInfoRef = debugCoroutineInfoRef;
        this.stackFrameProvider = stackFrameProvider;
        String string = name2;
        if (string == null) {
            string = DEFAULT_COROUTINE_NAME;
        }
        this.name = string;
        this.state = State.Companion.fromString(state);
        this.contextSummary$delegate = LazyKt.lazy(() -> CoroutineInfoData.contextSummary_delegate$lambda$0(this));
        this.coroutineDescriptor$delegate = LazyKt.lazy(() -> CoroutineInfoData.coroutineDescriptor_delegate$lambda$1(this, state));
        this.coroutineStackFrames$delegate = LazyKt.lazy(() -> CoroutineInfoData.coroutineStackFrames_delegate$lambda$2(this));
        this.continuationStackFrames$delegate = LazyKt.lazy(() -> CoroutineInfoData.continuationStackFrames_delegate$lambda$3(this));
        this.creationStackFrames$delegate = LazyKt.lazy(() -> CoroutineInfoData.creationStackFrames_delegate$lambda$4(this));
        this.isSuspended = this.state == State.SUSPENDED;
        this.isRunning = this.state == State.RUNNING;
        this.isCreated = this.state == State.CREATED;
        this.descriptor$delegate = LazyKt.lazy(() -> CoroutineInfoData.descriptor_delegate$lambda$5(this));
        this.activeThread$delegate = LazyKt.lazy(() -> CoroutineInfoData.activeThread_delegate$lambda$6(this));
        this.jobHierarchy$delegate = LazyKt.lazy(CoroutineInfoData::jobHierarchy_delegate$lambda$7);
    }

    @Nullable
    public final Long getId() {
        return this.id;
    }

    @Nullable
    public final String getDispatcher() {
        return this.dispatcher;
    }

    @Nullable
    public final ObjectReference getLastObservedFrame() {
        return this.lastObservedFrame;
    }

    @Nullable
    public final ThreadReference getLastObservedThread() {
        return this.lastObservedThread;
    }

    @Nullable
    public final ObjectReference getDebugCoroutineInfoRef() {
        return this.debugCoroutineInfoRef;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    @Nullable
    public final String getJob() {
        return this.job;
    }

    public final void setJob(@Nullable String string) {
        this.job = string;
    }

    @Nullable
    public final String getParentJob() {
        return this.parentJob;
    }

    public final void setParentJob(@Nullable String string) {
        this.parentJob = string;
    }

    private final String getContextSummary() {
        Lazy lazy = this.contextSummary$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getCoroutineDescriptor() {
        Lazy lazy = this.coroutineDescriptor$delegate;
        return (String)lazy.getValue();
    }

    private final CoroutineStacksInfoData getCoroutineStackFrames() {
        Lazy lazy = this.coroutineStackFrames$delegate;
        return (CoroutineStacksInfoData)lazy.getValue();
    }

    @NotNull
    public List<CoroutineStackFrameItem> getContinuationStackFrames() {
        Lazy lazy = this.continuationStackFrames$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public List<CreationCoroutineStackFrameItem> getCreationStackFrames() {
        Lazy lazy = this.creationStackFrames$delegate;
        return (List)lazy.getValue();
    }

    public final boolean isSuspended() {
        return this.isSuspended;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isCreated() {
        return this.isCreated;
    }

    public final boolean isRunningOnCurrentThread(@NotNull SuspendContext suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        ThreadReferenceProxy threadReferenceProxy = suspendContext.getThread();
        return Intrinsics.areEqual((Object)this.lastObservedThread, (Object)(threadReferenceProxy != null ? threadReferenceProxy.getThreadReference() : null));
    }

    @NotNull
    public final CoroutineDescriptor getDescriptor() {
        Lazy lazy = this.descriptor$delegate;
        return (CoroutineDescriptor)lazy.getValue();
    }

    @Deprecated(message="Please use API of CoroutineInfoData instead.")
    public static /* synthetic */ void getDescriptor$annotations() {
    }

    @Nullable
    public final ThreadReference getActiveThread() {
        Lazy lazy = this.activeThread$delegate;
        return (ThreadReference)lazy.getValue();
    }

    @Deprecated(message="Please use lastObservedThread instead.", replaceWith=@ReplaceWith(expression="lastObservedThread", imports={}))
    public static /* synthetic */ void getActiveThread$annotations() {
    }

    @NotNull
    public final List<String> getJobHierarchy() {
        Lazy lazy = this.jobHierarchy$delegate;
        return (List)lazy.getValue();
    }

    @Deprecated(message="The hierarchy of parent jobs for a current coroutine is not computed anymore.")
    public static /* synthetic */ void getJobHierarchy$annotations() {
    }

    private static final String contextSummary_delegate$lambda$0(CoroutineInfoData this$0) {
        return "[" + this$0.dispatcher + (String)(this$0.job == null ? "" : ", " + this$0.job) + "]";
    }

    private static final String coroutineDescriptor_delegate$lambda$1(CoroutineInfoData this$0, String $state) {
        Object object;
        String string = this$0.name;
        Long l = this$0.id;
        if (this$0.isRunning) {
            Object object2 = this$0.lastObservedThread;
            if (object2 == null || (object2 = object2.name()) == null) {
                object2 = UNKNOWN_THREAD;
            }
            object = "on thread " + (String)object2;
        } else {
            object = "";
        }
        return "\"" + string + ":" + l + "\" " + $state + " " + (String)object + " " + this$0.getContextSummary();
    }

    private static final CoroutineStacksInfoData coroutineStackFrames_delegate$lambda$2(CoroutineInfoData this$0) {
        CoroutineStackFramesProvider coroutineStackFramesProvider = this$0.stackFrameProvider;
        return coroutineStackFramesProvider != null ? coroutineStackFramesProvider.fetchCoroutineStackFrames(this$0.lastObservedFrame) : null;
    }

    private static final List continuationStackFrames_delegate$lambda$3(CoroutineInfoData this$0) {
        Object object = this$0.getCoroutineStackFrames();
        if (object == null || (object = ((CoroutineStacksInfoData)object).getContinuationStackFrames()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List creationStackFrames_delegate$lambda$4(CoroutineInfoData this$0) {
        Object object = this$0.getCoroutineStackFrames();
        if (object == null || (object = ((CoroutineStacksInfoData)object).getCreationStackFrames()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final CoroutineDescriptor descriptor_delegate$lambda$5(CoroutineInfoData this$0) {
        return new CoroutineDescriptor(this$0.name, String.valueOf(this$0.id), this$0.state, this$0.dispatcher, this$0.getContextSummary());
    }

    private static final ThreadReference activeThread_delegate$lambda$6(CoroutineInfoData this$0) {
        return this$0.lastObservedThread;
    }

    private static final List jobHierarchy_delegate$lambda$7() {
        return CollectionsKt.emptyList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u000e\u0010\t\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData$Companion;", "", "<init>", "()V", "DEFAULT_COROUTINE_NAME", "", "getDEFAULT_COROUTINE_NAME$annotations", "DEFAULT_COROUTINE_STATE", "getDEFAULT_COROUTINE_STATE$annotations", "UNKNOWN_JOB", "UNKNOWN_THREAD", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="This API will not be exposed in the future versions.")
        public static /* synthetic */ void getDEFAULT_COROUTINE_NAME$annotations() {
        }

        @Deprecated(message="This API will not be exposed in the future versions.")
        public static /* synthetic */ void getDEFAULT_COROUTINE_STATE$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

