/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0007H\u0016J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/ContinuationVariableValueDescriptorImpl;", "Lcom/intellij/debugger/ui/impl/watch/ValueDescriptorImpl;", "defaultExecutionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "continuation", "Lcom/sun/jdi/ObjectReference;", "fieldName", "", "variableName", "<init>", "(Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;Lcom/sun/jdi/ObjectReference;Ljava/lang/String;Ljava/lang/String;)V", "getContinuation", "()Lcom/sun/jdi/ObjectReference;", "getFieldName", "()Ljava/lang/String;", "calcValueName", "calcValue", "Lcom/sun/jdi/Value;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "updateValue", "", "value", "getDescriptorEvaluation", "", "context", "Lcom/intellij/debugger/DebuggerContext;", "kotlin.jvm-debugger.coroutines"})
public final class ContinuationVariableValueDescriptorImpl
extends ValueDescriptorImpl {
    @NotNull
    private final ObjectReference continuation;
    @NotNull
    private final String fieldName;
    @NotNull
    private final String variableName;

    public ContinuationVariableValueDescriptorImpl(@NotNull DefaultExecutionContext defaultExecutionContext, @NotNull ObjectReference continuation2, @NotNull String fieldName, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)defaultExecutionContext, (String)"defaultExecutionContext");
        Intrinsics.checkNotNullParameter((Object)continuation2, (String)"continuation");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        super(defaultExecutionContext.getProject());
        this.continuation = continuation2;
        this.fieldName = fieldName;
        this.variableName = variableName;
        this.setContext(defaultExecutionContext.getEvaluationContext());
    }

    @NotNull
    public final ObjectReference getContinuation() {
        return this.continuation;
    }

    @NotNull
    public final String getFieldName() {
        return this.fieldName;
    }

    @NotNull
    public String calcValueName() {
        return this.variableName;
    }

    @Nullable
    public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
        ReferenceType referenceType = this.continuation.referenceType();
        if (referenceType == null) {
            return null;
        }
        ReferenceType referenceType2 = referenceType;
        Field field2 = DebuggerUtils.findField((ReferenceType)referenceType2, (String)this.fieldName);
        if (field2 == null) {
            return null;
        }
        Field field3 = field2;
        return this.continuation.getValue(field3);
    }

    public final void updateValue(@Nullable Value value) {
        ReferenceType referenceType = this.continuation.referenceType();
        if (referenceType == null) {
            return;
        }
        ReferenceType referenceType2 = referenceType;
        Field field2 = DebuggerUtils.findField((ReferenceType)referenceType2, (String)this.fieldName);
        if (field2 == null) {
            return;
        }
        Field field3 = field2;
        this.continuation.setValue(field3, value);
    }

    @NotNull
    public Void getDescriptorEvaluation(@Nullable DebuggerContext context) {
        throw new EvaluateException("Spilled variable evaluation is not supported");
    }
}

