/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.coroutines.CoroutinesDebugHelper;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineFilter;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineStackFrameInterceptorKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.DisableCoroutineViewListenerKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendExitMode;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.SkipCoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.CoroutineStackFrameLight;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugMetadata;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImplCoroutineOwner;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfBaseContinuationImplLight;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineInfo;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfCoroutineOwner;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.MirrorOfStackTraceElement;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J \u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\"\u001a\u0004\u0018\u00010\b*\u00020\u000eH\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor;", "Lorg/jetbrains/kotlin/idea/debugger/core/StackFrameInterceptor;", "<init>", "()V", "createStackFrames", "", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "extractCoroutineFilter", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "tryComputeContinuationFilter", "frameProxy", "defaultExecutionContext", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "extractBaseContinuation", "continuation", "Lcom/sun/jdi/ObjectReference;", "extractContinuationId", "getContinuationFilterFromHelper", "currentContinuation", "context", "getCoroutinesRunningOnCurrentThreadFromHelper", "", "", "debugProbesImpl", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/DebugProbesImpl;", "extractContinuation", "callerLocation", "Lcom/sun/jdi/Location;", "getStackFrameProxyImpl", "CoroutineIdFilter", "ContinuationObjectFilter", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineStackFrameInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,278:1\n1611#2,9:279\n1863#2:288\n1864#2:290\n1620#2:291\n1#3:289\n1#3:293\n25#4:292\n25#4:294\n25#4:295\n25#4:296\n25#4:297\n25#4:298\n*S KotlinDebug\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor\n*L\n76#1:279,9\n76#1:288\n76#1:290\n76#1:291\n76#1:289\n97#1:292\n137#1:294\n158#1:295\n177#1:296\n179#1:297\n204#1:298\n*E\n"})
final class CoroutineStackFrameInterceptor
implements StackFrameInterceptor {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<XStackFrame> createStackFrames(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
                DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
                JavaDebugProcess javaDebugProcess = debugProcess.getXdebugProcess();
                if (!((javaDebugProcess != null ? javaDebugProcess.getSession() : null) instanceof XDebugSessionImpl) || frame instanceof SkipCoroutineStackFrameProxyImpl) break block12;
                JavaDebugProcess javaDebugProcess2 = debugProcess.getXdebugProcess();
                Object object = javaDebugProcess2 != null ? javaDebugProcess2.getSession() : null;
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
                if (AsyncStacksToggleAction.Companion.isAsyncStacksEnabled((XDebugSessionImpl)object)) break block13;
            }
            return null;
        }
        Location location = SafeUtilKt.safeLocation((StackFrameProxy)frame);
        if (location != null && SafeUtilKt.safeLineNumber(location) < 0) {
            Method method = SafeUtilKt.safeMethod(location);
            if (Intrinsics.areEqual((Object)(method != null ? method.name() : null), (Object)"main") || CoroutineUtilsKt.isInvokeSuspend(location)) {
                return CollectionsKt.emptyList();
            }
        }
        SuspendContextImpl suspendContextImpl = SuspendManagerUtil.getContextForEvaluation((SuspendManager)debugProcess.getSuspendManager());
        if (suspendContextImpl == null) {
            return null;
        }
        SuspendContextImpl suspendContext = suspendContextImpl;
        Pair<Boolean, Boolean> pair = CoroutineFrameBuilder.Companion.isFirstSuspendFrame$kotlin_jvm_debugger_coroutines(frame);
        boolean isSuspendFrame = (Boolean)pair.component1();
        boolean isFirst = (Boolean)pair.component2();
        if (!isSuspendFrame) {
            return null;
        }
        if (!isFirst) {
            return CollectionsKt.emptyList();
        }
        CoroutinePreflightFrame coroutinePreflightFrame = CoroutineFrameBuilder.Companion.coroutineExitFrame$kotlin_jvm_debugger_coroutines(frame, suspendContext);
        if (coroutinePreflightFrame == null) {
            return null;
        }
        CoroutinePreflightFrame stackFrame = coroutinePreflightFrame;
        if (Registry.Companion.is("debugger.kotlin.auto.show.coroutines.view")) {
            DisableCoroutineViewListenerKt.showOrHideCoroutinePanel(debugProcess, true);
        }
        if (!CoroutineUtilsKt.threadAndContextSupportsEvaluation(suspendContext, frame)) {
            return CollectionsKt.listOf((Object)((Object)stackFrame));
        }
        CoroutineFrameBuilder.Companion.CoroutineFrameItemLists frameItemLists = CoroutineFrameBuilder.Companion.build$kotlin_jvm_debugger_coroutines(stackFrame, suspendContext, false);
        Iterable iterable = frameItemLists.getFrames();
        Collection collection = CollectionsKt.listOf((Object)((Object)stackFrame));
        boolean $i$f$mapNotNull = false;
        void var12_13 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            XStackFrame it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CoroutineStackFrameItem it = (CoroutineStackFrameItem)((Object)element$iv$iv);
            boolean bl2 = false;
            if (it.createFrame(debugProcess) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @Override
    @Nullable
    public CoroutineFilter extractCoroutineFilter(@NotNull SuspendContextImpl suspendContext) {
        CoroutineFilter coroutineFilter;
        CoroutineFilter continuationFilter;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        StackFrameProxyImpl stackFrameProxyImpl = this.getStackFrameProxyImpl(suspendContext);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        DefaultExecutionContext defaultExecutionContext = new DefaultExecutionContext(suspendContext, frameProxy);
        CoroutineFilter coroutineFilter2 = continuationFilter = this.tryComputeContinuationFilter(frameProxy, defaultExecutionContext);
        if (coroutineFilter2 != null) {
            return coroutineFilter2;
        }
        DebugProbesImpl debugProbesImpl = DebugProbesImpl.Companion.instance(defaultExecutionContext);
        if (debugProbesImpl != null && debugProbesImpl.isInstalled()) {
            Set<Long> currentCoroutines;
            Set<Long> set = this.getCoroutinesRunningOnCurrentThreadFromHelper(defaultExecutionContext, debugProbesImpl);
            if (set == null) {
                set = debugProbesImpl.getCoroutinesRunningOnCurrentThread(defaultExecutionContext);
            }
            coroutineFilter = !((Collection)(currentCoroutines = set)).isEmpty() ? new CoroutineIdFilter(currentCoroutines) : null;
        } else {
            CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("[coroutine filter]: kotlinx-coroutines debug agent was not enabled, DebugProbesImpl class is not found.");
            coroutineFilter = null;
        }
        return coroutineFilter;
    }

    private final CoroutineFilter tryComputeContinuationFilter(StackFrameProxyImpl frameProxy, DefaultExecutionContext defaultExecutionContext) {
        CoroutineFilter coroutineFilter;
        ObjectReference objectReference = this.extractContinuation(frameProxy);
        if (objectReference == null) {
            return null;
        }
        ObjectReference currentContinuation = objectReference;
        CoroutineFilter coroutineFilter2 = this.getContinuationFilterFromHelper(currentContinuation, defaultExecutionContext);
        if (coroutineFilter2 != null) {
            CoroutineFilter it = coroutineFilter2;
            boolean bl = false;
            return it;
        }
        DebugProbesImpl debugProbesImpl = DebugProbesImpl.Companion.instance(defaultExecutionContext);
        if (debugProbesImpl != null && debugProbesImpl.isInstalled() && (coroutineFilter = this.extractContinuationId(currentContinuation, defaultExecutionContext)) != null) {
            CoroutineFilter it = coroutineFilter;
            boolean bl = false;
            return it;
        }
        return this.extractBaseContinuation(currentContinuation, defaultExecutionContext);
    }

    private final CoroutineFilter extractBaseContinuation(ObjectReference continuation2, DefaultExecutionContext defaultExecutionContext) {
        CoroutineStackFrameLight baseContinuationImpl = new CoroutineStackFrameLight(defaultExecutionContext);
        ObjectReference loopContinuation = continuation2;
        while (true) {
            MirrorOfBaseContinuationImplLight continuationMirror;
            if ((continuationMirror = (MirrorOfBaseContinuationImplLight)baseContinuationImpl.mirror(loopContinuation, defaultExecutionContext)) == null) {
                CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                StackFrameProxyImpl stackFrameProxyImpl = defaultExecutionContext.getFrameProxy();
                logger.warn("[coroutine filter]: extracted completion field was not an instance of BaseContinuationImpl, " + (stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null));
                return null;
            }
            ObjectReference nextContinuation = continuationMirror.getNextContinuation();
            if (nextContinuation == null) {
                return new ContinuationObjectFilter(continuationMirror.getThat());
            }
            loopContinuation = nextContinuation;
        }
    }

    private final CoroutineFilter extractContinuationId(ObjectReference continuation2, DefaultExecutionContext defaultExecutionContext) {
        CoroutineStackFrameLight baseContinuationImpl = new CoroutineStackFrameLight(defaultExecutionContext);
        ObjectReference loopContinuation = continuation2;
        while (true) {
            DebugProbesImplCoroutineOwner coroutineOwner;
            MirrorOfCoroutineOwner coroutineOwnerMirror;
            Object object;
            MirrorOfBaseContinuationImplLight continuationMirror;
            if ((continuationMirror = (MirrorOfBaseContinuationImplLight)baseContinuationImpl.mirror(loopContinuation, defaultExecutionContext)) == null) {
                CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                StackFrameProxyImpl stackFrameProxyImpl = defaultExecutionContext.getFrameProxy();
                logger.warn("[coroutine filter]: extracted completion field was not an instance of BaseContinuationImpl, " + (stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null));
                return null;
            }
            if (continuationMirror.getCoroutineOwner() != null && (object = (coroutineOwnerMirror = (MirrorOfCoroutineOwner)(coroutineOwner = new DebugProbesImplCoroutineOwner(null, defaultExecutionContext)).mirror(continuationMirror.getCoroutineOwner(), defaultExecutionContext))) != null && (object = ((MirrorOfCoroutineOwner)object).getCoroutineInfo()) != null && (object = ((MirrorOfCoroutineInfo)object).getSequenceNumber()) != null) {
                long it = ((Number)object).longValue();
                boolean bl = false;
                return new CoroutineIdFilter(SetsKt.setOf((Object)it));
            }
            ObjectReference nextContinuation = continuationMirror.getNextContinuation();
            if (nextContinuation == null) {
                return new ContinuationObjectFilter(continuationMirror.getThat());
            }
            loopContinuation = nextContinuation;
        }
    }

    private final CoroutineFilter getContinuationFilterFromHelper(ObjectReference currentContinuation, DefaultExecutionContext context) {
        ContinuationObjectFilter continuationObjectFilter;
        Value continuationIdValue = CoroutineStackFrameInterceptorKt.callMethodFromHelper(CoroutinesDebugHelper.class, context, "tryGetContinuationId", CollectionsKt.listOf((Object)currentContinuation), new String[0]);
        LongValue longValue = continuationIdValue instanceof LongValue ? (LongValue)continuationIdValue : null;
        if (longValue != null) {
            long it = longValue.value();
            boolean bl = false;
            if (it != -1L) {
                return new CoroutineIdFilter(SetsKt.setOf((Object)it));
            }
        }
        CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        StackFrameProxyImpl stackFrameProxyImpl = context.getFrameProxy();
        logger.warn("[coroutine filter]: Could not extract continuation ID, location = " + (stackFrameProxyImpl != null ? stackFrameProxyImpl.location() : null));
        Value rootContinuation = CoroutineStackFrameInterceptorKt.callMethodFromHelper(CoroutinesDebugHelper.class, context, "getRootContinuation", CollectionsKt.listOf((Object)currentContinuation), new String[0]);
        if (rootContinuation == null) {
            CoroutineStackFrameInterceptor $this$thisLogger$iv2 = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger2 = Logger.getInstance(CoroutineStackFrameInterceptor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("[coroutine filter]: Could not extract continuation instance");
        }
        Value value = rootContinuation;
        if (value != null) {
            Value it = value;
            boolean bl = false;
            continuationObjectFilter = new ContinuationObjectFilter((ObjectReference)it);
        } else {
            continuationObjectFilter = null;
        }
        return continuationObjectFilter;
    }

    private final Set<Long> getCoroutinesRunningOnCurrentThreadFromHelper(DefaultExecutionContext context, DebugProbesImpl debugProbesImpl) {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = context.getSuspendContext().getThread();
        if (threadReferenceProxyImpl == null) {
            return null;
        }
        ThreadReferenceProxyImpl threadReferenceProxyImpl2 = threadReferenceProxyImpl;
        Object[] objectArray = new ObjectReference[]{debugProbesImpl.getObject(), threadReferenceProxyImpl2.getThreadReference()};
        List args = CollectionsKt.listOf((Object[])objectArray);
        Value result2 = CoroutineStackFrameInterceptorKt.callMethodFromHelper(CoroutinesDebugHelper.class, context, "getCoroutinesRunningOnCurrentThread", args, new String[0]);
        if (result2 == null) {
            return null;
        }
        List<Value> list2 = ((ArrayReference)result2).getValues();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getValues(...)");
        return SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list2), CoroutineStackFrameInterceptor::getCoroutinesRunningOnCurrentThreadFromHelper$lambda$6));
    }

    private final ObjectReference extractContinuation(StackFrameProxyImpl frameProxy) {
        ObjectReference objectReference;
        Location location = frameProxy.location();
        Intrinsics.checkNotNullExpressionValue((Object)location, (String)"location(...)");
        SuspendExitMode suspendExitMode = CoroutineUtilsKt.getSuspendExitMode(location);
        switch (WhenMappings.$EnumSwitchMapping$0[suspendExitMode.ordinal()]) {
            case 1: {
                ObjectReference objectReference2 = CoroutineUtilsKt.thisVariableValue(frameProxy);
                if (objectReference2 != null) {
                    ObjectReference it = objectReference2;
                    boolean bl = false;
                    return it;
                }
                List list2 = frameProxy.threadProxy().frames();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"frames(...)");
                StackFrameProxyImpl prevStackFrame = (StackFrameProxyImpl)CollectionsKt.getOrNull((List)list2, (int)(frameProxy.getFrameIndex() + 1));
                if (prevStackFrame == null) {
                    CoroutineStackFrameInterceptor $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(CoroutineStackFrameInterceptor.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("[coroutine filtering]: Could not extract the previous stack frame for the frame " + frameProxy.getStackFrame() + ":\nthread = " + frameProxy.threadProxy().name() + " \nframes = " + frameProxy.threadProxy().frames());
                    return null;
                }
                objectReference = prevStackFrame.thisObject();
                break;
            }
            case 2: {
                objectReference = CoroutineUtilsKt.continuationVariableValue(frameProxy);
                if (objectReference != null) break;
                objectReference = CoroutineUtilsKt.completionVariableValue(frameProxy);
                break;
            }
            default: {
                objectReference = null;
            }
        }
        return objectReference;
    }

    @Override
    @Nullable
    public Location callerLocation(@NotNull SuspendContextImpl suspendContext) {
        Object stackTraceElement;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        StackFrameProxyImpl stackFrameProxyImpl = this.getStackFrameProxyImpl(suspendContext);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frameProxy = stackFrameProxyImpl;
        ObjectReference objectReference = this.extractContinuation(frameProxy);
        if (objectReference == null) {
            return null;
        }
        ObjectReference continuationObject = objectReference;
        DefaultExecutionContext executionContext = new DefaultExecutionContext(suspendContext, frameProxy);
        DebugMetadata debugMetadata = DebugMetadata.Companion.instance(executionContext);
        if (debugMetadata == null) {
            return null;
        }
        DebugMetadata debugMetadata2 = debugMetadata;
        Value value = CoroutineStackFrameInterceptorKt.callMethodFromHelper(CoroutinesDebugHelper.class, executionContext, "getCallerFrame", CollectionsKt.listOf((Object)continuationObject), new String[0]);
        if (value == null) {
            return null;
        }
        Value callerFrame = value;
        Object object = debugMetadata2.getStackTraceElement((ObjectReference)callerFrame, executionContext);
        if (object == null || (object = ((MirrorOfStackTraceElement)object).stackTraceElement()) == null) {
            return null;
        }
        Object it = stackTraceElement = object;
        boolean bl = false;
        return DebuggerUtilsEx.findOrCreateLocation((VirtualMachine)suspendContext.getVirtualMachineProxy().getVirtualMachine(), (StackTraceElement)it);
    }

    private final StackFrameProxyImpl getStackFrameProxyImpl(SuspendContextImpl $this$getStackFrameProxyImpl) {
        JavaExecutionStack javaExecutionStack = $this$getStackFrameProxyImpl.getActiveExecutionStack();
        if (javaExecutionStack == null || (javaExecutionStack = javaExecutionStack.getThreadProxy()) == null || (javaExecutionStack = javaExecutionStack.frame(0)) == null) {
            javaExecutionStack = $this$getStackFrameProxyImpl.getFrameProxy();
        }
        return javaExecutionStack;
    }

    private static final long getCoroutinesRunningOnCurrentThreadFromHelper$lambda$6(Value it) {
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.sun.jdi.LongValue");
        return ((LongValue)it).value();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\t2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$ContinuationObjectFilter;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "reference", "Lcom/sun/jdi/ObjectReference;", "<init>", "(Lcom/sun/jdi/ObjectReference;)V", "getReference", "()Lcom/sun/jdi/ObjectReference;", "canRunTo", "", "nextCoroutineFilter", "coroutineFilterName", "", "getCoroutineFilterName", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "kotlin.jvm-debugger.coroutines"})
    private static final class ContinuationObjectFilter
    implements CoroutineFilter {
        @NotNull
        private final ObjectReference reference;

        public ContinuationObjectFilter(@NotNull ObjectReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            this.reference = reference2;
        }

        @NotNull
        public final ObjectReference getReference() {
            return this.reference;
        }

        @Override
        public boolean canRunTo(@NotNull CoroutineFilter nextCoroutineFilter) {
            Intrinsics.checkNotNullParameter((Object)nextCoroutineFilter, (String)"nextCoroutineFilter");
            return Intrinsics.areEqual((Object)this, (Object)nextCoroutineFilter);
        }

        @Override
        @NotNull
        public String getCoroutineFilterName() {
            return this.reference.toString();
        }

        @NotNull
        public final ObjectReference component1() {
            return this.reference;
        }

        @NotNull
        public final ContinuationObjectFilter copy(@NotNull ObjectReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            return new ContinuationObjectFilter(reference2);
        }

        public static /* synthetic */ ContinuationObjectFilter copy$default(ContinuationObjectFilter continuationObjectFilter, ObjectReference objectReference, int n, Object object) {
            if ((n & 1) != 0) {
                objectReference = continuationObjectFilter.reference;
            }
            return continuationObjectFilter.copy(objectReference);
        }

        @NotNull
        public String toString() {
            return "ContinuationObjectFilter(reference=" + this.reference + ")";
        }

        public int hashCode() {
            return ((Object)this.reference).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContinuationObjectFilter)) {
                return false;
            }
            ContinuationObjectFilter continuationObjectFilter = (ContinuationObjectFilter)other;
            return Intrinsics.areEqual((Object)this.reference, (Object)continuationObjectFilter.reference);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0016J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\rH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$CoroutineIdFilter;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineFilter;", "coroutinesRunningOnCurrentThread", "", "", "<init>", "(Ljava/util/Set;)V", "getCoroutinesRunningOnCurrentThread", "()Ljava/util/Set;", "canRunTo", "", "nextCoroutineFilter", "coroutineFilterName", "", "getCoroutineFilterName", "()Ljava/lang/String;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\nCoroutineStackFrameInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$CoroutineIdFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1#2:279\n1053#3:280\n*S KotlinDebug\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor$CoroutineIdFilter\n*L\n245#1:280\n*E\n"})
    private static final class CoroutineIdFilter
    implements CoroutineFilter {
        @NotNull
        private final Set<Long> coroutinesRunningOnCurrentThread;

        public CoroutineIdFilter(@NotNull Set<Long> coroutinesRunningOnCurrentThread) {
            Intrinsics.checkNotNullParameter(coroutinesRunningOnCurrentThread, (String)"coroutinesRunningOnCurrentThread");
            this.coroutinesRunningOnCurrentThread = coroutinesRunningOnCurrentThread;
            if (!(!((Collection)this.coroutinesRunningOnCurrentThread).isEmpty())) {
                boolean bl = false;
                String string = "Coroutines set can not be empty";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Set<Long> getCoroutinesRunningOnCurrentThread() {
            return this.coroutinesRunningOnCurrentThread;
        }

        @Override
        public boolean canRunTo(@NotNull CoroutineFilter nextCoroutineFilter) {
            Intrinsics.checkNotNullParameter((Object)nextCoroutineFilter, (String)"nextCoroutineFilter");
            return nextCoroutineFilter instanceof CoroutineIdFilter && !((Collection)CollectionsKt.intersect((Iterable)this.coroutinesRunningOnCurrentThread, (Iterable)((CoroutineIdFilter)nextCoroutineFilter).coroutinesRunningOnCurrentThread)).isEmpty();
        }

        @Override
        @NotNull
        public String getCoroutineFilterName() {
            Long l = (Long)CollectionsKt.singleOrNull((Iterable)this.coroutinesRunningOnCurrentThread);
            if (l != null) {
                long it = ((Number)l).longValue();
                boolean bl = false;
                Object[] objectArray = new Object[]{"#" + it};
                return KotlinDebuggerCoreBundle.message("stepping.filter.coroutine.name", objectArray);
            }
            Iterable $this$sortedBy$iv = CollectionsKt.toList((Iterable)this.coroutinesRunningOnCurrentThread);
            boolean $i$f$sortedBy = false;
            String ids = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    long it = ((Number)a).longValue();
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it);
                    it = ((Number)b).longValue();
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it));
                }
            }), (CharSequence)", ", null, null, (int)0, null, CoroutineIdFilter::_get_coroutineFilterName_$lambda$3, (int)30, null);
            Object[] objectArray = new Object[]{ids};
            return KotlinDebuggerCoreBundle.message("stepping.filter.several.coroutines.name", objectArray);
        }

        @NotNull
        public final Set<Long> component1() {
            return this.coroutinesRunningOnCurrentThread;
        }

        @NotNull
        public final CoroutineIdFilter copy(@NotNull Set<Long> coroutinesRunningOnCurrentThread) {
            Intrinsics.checkNotNullParameter(coroutinesRunningOnCurrentThread, (String)"coroutinesRunningOnCurrentThread");
            return new CoroutineIdFilter(coroutinesRunningOnCurrentThread);
        }

        public static /* synthetic */ CoroutineIdFilter copy$default(CoroutineIdFilter coroutineIdFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = coroutineIdFilter.coroutinesRunningOnCurrentThread;
            }
            return coroutineIdFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "CoroutineIdFilter(coroutinesRunningOnCurrentThread=" + this.coroutinesRunningOnCurrentThread + ")";
        }

        public int hashCode() {
            return ((Object)this.coroutinesRunningOnCurrentThread).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoroutineIdFilter)) {
                return false;
            }
            CoroutineIdFilter coroutineIdFilter = (CoroutineIdFilter)other;
            return Intrinsics.areEqual(this.coroutinesRunningOnCurrentThread, coroutineIdFilter.coroutinesRunningOnCurrentThread);
        }

        private static final CharSequence _get_coroutineFilterName_$lambda$3(long it) {
            return "#" + it;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuspendExitMode.values().length];
            try {
                nArray[SuspendExitMode.SUSPEND_LAMBDA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuspendExitMode.SUSPEND_METHOD_PARAMETER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

