/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.StepIntoMethodBreakpoint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacilityKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility;", "", "<init>", "()V", "installResumeBreakpointInCurrentMethod", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "installResumeBreakpointInCallerMethod", "installCoroutineResumedBreakpoint", "context", "resumedLocation", "Lcom/sun/jdi/Location;", "nextLocationAfterResume", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineBreakpointFacility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,113:1\n25#2:114\n62#2,5:115\n25#2:120\n62#2,5:121\n25#2:126\n25#2:127\n62#2,5:128\n*S KotlinDebug\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n*L\n32#1:114\n32#1:115,5\n43#1:120\n43#1:121,5\n59#1:126\n97#1:127\n97#1:128,5\n*E\n"})
public final class CoroutineBreakpointFacility {
    @NotNull
    public static final CoroutineBreakpointFacility INSTANCE = new CoroutineBreakpointFacility();

    private CoroutineBreakpointFacility() {
    }

    /*
     * WARNING - void declaration
     */
    public final boolean installResumeBreakpointInCurrentMethod(@NotNull SuspendContextImpl suspendContext) {
        void $this$debug_u24default$iv;
        Location location;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Location location2 = suspendContext.getLocation();
        if (location2 == null) {
            return false;
        }
        Location currentLocation = location2;
        List<Location> methodLineLocations = currentLocation.method().allLineLocations();
        if (methodLineLocations.size() > 2 && Intrinsics.areEqual((Object)methodLineLocations.get(methodLineLocations.size() - 2), (Object)currentLocation)) {
            StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
            location = stackFrameInterceptor != null ? stackFrameInterceptor.callerLocation(suspendContext) : null;
        } else {
            location = currentLocation;
        }
        if (location == null) {
            return false;
        }
        Location resumeLocation = location;
        Location nextLocationAfterResume = DebuggerUtil.getLocationOfNextInstructionAfterResume(resumeLocation);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var10_10 = $this$debug_u24default$iv;
            boolean bl = false;
            Location location3 = nextLocationAfterResume;
            var10_10.debug("Trying to set a resume breakpoint in the current method: resumeMethod: " + SafeUtilKt.safeMethod(resumeLocation) + ", nextCallLocationLine = " + (location3 != null ? Integer.valueOf(location3.lineNumber()) : null), e$iv);
        }
        return this.installCoroutineResumedBreakpoint(suspendContext, resumeLocation, nextLocationAfterResume);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean installResumeBreakpointInCallerMethod(@NotNull SuspendContextImpl suspendContext) {
        void $this$debug_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Object object = StackFrameInterceptor.Companion.getInstance();
        if (object == null || (object = object.callerLocation(suspendContext)) == null) {
            return false;
        }
        Object resumeLocation = object;
        Location nextLocationAfterResume = DebuggerUtil.getLocationOfNextInstructionAfterResume((Location)resumeLocation);
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var8_8 = $this$debug_u24default$iv;
            boolean bl = false;
            Location location = nextLocationAfterResume;
            var8_8.debug("Trying to set a resume breakpoint in the caller method: resumeMethod: " + SafeUtilKt.safeMethod((Location)resumeLocation) + ", nextCallLocationLine = " + (location != null ? Integer.valueOf(location.lineNumber()) : null), e$iv);
        }
        return this.installCoroutineResumedBreakpoint(suspendContext, (Location)resumeLocation, nextLocationAfterResume);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean installCoroutineResumedBreakpoint(SuspendContextImpl context, Location resumedLocation, Location nextLocationAfterResume) {
        void $this$debug_u24default$iv;
        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        DebugProcessImpl debugProcess = debugProcessImpl;
        debugProcess.cancelRunToCursorBreakpoint();
        Project project = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        boolean useCoroutineIdFiltering = Registry.Companion.is("debugger.filter.breakpoints.by.coroutine.id");
        Method method = SafeUtilKt.safeMethod(resumedLocation);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        if (debugProcess.getRequestsManager().getFilterThread() == null) {
            CoroutineBreakpointFacility $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Coroutine filter should be calculated and set before breakpoint request created. In other case, this breakpoint may be hit while intermediate evaluations on other threads before the filter will be set.");
        }
        String $i$f$thisLogger = method2.declaringType().name();
        String string = method2.name();
        String string2 = method2.signature();
        StepIntoMethodBreakpoint breakpoint2 = new StepIntoMethodBreakpoint(project2, debugProcess, nextLocationAfterResume, context, $i$f$thisLogger, string, string2){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ Location $nextLocationAfterResume;
            final /* synthetic */ SuspendContextImpl $context;
            {
                this.$debugProcess = $debugProcess;
                this.$nextLocationAfterResume = $nextLocationAfterResume;
                this.$context = $context;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $project);
            }

            public boolean isRestoreBreakpoints() {
                return false;
            }

            protected boolean stopOnlyInBaseClass() {
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) {
                void $this$debug_u24default$iv;
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                installCoroutineResumedBreakpoint.breakpoint.1 $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(installCoroutineResumedBreakpoint.breakpoint.1.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = logger;
                SuspendContextImpl suspendContextImpl = this.$context;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var8_9 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var8_9.debug("Hit the resume breakpoint at " + suspendContextImpl.getLocation(), e$iv);
                }
                boolean result2 = super.processLocatableEvent(action, event);
                if (result2) {
                    this.$debugProcess.getRequestsManager().deleteRequest((Requestor)this);
                }
                if (!result2) {
                    return false;
                }
                SuspendContextImpl suspendContextImpl2 = action.getSuspendContext();
                if (suspendContextImpl2 == null) {
                    return true;
                }
                SuspendContextImpl suspendContextImpl3 = suspendContextImpl2;
                return this.scheduleStepOverCommandForSuspendSwitch(suspendContextImpl3, this.$nextLocationAfterResume);
            }

            private final boolean scheduleStepOverCommandForSuspendSwitch(SuspendContextImpl it, Location nextLocationAfterResume) {
                DebuggerSteppingHelper.INSTANCE.createStepOverCommandForSuspendSwitch(it, nextLocationAfterResume).prepareSteppingRequestsAndHints(it);
                return false;
            }
        };
        breakpoint2.setSuspendPolicy(context.getSuspendPolicyFromRequestors());
        if (!useCoroutineIdFiltering) {
            CoroutineBreakpointFacilityKt.access$applyEmptyThreadFilter(debugProcess);
        }
        breakpoint2.createRequest(debugProcess);
        debugProcess.setSteppingBreakpoint((SteppingBreakpoint)breakpoint2);
        LightOrRealThreadInfo filterThread = debugProcess.getRequestsManager().getFilterThread();
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger2 = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var14_16 = $this$debug_u24default$iv;
            boolean bl = false;
            var14_16.debug("Resume breakpoint for " + method2 + " in thread " + filterThread, e$iv);
        }
        return true;
    }
}

